/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.core.model;

import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClient;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClientException;
import org.bioimageanalysis.icy.icytomine.core.model.Entity;
import org.bioimageanalysis.icy.icytomine.core.model.Image;
import org.bioimageanalysis.icy.icytomine.core.model.Ontology;
import org.bioimageanalysis.icy.icytomine.core.model.User;

public class Project
extends Entity {
    private List<User> users;
    private List<Image> images;

    public static Project retrieve(CytomineClient client, long projectId) throws CytomineClientException {
        return client.getProject(projectId);
    }

    public Project(CytomineClient client, be.cytomine.client.models.Project internalProject) {
        super(client, internalProject);
    }

    public be.cytomine.client.models.Project getInternalProject() {
        return (be.cytomine.client.models.Project)this.getModel();
    }

    public Optional<String> getName() {
        return this.getStr("name");
    }

    public Optional<Long> getOntologyId() {
        return super.getLong("ontology");
    }

    public Optional<String> getOntologyName() {
        return this.getStr("ontologyName");
    }

    public Optional<Long> getNumberOfImages() {
        return this.getLong("numberOfImages");
    }

    public Optional<Long> getNumberOfAnnotations() {
        return this.getLong("numberOfAnnotations");
    }

    public Optional<Long> getNumberOfJobAnnotations() {
        return this.getLong("numberOfJobAnnotations");
    }

    public Long getTotalNumberOfAnnotations() {
        return this.getNumberOfAnnotations().orElse(0L) + this.getNumberOfJobAnnotations().orElse(0L);
    }

    public List<User> getUsers(boolean recompute) throws CytomineClientException {
        if (this.users == null || recompute) {
            this.users = null;
            this.users = this.getClient().getProjectUsers(this.getId());
        }
        return this.users;
    }

    public Ontology getOntology() throws NoSuchElementException, CytomineClientException {
        Long ontologyId = this.getOntologyId().get();
        return Ontology.retrieve(this.getClient(), ontologyId);
    }

    public List<Image> getImages(boolean recompute) throws CytomineClientException {
        if (this.images == null || recompute) {
            this.images = null;
            this.images = this.getClient().getProjectImages(this.getId());
        }
        return this.images;
    }

    public Image getImageInstance(long imageInstanceId) throws CytomineClientException {
        return this.getClient().getImageInstance(imageInstanceId);
    }

    @Override
    public String toString() {
        return String.format("Project: id=%s, name=%s", String.valueOf(this.getId()), this.getName().orElse("Not specified"));
    }
}

