/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.login;

import icy.gui.dialog.ConfirmDialog;
import icy.gui.dialog.MessageDialog;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.bioimageanalysis.icy.icytomine.core.connection.CytomineConnector;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClient;
import org.bioimageanalysis.icy.icytomine.core.connection.persistence.Preferences;
import org.bioimageanalysis.icy.icytomine.core.connection.persistence.UserCredential;
import org.bioimageanalysis.icy.icytomine.ui.core.login.AddHostDialog;
import org.bioimageanalysis.icy.icytomine.ui.core.login.AddUserDialog;
import org.bioimageanalysis.icy.icytomine.ui.core.login.EditHostDialog;
import org.bioimageanalysis.icy.icytomine.ui.core.login.EditUserDialog;
import org.bioimageanalysis.icy.icytomine.ui.core.login.LoginPanel;

public class LoginPanelController {
    private LoginPanel panel;
    private Set<LoginListener> loginListeners;
    private Preferences preferences;

    public LoginPanelController(LoginPanel panel) {
        this.panel = panel;
        this.loginListeners = new HashSet<LoginListener>();
        this.preferences = Preferences.getInstance();
        this.setEventHandlers();
    }

    private void setEventHandlers() {
        this.panel.addHostServerSelectionListener(this.getHostServerSelectionEventHandler());
        this.panel.addAddHostButtonListener(this.getHostAdditionEventHandler());
        this.panel.addRemoveHostButtonListener(this.getHostRemovalEventHandler());
        this.panel.addEditHostButtonListener(this.getHostEditionEventHandler());
        this.panel.addAddUserButtonListener(this.getUserAdditionEventHandler());
        this.panel.addRemoveUserButtonListener(this.getRemoveUserEventHandler());
        this.panel.addEditUserButtonListener(this.getUserEditionEventHandler());
        this.panel.addLoginButtonListener(this.getLoginButtonEventHandler());
    }

    private ItemListener getHostServerSelectionEventHandler() {
        return e -> {
            if (e.getStateChange() == 1) {
                String host = (String)e.getItem();
                this.setUsersForHost(host);
            }
        };
    }

    private void setUsersForHost(String host) {
        Set<String> users = this.preferences.getAvailableCytomineCredentials().getOrDefault(host, new HashMap()).keySet();
        Optional<String> userSelection = this.preferences.getDefaultUserName();
        if (userSelection.isPresent()) {
            this.panel.setUsers(users, userSelection);
        } else {
            this.panel.setUsers(users, Optional.ofNullable(null));
        }
    }

    private ActionListener getHostAdditionEventHandler() {
        return event -> {
            AddHostDialog dialog = new AddHostDialog(this.panel.getParentFrame());
            dialog.setHostAdditionListener(hostName -> {
                if (hostName == null || hostName.isEmpty()) {
                    throw new RuntimeException("No host was specified. Try again.");
                }
                try {
                    CytomineConnector.addHostIfAbsent(new URL(hostName));
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException("Host URL (" + Objects.toString(hostName) + ") is not valid. Try again.", e);
                }
                try {
                    Preferences.save();
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not save the host to preferences file.", e);
                }
            });
            dialog.setVisible(true);
            this.updateCredentials();
        };
    }

    void updateCredentials() {
        Set<String> hosts = this.preferences.getAvailableCytomineCredentials().keySet();
        Optional<String> selection = this.preferences.getDefaultHostURL();
        if (selection.isPresent()) {
            this.panel.setHosts(hosts, selection);
        } else {
            this.panel.setHosts(hosts, Optional.ofNullable(null));
        }
    }

    private ActionListener getHostRemovalEventHandler() {
        return event -> {
            Optional<String> selectedHost = this.panel.getSelectedHost();
            if (!selectedHost.isPresent()) {
                MessageDialog.showDialog((String)"Login error - Remove host", (String)"Please select a host", (int)0);
                return;
            }
            if (!ConfirmDialog.confirm((String)"Remove Host Locally - Icytomine", (String)("Are you sure to locally remove host " + selectedHost.get()), (int)0)) {
                return;
            }
            try {
                CytomineConnector.removeHost(new URL(selectedHost.get()));
                Preferences.save();
            }
            catch (IOException | IllegalArgumentException e) {
                MessageDialog.showDialog((String)"Login error - Remove user", (String)e.getMessage(), (int)0);
            }
            this.updateCredentials();
        };
    }

    private ActionListener getHostEditionEventHandler() {
        return event -> {
            Optional<String> selectedHost = this.panel.getSelectedHost();
            if (!selectedHost.isPresent()) {
                MessageDialog.showDialog((String)"Login error - Edit user", (String)"Please select a host", (int)0);
                return;
            }
            EditHostDialog dialog = new EditHostDialog(this.panel.getParentFrame(), selectedHost.get());
            dialog.setHostEditionListener((oldHostName, newHostName) -> {
                if (newHostName == null || newHostName.isEmpty()) {
                    throw new RuntimeException("No host was specified. Try again.");
                }
                try {
                    CytomineConnector.updateHost(new URL(oldHostName), new URL(newHostName));
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException("Host URL (" + Objects.toString(newHostName) + ") is not valid. Try again.", e);
                }
                try {
                    Preferences.save();
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not save the host to preferences file.", e);
                }
            });
            dialog.setVisible(true);
            this.updateCredentials();
        };
    }

    private ActionListener getUserAdditionEventHandler() {
        return event -> {
            Optional<String> selectedHost = this.panel.getSelectedHost();
            if (!selectedHost.isPresent()) {
                MessageDialog.showDialog((String)"Login error - Add user", (String)"Please select a host", (int)0);
                return;
            }
            AddUserDialog dialog = new AddUserDialog(this.panel.getParentFrame(), selectedHost.get());
            dialog.setUserAdditionListener((hostName, userName, publicKey, privateKey) -> {
                if (hostName == null || hostName.isEmpty()) {
                    throw new RuntimeException("The host is empty. Try again");
                }
                if (userName == null || userName.isEmpty()) {
                    throw new RuntimeException("The user name is empty. Try again");
                }
                if (publicKey == null || publicKey.isEmpty()) {
                    throw new RuntimeException("The public key is empty. Try again");
                }
                if (privateKey == null || privateKey.isEmpty()) {
                    throw new RuntimeException("The private key is empty. Try again");
                }
                try {
                    CytomineConnector.addUser(new URL(hostName), userName, publicKey, privateKey);
                }
                catch (MalformedURLException ex) {
                    throw new RuntimeException("Host URL (" + Objects.toString(hostName) + ") is not valid. Try again.", ex);
                }
                try {
                    Preferences.save();
                }
                catch (IOException ex) {
                    throw new RuntimeException("Could not save the user to preferences file.", ex);
                }
            });
            dialog.setVisible(true);
            this.updateCredentials();
        };
    }

    private ActionListener getRemoveUserEventHandler() {
        return event -> {
            Optional<String> selectedHost = this.panel.getSelectedHost();
            Optional<String> selectedUser = this.panel.getSelectedUser();
            if (!selectedHost.isPresent() || !selectedUser.isPresent()) {
                MessageDialog.showDialog((String)"Login error - Remove user", (String)"Please select a host and a user", (int)0);
                return;
            }
            if (!ConfirmDialog.confirm((String)"Remove User Locally - Icytomine", (String)("Are you sure to locally remove user " + selectedUser.get()), (int)0)) {
                return;
            }
            try {
                CytomineConnector.removeUser(new URL(selectedHost.get()), selectedUser.get());
                Preferences.save();
            }
            catch (IOException | IllegalArgumentException e) {
                MessageDialog.showDialog((String)"Login error - Remove user", (String)e.getMessage(), (int)0);
            }
            this.updateCredentials();
        };
    }

    private ActionListener getUserEditionEventHandler() {
        return event -> {
            Optional<String> selectedHost = this.panel.getSelectedHost();
            Optional<String> selectedUser = this.panel.getSelectedUser();
            if (!selectedHost.isPresent() || !selectedUser.isPresent()) {
                MessageDialog.showDialog((String)"Login error - Edit user", (String)"Please select a host and a user", (int)0);
                return;
            }
            UserCredential userCredentials = Preferences.getInstance().getAvailableCytomineCredentials().get(selectedHost.get()).get(selectedUser.get());
            EditUserDialog dialog = new EditUserDialog(this.panel.getParentFrame(), selectedHost.get(), selectedUser.get(), userCredentials);
            dialog.setUserUpdateListener((hostName, oldUserName, userName, publicKey, privateKey) -> {
                if (userName == null || userName.isEmpty()) {
                    throw new RuntimeException("The user name is empty. Try again");
                }
                if (publicKey == null || publicKey.isEmpty()) {
                    throw new RuntimeException("The public key is empty. Try again");
                }
                if (privateKey == null || privateKey.isEmpty()) {
                    throw new RuntimeException("The private key is empty. Try again");
                }
                try {
                    CytomineConnector.updateUser(new URL(hostName), oldUserName, new URL(hostName), userName, publicKey, privateKey);
                }
                catch (MalformedURLException ex) {
                    throw new RuntimeException("Host URL (" + Objects.toString(hostName) + ") is not valid. Try again.", ex);
                }
                try {
                    Preferences.save();
                }
                catch (IOException ex) {
                    throw new RuntimeException("Could not save the user to preferences file.", ex);
                }
            });
            dialog.setVisible(true);
            this.updateCredentials();
        };
    }

    private MouseListener getLoginButtonEventHandler() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                CytomineClient client;
                Optional<String> selectedHost = LoginPanelController.this.panel.getSelectedHost();
                Optional<String> selectedUser = LoginPanelController.this.panel.getSelectedUser();
                if (!selectedHost.isPresent() || !selectedUser.isPresent()) {
                    MessageDialog.showDialog((String)"Login error", (String)"Please select a host and a user", (int)0);
                    return;
                }
                try {
                    client = LoginPanelController.this.login(selectedHost.get(), selectedUser.get());
                }
                catch (IllegalArgumentException | InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                    MessageDialog.showDialog((String)"Login error", (String)e.getMessage(), (int)0);
                    return;
                }
                try {
                    LoginPanelController.this.setDefaultCredentials(selectedHost.get(), selectedUser.get());
                }
                catch (IOException e) {
                    e.printStackTrace();
                    MessageDialog.showDialog((String)"Credentials update error", (String)e.getMessage(), (int)0);
                }
                LoginPanelController.this.notifyLoginListeners(client);
            }
        };
    }

    private CytomineClient login(String host, String userName) throws IllegalArgumentException, InterruptedException, ExecutionException {
        Future<CytomineClient> connectionResult;
        try {
            connectionResult = CytomineConnector.login(new URL(host), userName);
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            throw new IllegalArgumentException(String.format("Invalid host: %s", host), e);
        }
        return connectionResult.get();
    }

    private void setDefaultCredentials(String host, String userName) throws IOException {
        this.preferences.setDefaultHost(host);
        this.preferences.setDefaultUser(userName);
        Preferences.save();
    }

    private void notifyLoginListeners(CytomineClient client) {
        this.loginListeners.forEach(l -> l.logged(client));
    }

    public void addLoginListener(LoginListener listener) {
        this.loginListeners.add(listener);
    }

    public void removeLoginListener(LoginListener listener) {
        this.loginListeners.remove(listener);
    }

    @FunctionalInterface
    public static interface LoginListener {
        public void logged(CytomineClient var1);
    }
}

