/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.viewer;

import icy.resource.ResourceUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.view.ViewCanvasPanel;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.controller.view.provider.ViewProvider;
import org.japura.gui.SplitButton;

public class ViewerPanel
extends JPanel {
    private static final DecimalFormat bigDecimalFormatter = new DecimalFormat("###.##");
    private static final DecimalFormat smallDecimalFormatter = new DecimalFormat("###.###");
    private ViewProvider viewProvider;
    private JToolBar toolBar;
    private JButton btnZoomout;
    private JComboBox<String> zoomLevelComboBox;
    private JButton btnZoomin;
    private JButton annotationsButton;
    private JButton refreshButton;
    private SplitButton downloadSplitButton;
    private SplitButton uploadSplitButton;
    private JLayeredPane layeredViewPane;
    private ViewCanvasPanel viewCanvasPanel;
    private JPanel statusBar;
    private JLabel statusIcon;
    private JLabel statusMessage;
    private JLabel cursorPositionLabel;
    private JLabel cursorPixelColorLabel;
    private Set<ZoomEventListener> zoomLevelListeners;
    private double zoomLimit;
    private boolean changingZoomLevelText;

    public ViewerPanel(ViewProvider viewProvider) {
        this.viewProvider = viewProvider;
        this.setPreferredSize(new Dimension(620, 400));
        this.zoomLevelListeners = new HashSet<ZoomEventListener>();
        this.changingZoomLevelText = false;
        this.buildComponents();
    }

    private void buildComponents() {
        this.setLayout(new BorderLayout(0, 0));
        this.buildToolBar();
        this.buildLayeredViewPane();
        this.buildStatusBar();
        this.add((Component)this.toolBar, "North");
        this.add((Component)this.layeredViewPane, "Center");
        this.add((Component)this.statusBar, "South");
    }

    private void buildToolBar() {
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        this.btnZoomout = new JButton("-");
        this.btnZoomout.setMinimumSize(new Dimension(30, 23));
        this.btnZoomout.setPreferredSize(new Dimension(30, 23));
        this.toolBar.add(this.btnZoomout);
        this.zoomLevelComboBox = new JComboBox();
        this.zoomLevelComboBox.setEditable(true);
        this.zoomLevelComboBox.setPreferredSize(new Dimension(120, 20));
        this.zoomLevelComboBox.setMaximumSize(new Dimension(200, Short.MAX_VALUE));
        this.zoomLevelComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"1X", "2X", "4X", "10X", "20X", "40X"}));
        this.zoomLevelComboBox.setMinimumSize(new Dimension(70, 20));
        this.zoomLevelComboBox.addItemListener(e -> {
            if (!this.changingZoomLevelText) {
                double level = Double.parseDouble(((String)e.getItem()).split("[ Xx]+")[0]);
                this.selectSpecificZoomLevel(level);
            }
        });
        this.toolBar.add(this.zoomLevelComboBox);
        this.btnZoomin = new JButton("+");
        this.btnZoomin.setMinimumSize(new Dimension(30, 23));
        this.btnZoomin.setPreferredSize(new Dimension(30, 23));
        this.toolBar.add(this.btnZoomin);
        Image annotationsIcon = null;
        Image refreshIcon = null;
        annotationsIcon = ResourceUtil.ICON_ROI_POLYGON.getScaledInstance(20, 20, 4);
        refreshIcon = ResourceUtil.ICON_RELOAD.getScaledInstance(20, 20, 4);
        this.annotationsButton = new JButton("Annotations");
        this.annotationsButton.setIcon(new ImageIcon(annotationsIcon));
        this.toolBar.add(this.annotationsButton);
        this.refreshButton = new JButton("Refresh");
        this.refreshButton.setIcon(new ImageIcon(refreshIcon));
        this.toolBar.add(this.refreshButton);
        JSeparator separator_1 = new JSeparator();
        this.toolBar.add(separator_1);
        this.downloadSplitButton = new SplitButton(SplitButton.BUTTON);
        this.downloadSplitButton.setText("Download");
        this.downloadSplitButton.setToolTipText("Download the current view to Icy");
        this.downloadSplitButton.addButton("Download");
        this.downloadSplitButton.addButton("Custom download");
        this.toolBar.add(this.downloadSplitButton);
        this.uploadSplitButton = new SplitButton(SplitButton.BUTTON);
        this.uploadSplitButton.setText("Upload");
        this.uploadSplitButton.setToolTipText("Updload to Cytomine server");
        this.uploadSplitButton.addButton("Upload from image");
        this.uploadSplitButton.addButton("Upload from file");
        this.toolBar.add(this.uploadSplitButton);
    }

    private void buildLayeredViewPane() {
        this.layeredViewPane = new JLayeredPane();
        this.buildViewCanvasPanel();
        this.addComponentsInLayers();
        this.setViewPanelAutoResize();
    }

    private void buildViewCanvasPanel() {
        this.viewCanvasPanel = new ViewCanvasPanel(this.viewProvider);
        this.viewCanvasPanel.setBounds(0, 0, 620, 355);
    }

    private void selectSpecificZoomLevel(double newZoomLevel) {
        this.zoomLevelListeners.forEach(l -> l.zoomChanged(newZoomLevel));
    }

    private void addComponentsInLayers() {
        this.addInLayer(this.viewCanvasPanel, 0);
    }

    private void addInLayer(JComponent component, int z) {
        this.layeredViewPane.setLayout(null);
        this.layeredViewPane.add(component);
        this.layeredViewPane.setLayer(component, z);
    }

    private void setViewPanelAutoResize() {
        this.addComponentListener(new ViewPanelResizeToParentListener());
    }

    private void buildStatusBar() {
        this.statusBar = new JPanel();
        GridBagLayout statusBarLayout = new GridBagLayout();
        statusBarLayout.columnWidths = new int[]{16, 0, 0, 0};
        statusBarLayout.rowHeights = new int[]{1};
        statusBarLayout.columnWeights = new double[]{0.0, 1.0, 0.0, 0.0};
        statusBarLayout.rowWeights = new double[]{0.0};
        this.statusBar.setLayout(statusBarLayout);
        this.statusIcon = new JLabel("");
        this.statusIcon.setBorder(null);
        this.statusIcon.setIcon(new ImageIcon(ResourceUtil.ICON_DATABASE));
        GridBagConstraints statusIconConstraints = new GridBagConstraints();
        statusIconConstraints.anchor = 17;
        statusIconConstraints.insets = new Insets(0, 0, 0, 5);
        statusIconConstraints.gridx = 0;
        statusIconConstraints.gridy = 0;
        this.statusBar.add((Component)this.statusIcon, statusIconConstraints);
        this.statusMessage = new JLabel("status...");
        GridBagConstraints statusLabelConstraints = new GridBagConstraints();
        statusLabelConstraints.anchor = 17;
        statusLabelConstraints.fill = 2;
        statusLabelConstraints.insets = new Insets(0, 0, 0, 5);
        statusLabelConstraints.gridx = 1;
        statusLabelConstraints.gridy = 0;
        this.statusBar.add((Component)this.statusMessage, statusLabelConstraints);
        this.cursorPositionLabel = new JLabel("Position: x=13 px (54.4 \u00b5m), y=434 px (549 \u00b5m)");
        GridBagConstraints positionLabelConstraints = new GridBagConstraints();
        positionLabelConstraints.anchor = 17;
        positionLabelConstraints.insets = new Insets(0, 0, 0, 5);
        positionLabelConstraints.gridx = 2;
        positionLabelConstraints.gridy = 0;
        this.statusBar.add((Component)this.cursorPositionLabel, positionLabelConstraints);
        this.cursorPixelColorLabel = new JLabel("");
        this.cursorPixelColorLabel.setBackground(Color.GREEN);
        this.cursorPixelColorLabel.setOpaque(true);
        this.cursorPixelColorLabel.setPreferredSize(new Dimension(14, 14));
        GridBagConstraints pixelColorLabelConstraints = new GridBagConstraints();
        pixelColorLabelConstraints.gridx = 3;
        pixelColorLabelConstraints.gridy = 0;
        this.statusBar.add((Component)this.cursorPixelColorLabel, pixelColorLabelConstraints);
        this.viewProvider.addViewProcessListener(isProcessing -> {
            this.statusIcon.setVisible(isProcessing);
            if (isProcessing) {
                this.statusMessage.setText("Retreiving image from server...");
            } else {
                this.statusMessage.setText("Ready...");
            }
        });
    }

    public ViewCanvasPanel getViewCanvasPanel() {
        return this.viewCanvasPanel;
    }

    public void setCursorPosition(Point2D position, Point2D positionInMicrons) {
        this.cursorPositionLabel.setText(String.format("Position: x=%.2f px (%.2f \u00b5m), y=%.2f px (%.2f \u00b5m)", position.getX(), positionInMicrons.getX(), position.getY(), positionInMicrons.getY()));
    }

    public void addZoomInListener(ActionListener listener) {
        this.btnZoomin.addActionListener(listener);
    }

    public void addZoomOutListener(ActionListener listener) {
        this.btnZoomout.addActionListener(listener);
    }

    public void addZoomLevelSelectedListener(ZoomEventListener listener) {
        this.zoomLevelListeners.add(listener);
    }

    public void setZoomLevel(double zoomLevel) {
        this.changingZoomLevelText = true;
        DecimalFormat formatter = null;
        formatter = zoomLevel < 1.0 ? smallDecimalFormatter : bigDecimalFormatter;
        this.zoomLevelComboBox.setSelectedItem(String.format(formatter.format(zoomLevel) + " X", zoomLevel));
        this.changingZoomLevelText = false;
        if (zoomLevel <= this.zoomLimit) {
            this.zoomLevelComboBox.getEditor().getEditorComponent().setForeground(Color.BLACK);
        } else {
            this.zoomLevelComboBox.getEditor().getEditorComponent().setForeground(Color.RED);
        }
    }

    public void setZoomLimit(double limit) {
        this.zoomLimit = limit;
    }

    public void addCytomineToIcyMenuListener(ActionListener actionListener) {
        this.downloadSplitButton.addActionListener("Download", actionListener);
    }

    public void addCustomCytomineToIcyMenuListener(ActionListener actionListener) {
        this.downloadSplitButton.addActionListener("Custom download", actionListener);
    }

    public void addIcySequenceToCytomineMenuListener(ActionListener actionListener) {
        this.uploadSplitButton.addActionListener("Upload from image", actionListener);
    }

    public void addIcyFileToCytomineMenuListener(ActionListener actionListener) {
        this.uploadSplitButton.addActionListener("Upload from file", actionListener);
    }

    public void addIcyFolderToCytomineMenuListener(ActionListener actionListener) {
    }

    public void addAnnotationFilterMenuListener(ActionListener listener) {
        this.annotationsButton.addActionListener(listener);
    }

    public void addAnnotationRefreshMenuListener(ActionListener listener) {
        this.refreshButton.addActionListener(listener);
    }

    public final class ViewPanelResizeToParentListener
    extends ComponentAdapter {
        @Override
        public void componentResized(ComponentEvent e) {
            ViewerPanel.this.viewCanvasPanel.setSize(ViewerPanel.this.viewCanvasPanel.getParent().getSize());
        }
    }

    public static interface ZoomEventListener {
        public void zoomChanged(double var1);
    }
}

