/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.viewer;

import icy.gui.frame.IcyFrame;
import icy.gui.frame.IcyFrameAdapter;
import icy.gui.frame.IcyFrameEvent;
import icy.gui.frame.IcyFrameListener;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import javax.swing.JPanel;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.ViewerPanel;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.annotations.AnnotationManagerPanel;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.annotations.AnnotationManagerPanelController;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.annotations.AnnotationTable;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.cytomine2Icy.CytomineToIcyPanel;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.icy2Cytomine.file.IcyFileToCytominePanel;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.icy2Cytomine.folder.IcyFolderToCytominePanel;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.icy2Cytomine.sequence.IcySequenceToCytominePanel;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.controller.view.ViewController;

public class ViewerPanelController {
    private ViewerPanel viewerContainer;
    private ViewController viewController;
    private IcyFrame annotationsFrame;
    private IcyFrame cytomineToIcyFrame;
    private IcyFrame icySequenceToCytomineFrame;
    private IcyFrame icyFileToCytomineFrame;
    private IcyFrame icyFolderToCytomineFrame;

    public ViewerPanelController(ViewerPanel viewerContainer) {
        this.viewerContainer = viewerContainer;
    }

    public void startViewer() {
        this.viewController = this.viewerContainer.getViewCanvasPanel().getViewController();
        this.setViewControllerListeners();
        this.setViewerContainerListeners();
        this.viewerContainer.setZoomLimit(this.getZoomLevel(0.0));
        this.viewController.adjustImageZoomToView();
    }

    private void setViewControllerListeners() {
        this.viewController.addCursorPositionListener(newPosition -> this.viewerContainer.setCursorPosition(newPosition, this.getPositionInMicrons(newPosition)));
        this.viewController.addResolutionListener(newResolution -> this.viewerContainer.setZoomLevel(this.getZoomLevel(newResolution)));
        this.viewController.addAnnotationSelectionListener(this.getAnnotationSelectionHandler());
    }

    private Point2D getPositionInMicrons(Point2D position) {
        double pixelSize = this.viewController.getImageInformation().getResolution().orElse(0.0);
        return new Point2D.Double(position.getX() * pixelSize, position.getY() * pixelSize);
    }

    private double getZoomLevel(double resolutionLevel) {
        int intMagnification = this.viewController.getImageInformation().getMagnification().orElse(1);
        double magnification = intMagnification;
        return magnification /= Math.pow(2.0, resolutionLevel);
    }

    private AnnotationTable.AnnotationSelectionListener getAnnotationSelectionHandler() {
        return selectedAnnotations -> {
            if (this.annotationsFrame != null) {
                ((AnnotationManagerPanel)this.annotationsFrame.getContentPane()).selectAnnotations(selectedAnnotations);
            }
        };
    }

    private void setViewerContainerListeners() {
        this.viewerContainer.addZoomInListener(e -> this.viewController.zoomIn());
        this.viewerContainer.addZoomOutListener(e -> this.viewController.zoomOut());
        this.viewerContainer.addZoomLevelSelectedListener(zoomLevel -> this.viewController.setResolution(this.getResolutionLevel(zoomLevel)));
        this.viewerContainer.addAnnotationFilterMenuListener(this.getAnnotationMenuHandler());
        this.viewerContainer.addAnnotationRefreshMenuListener(this.getAnnotationRefreshMenuHandler());
        this.viewerContainer.addCytomineToIcyMenuListener(this.getCytomineToIcyMenuHandler());
        this.viewerContainer.addIcySequenceToCytomineMenuListener(this.getIcySequenceToCytomineMenuHandler());
        this.viewerContainer.addIcyFileToCytomineMenuListener(this.getIcyFileToCytomineMenuHandler());
        this.viewerContainer.addIcyFolderToCytomineMenuListener(this.getIcyFolderToCytomineMenuHandler());
    }

    private double getResolutionLevel(double zoomLevel) {
        int intMagnification = this.viewController.getImageInformation().getMagnification().orElse(1);
        double magnification = intMagnification;
        return Math.log(magnification / zoomLevel) / Math.log(2.0);
    }

    private ActionListener getAnnotationMenuHandler() {
        return e -> {
            System.out.println("Opening annotations menu...");
            if (this.annotationsFrame != null) {
                this.annotationsFrame.close();
            }
            AnnotationManagerPanel annotationsPanel = new AnnotationManagerPanel(this.viewController.getImageInformation());
            annotationsPanel.addAnnotationsVisibilityListener(newVisibleAnnotations -> this.viewController.setVisibileAnnotations(newVisibleAnnotations));
            AnnotationTable.AnnotationSelectionListener selectionListener = selectedAnnotations -> this.viewController.setSelectedAnnotations(selectedAnnotations);
            annotationsPanel.addAnnotationSelectionListener(selectionListener);
            annotationsPanel.addAnnotationDoubleClickListener(a -> this.viewController.focusOnAnnotation(a));
            annotationsPanel.addAnnotationTermSelectionCommitListener(this.getAnnotationTermCommitHandler(annotationsPanel));
            annotationsPanel.addAnnonationDeletionListener(this.getAnnotationDeletionHandler(annotationsPanel));
            this.annotationsFrame = ViewerPanelController.createIcyDialog("Annotations - Icytomine", annotationsPanel, true);
            this.annotationsFrame.setSize(new Dimension(400, 400));
            selectionListener.selectionChanged(this.viewController.getViewProvider().getSelectedAnnotations());
            this.annotationsFrame.setVisible(true);
        };
    }

    private AnnotationManagerPanelController.AnnotationTermCommitListener getAnnotationTermCommitHandler(AnnotationManagerPanel annotationsPanel) {
        return annotations -> {
            this.viewController.updateAnnotations(false);
            annotationsPanel.updateAnnotations();
            this.viewController.refreshView();
        };
    }

    private AnnotationManagerPanelController.AnnotationDeletionListener getAnnotationDeletionHandler(AnnotationManagerPanel annotationsPanel) {
        return annotations -> {
            this.viewController.updateAnnotations(false);
            annotationsPanel.updateAnnotations();
            this.viewController.refreshView();
        };
    }

    private ActionListener getAnnotationRefreshMenuHandler() {
        return event -> {
            this.viewController.updateAnnotations(true);
            this.viewController.refreshView();
        };
    }

    private static IcyFrame createIcyDialog(String title, JPanel contentPane, boolean resizable) {
        IcyFrame frame = new IcyFrame(title, resizable, true, false, false);
        frame.setDefaultCloseOperation(2);
        frame.setMinimumSize(new Dimension(10, 10));
        frame.setContentPane((Container)contentPane);
        frame.setSize(contentPane.getPreferredSize());
        frame.addToDesktopPane();
        frame.center();
        frame.setAlwaysOnTop(true);
        return frame;
    }

    private ActionListener getCytomineToIcyMenuHandler() {
        return e -> {
            System.out.println("Opening cytomine -> icy dialog...");
            if (this.cytomineToIcyFrame != null) {
                this.cytomineToIcyFrame.close();
            }
            final CytomineToIcyPanel contentPane = new CytomineToIcyPanel(this.viewController);
            this.cytomineToIcyFrame = ViewerPanelController.createIcyDialog("Download view from Cytomine - Icytomine", contentPane, false);
            contentPane.addCloseListener(a -> this.cytomineToIcyFrame.close());
            this.cytomineToIcyFrame.addFrameListener((IcyFrameListener)new IcyFrameAdapter(){

                public void icyFrameClosed(IcyFrameEvent e) {
                    contentPane.getController().close();
                }
            });
            this.cytomineToIcyFrame.setVisible(true);
        };
    }

    private ActionListener getIcySequenceToCytomineMenuHandler() {
        return e -> {
            System.out.println("Opening icy sequence -> cytomine dialog...");
            if (this.icySequenceToCytomineFrame != null) {
                this.icySequenceToCytomineFrame.close();
            }
            final IcySequenceToCytominePanel contentPane = new IcySequenceToCytominePanel(this.viewController);
            this.icySequenceToCytomineFrame = ViewerPanelController.createIcyDialog("Send Sequence ROIs to Cytomine - Icytomine", contentPane, false);
            contentPane.addCloseListener(a -> this.icySequenceToCytomineFrame.close());
            this.icySequenceToCytomineFrame.addFrameListener((IcyFrameListener)new IcyFrameAdapter(){

                public void icyFrameClosed(IcyFrameEvent e) {
                    contentPane.getController().close();
                }
            });
            this.icySequenceToCytomineFrame.setVisible(true);
        };
    }

    private ActionListener getIcyFileToCytomineMenuHandler() {
        return e -> {
            System.out.println("Opening icy file -> cytomine dialog...");
            if (this.icyFileToCytomineFrame != null) {
                this.icyFileToCytomineFrame.close();
            }
            final IcyFileToCytominePanel contentPane = new IcyFileToCytominePanel(this.viewController);
            this.icyFileToCytomineFrame = ViewerPanelController.createIcyDialog("Send File ROIs to Cytomine - Icytomine", contentPane, false);
            contentPane.getController().addCloseListener(a -> this.icyFileToCytomineFrame.close());
            this.icyFileToCytomineFrame.addFrameListener((IcyFrameListener)new IcyFrameAdapter(){

                public void icyFrameClosed(IcyFrameEvent e) {
                    contentPane.getController().close();
                }
            });
            this.icyFileToCytomineFrame.setVisible(true);
        };
    }

    private ActionListener getIcyFolderToCytomineMenuHandler() {
        return e -> {
            System.out.println("Opening icy folder -> cytomine dialog...");
            if (this.icyFolderToCytomineFrame != null) {
                this.icyFolderToCytomineFrame.close();
            }
            final IcyFolderToCytominePanel contentPane = new IcyFolderToCytominePanel(this.viewController);
            this.icyFolderToCytomineFrame = ViewerPanelController.createIcyDialog("Send Folder ROIs to Cytomine - Icytomine", contentPane, false);
            contentPane.getController().addCloseListener(a -> this.icyFolderToCytomineFrame.close());
            this.icyFolderToCytomineFrame.addFrameListener((IcyFrameListener)new IcyFrameAdapter(){

                public void icyFrameClosed(IcyFrameEvent e) {
                    contentPane.getController().close();
                }
            });
            this.icyFolderToCytomineFrame.setVisible(true);
        };
    }

    public void stopViewer() {
        this.closeFrame(this.annotationsFrame);
        this.closeFrame(this.cytomineToIcyFrame);
        this.closeFrame(this.icySequenceToCytomineFrame);
        this.closeFrame(this.icyFileToCytomineFrame);
        this.closeFrame(this.icyFolderToCytomineFrame);
        this.viewController.stopView();
    }

    private void closeFrame(IcyFrame frame) {
        if (frame != null) {
            frame.close();
        }
    }
}

