/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.annotations;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClientException;
import org.bioimageanalysis.icy.icytomine.core.model.Annotation;
import org.bioimageanalysis.icy.icytomine.core.model.Entity;

public class AnnotationTableModel
extends AbstractTableModel {
    private static final String[] columnNames = new String[]{"Visible", "Name", "Terms", "Author"};
    private List<Annotation> annotations;
    private Map<Annotation, Boolean> annotationVisibility;
    private Set<AnnotationVisibilityListener> annotationVisibilityListeners;

    public AnnotationTableModel(Map<? extends Annotation, Boolean> annotationVisibility) {
        this.annotationVisibility = new ConcurrentHashMap<Annotation, Boolean>(annotationVisibility);
        this.annotations = new ArrayList<Annotation>(annotationVisibility.keySet());
        this.annotationVisibilityListeners = new HashSet<AnnotationVisibilityListener>();
        this.addTableModelListener(event -> this.onTableValuesChanged(event));
    }

    @Override
    public String getColumnName(int column) {
        return column < columnNames.length ? columnNames[column] : null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Boolean.class;
        }
        if (columnIndex == 1) {
            return String.class;
        }
        if (columnIndex == 2) {
            return List.class;
        }
        if (columnIndex == 3) {
            return String.class;
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0 && rowIndex < this.annotations.size();
    }

    @Override
    public int getRowCount() {
        return this.annotations.size();
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < this.annotations.size()) {
            if (columnIndex == 0) {
                return this.isAnnotationVisible(rowIndex);
            }
            if (columnIndex == 1) {
                return this.getAnnotationId(rowIndex);
            }
            if (columnIndex == 2) {
                return this.getAnnotationTerms(rowIndex);
            }
            if (columnIndex == 3) {
                return this.getAnnotationAuthor(rowIndex);
            }
        }
        return null;
    }

    private boolean isAnnotationVisible(int annotationIndex) {
        return this.annotationVisibility.get(this.annotations.get(annotationIndex));
    }

    private Long getAnnotationId(int annotationIndex) {
        return this.annotations.get(annotationIndex).getId();
    }

    private List<String> getAnnotationTerms(int annotationIndex) {
        try {
            return this.annotations.get(annotationIndex).getAssociatedTerms().stream().map(t -> t.getName().orElse("Not specified")).collect(Collectors.toList());
        }
        catch (CytomineClientException e) {
            e.printStackTrace();
            return new ArrayList<String>(0);
        }
    }

    private String getAnnotationAuthor(int annotationIndex) {
        return this.annotations.get(annotationIndex).getUser().getName().orElse("Not specified");
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            this.annotationVisibility.put(this.annotations.get(rowIndex), (Boolean)aValue);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }

    public boolean isAnnotationVisible(Entity annotation) {
        return this.annotationVisibility.get(annotation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnnotationVisibilityListener(AnnotationVisibilityListener listener) {
        Set<AnnotationVisibilityListener> set = this.annotationVisibilityListeners;
        synchronized (set) {
            this.annotationVisibilityListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnnotationVisibilityListener(AnnotationVisibilityListener listener) {
        Set<AnnotationVisibilityListener> set = this.annotationVisibilityListeners;
        synchronized (set) {
            this.annotationVisibilityListeners.remove(listener);
        }
    }

    private void onTableValuesChanged(TableModelEvent event) {
        if (event.getType() == 0) {
            this.notifyAnnotationVisibilityChanged(event.getFirstRow());
        }
    }

    private void notifyAnnotationVisibilityChanged(int annotationIndex) {
        if (this.annotations.size() > 0) {
            Entity annotation = this.annotations.get(annotationIndex);
            this.annotationVisibilityListeners.forEach(listener -> listener.annotationVisibilityChanged(annotation, this.annotationVisibility.get(annotation)));
        }
    }

    public Set<Annotation> getAnnotations() {
        return new HashSet<Annotation>(this.annotations);
    }

    public Map<Annotation, Boolean> getAnnotationVisibility() {
        return this.annotationVisibility;
    }

    public Set<Annotation> getVisibleAnnotations() {
        return this.annotationVisibility.keySet().stream().filter(a -> this.annotationVisibility.get(a)).collect(Collectors.toSet());
    }

    public Annotation getAnnotationAt(int index) {
        return this.annotations.get(index);
    }

    public static interface AnnotationVisibilityListener {
        public void annotationVisibilityChanged(Entity var1, boolean var2);
    }
}

