/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.annotations.actions;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import org.bioimageanalysis.icy.icytomine.core.model.Term;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.annotations.actions.AnnotationTermSelectionPanel;
import org.bioimageanalysis.icy.icytomine.ui.general.JCheckableItem;

public class AnnotationTermSelectionPanelController {
    private AnnotationTermSelectionPanel panel;
    private Set<AnnotationTermSelectionPanel.TermItem> availableTerms;
    private Set<AnnotationTermSelectionCommitListener> termSelectionCommitListeners;

    public AnnotationTermSelectionPanelController(AnnotationTermSelectionPanel panel) {
        this.panel = panel;
        this.availableTerms = new HashSet<AnnotationTermSelectionPanel.TermItem>();
        this.termSelectionCommitListeners = new HashSet<AnnotationTermSelectionCommitListener>();
        this.commitTermButtonHandler();
    }

    private void commitTermButtonHandler() {
        this.panel.getTermSetButton().addActionListener(event -> this.notifyAnnotationTermChange());
    }

    private void notifyAnnotationTermChange() {
        Set<Term> selection = this.getSelectedTerms();
        this.termSelectionCommitListeners.forEach(listener -> listener.termsChanged(selection));
    }

    private Set<Term> getSelectedTerms() {
        HashSet<Term> selectedTerms = new HashSet<Term>();
        ComboBoxModel model = this.panel.getTermComboBox().getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            JCheckableItem item = (JCheckableItem)model.getElementAt(i);
            if (!item.isSelected() || ((AnnotationTermSelectionPanel.TermItem)item.getObject()).getTerm() == null) continue;
            selectedTerms.add(((AnnotationTermSelectionPanel.TermItem)item.getObject()).getTerm());
        }
        return selectedTerms;
    }

    public void setAvailableTerms(Set<Term> terms) {
        this.availableTerms = terms.stream().map(term -> new AnnotationTermSelectionPanel.TermItem((Term)term)).collect(Collectors.toSet());
        this.availableTerms.add(AnnotationTermSelectionPanel.TermItem.NO_TERM);
        this.panel.getTermComboBox().setModel(this.getTermModel());
        this.panel.getTermComboBox().setSelectedItem(AnnotationTermSelectionPanel.TermItem.NO_TERM);
    }

    private ComboBoxModel<JCheckableItem<AnnotationTermSelectionPanel.TermItem>> getTermModel() {
        DefaultComboBoxModel<JCheckableItem<AnnotationTermSelectionPanel.TermItem>> model = new DefaultComboBoxModel<JCheckableItem<AnnotationTermSelectionPanel.TermItem>>((JCheckableItem[])this.availableTerms.stream().map(termItem -> new JCheckableItem<AnnotationTermSelectionPanel.TermItem>((AnnotationTermSelectionPanel.TermItem)termItem, termItem.toString(), false)).toArray(JCheckableItem[]::new));
        return model;
    }

    public void addTermSelectionCommitListener(AnnotationTermSelectionCommitListener listener) {
        this.termSelectionCommitListeners.add(listener);
    }

    public void removeTermSelectionCommitListener(AnnotationTermSelectionCommitListener listener) {
        this.termSelectionCommitListeners.remove(listener);
    }

    public void setSelectedTerms(Set<Term> terms) {
        if (terms.isEmpty()) {
            terms = new HashSet<Term>(1);
            terms.add(null);
        }
        ComboBoxModel model = this.panel.getTermComboBox().getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            JCheckableItem checkableItem = (JCheckableItem)model.getElementAt(i);
            if (terms.contains(((AnnotationTermSelectionPanel.TermItem)checkableItem.getObject()).getTerm())) {
                checkableItem.setSelected(true);
                continue;
            }
            checkableItem.setSelected(false);
        }
        this.panel.getTermComboBox().updateUI();
    }

    public static interface AnnotationTermSelectionCommitListener {
        public void termsChanged(Set<Term> var1);
    }
}

