/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.annotations.filter;

import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.ComboBoxModel;
import org.bioimageanalysis.icy.icytomine.core.model.Term;
import org.bioimageanalysis.icy.icytomine.core.model.filters.AnnotationFilter;
import org.bioimageanalysis.icy.icytomine.core.model.filters.AnnotationFilterByTerm;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.annotations.filter.AnnotationFilterPanel;
import org.bioimageanalysis.icy.icytomine.ui.general.JCheckableItem;
import org.bioimageanalysis.icy.icytomine.ui.general.JCheckedComboBox;

public class AnnotationFilterByTermPanel
extends AnnotationFilterPanel<AnnotationFilterByTerm.TermItem> {
    AnnotationFilterByTerm termFilter;
    private Set<AnnotationFilterByTerm.TermItem> termItems;

    public AnnotationFilterByTermPanel() {
        this.setLabelText("Terms:");
        this.termFilter = new AnnotationFilterByTerm();
        this.setFilter(this.termFilter);
    }

    public void setPreviousFilter(AnnotationFilter previousFilter) {
        this.termFilter.setPreviousFilter(previousFilter);
    }

    public void setTerms(Set<Term> terms) {
        this.termItems = terms.stream().map(t -> new AnnotationFilterByTerm.TermItem((Term)t)).collect(Collectors.toSet());
        this.termItems.add(AnnotationFilterByTerm.TermItem.NO_TERM);
        this.termItems.add(AnnotationFilterByTerm.TermItem.ALL);
        this.termItems.add(AnnotationFilterByTerm.TermItem.NONE);
        this.termFilter.setActiveTerms(new HashSet<AnnotationFilterByTerm.TermItem>(this.termItems));
        this.setModel(this.termItems.toArray(new AnnotationFilterByTerm.TermItem[this.termItems.size()]), item -> item.toString());
    }

    @Override
    protected void choiceChanged(ActionEvent e) {
        JCheckableItem checkableItem = (JCheckableItem)((JCheckedComboBox)e.getSource()).getSelectedItem();
        AnnotationFilterByTerm.TermItem termItem = (AnnotationFilterByTerm.TermItem)checkableItem.object;
        if (termItem == AnnotationFilterByTerm.TermItem.ALL) {
            Set<AnnotationFilterByTerm.TermItem> activeTerms = this.termFilter.getActiveTerms();
            this.termItems.stream().filter(t -> t != AnnotationFilterByTerm.TermItem.ALL && t != AnnotationFilterByTerm.TermItem.NONE).forEach(t -> activeTerms.add((AnnotationFilterByTerm.TermItem)t));
            ComboBoxModel model = ((JCheckedComboBox)e.getSource()).getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                JCheckableItem elem = (JCheckableItem)model.getElementAt(i);
                if (elem.getObject() == AnnotationFilterByTerm.TermItem.NONE) {
                    elem.setSelected(false);
                    continue;
                }
                elem.setSelected(true);
            }
            ((JCheckedComboBox)e.getSource()).invalidate();
        } else if (termItem == AnnotationFilterByTerm.TermItem.NONE) {
            this.termFilter.getActiveTerms().removeAll(this.termItems);
            ComboBoxModel model = ((JCheckedComboBox)e.getSource()).getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                JCheckableItem elem = (JCheckableItem)model.getElementAt(i);
                elem.setSelected(false);
            }
            ((JCheckedComboBox)e.getSource()).invalidate();
        } else if (!checkableItem.isSelected()) {
            this.termFilter.getActiveTerms().add(termItem);
        } else {
            this.termFilter.getActiveTerms().remove(termItem);
        }
        this.termFilter.computeActiveAnnotations(AnnotationFilter.ComputationMode.RECOMPUTE_JUST_THIS);
    }
}

