/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.annotations.filter;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import org.bioimageanalysis.icy.icytomine.core.model.Annotation;
import org.bioimageanalysis.icy.icytomine.core.model.Image;
import org.bioimageanalysis.icy.icytomine.core.model.filters.AnnotationFilter;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.annotations.filter.AnnotationFilterPanel;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.annotations.filter.AnnotationFilteringPanelController;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.annotations.filter.FilterAdditionPanel;

public class AnnotationFilteringPanel
extends JPanel {
    private GridBagLayout layout;
    private FilterAdditionPanel filterAdditionPanel;
    private List<AnnotationFilterPanel<?>> filterPanels;
    private AnnotationFilteringPanelController panelController;

    public AnnotationFilteringPanel(Image imageInformation) {
        this();
        this.setImageInformation(imageInformation);
    }

    public AnnotationFilteringPanel() {
        this.setView();
        this.setController();
    }

    private void setView() {
        this.layout = new GridBagLayout();
        this.layout.columnWidths = new int[]{305};
        this.setLayout(this.layout);
        this.filterPanels = new ArrayList();
        this.addFilterAdditionPanel();
    }

    private void addFilterAdditionPanel() {
        this.filterAdditionPanel = new FilterAdditionPanel();
        GridBagConstraints layoutConstraints = this.createLayoutConstraints(5, 5, 0);
        this.add((Component)this.filterAdditionPanel, layoutConstraints);
    }

    private GridBagConstraints createLayoutConstraints(int topMargin, int bottomMargin, int row) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(topMargin, 5, bottomMargin, 5);
        constraints.fill = 1;
        constraints.gridx = 0;
        constraints.gridy = row;
        return constraints;
    }

    private void setController() {
        this.panelController = new AnnotationFilteringPanelController(this);
    }

    public void setImageInformation(Image imageInformation) {
        this.panelController.setImageInformation(imageInformation);
    }

    protected void addFilterAdditionListener(FilterAdditionPanel.FilterAdditionListener listener) {
        this.filterAdditionPanel.addFilterAdditionListener(listener);
    }

    protected synchronized void addFilterPanel(AnnotationFilterPanel<?> filter) {
        int row = this.filterPanels.size();
        GridBagConstraints layoutConstraints = this.createLayoutConstraints(0, 5, row + 1);
        this.add(filter, layoutConstraints);
        this.revalidate();
        this.filterPanels.add(filter);
    }

    protected synchronized void removeFilterPanel(AnnotationFilterPanel<?> filter) {
        this.remove(filter);
        this.revalidate();
        this.filterPanels.remove(filter);
    }

    public void addAnnotationFilterUpdateListener(AnnotationFilter.AnnotationFilterUpdateListener listener) {
        this.panelController.addAnnotationFilterUpdateListener(listener);
    }

    public void removeAnnotationFilterUpdateListener(AnnotationFilter.AnnotationFilterUpdateListener listener) {
        this.panelController.removeAnnotationFilterUpdateListener(listener);
    }

    public Set<Annotation> getActiveAnnotations() {
        return this.panelController.getActiveAnnotations();
    }
}

