/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.cytomine2Icy;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Dimension2D;
import java.util.Arrays;
import java.util.Optional;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.cytomine2Icy.CytomineToIcyPanelController;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.controller.view.ViewController;

public class CytomineToIcyPanel
extends JPanel {
    CytomineToIcyPanelController panelController;
    private JComboBox<Double> magnificationComboBox;
    private JTextField magnificationTextField;
    private JLabel outputSizeValueLabel;
    private JProgressBar progressBar;
    private JButton startButton;
    private JButton cancelButton;
    private JCheckBox magnificationSourceCheckBox;

    public CytomineToIcyPanel(ViewController viewController) {
        this.setupView();
        this.setupController(viewController);
    }

    private void setupController(ViewController viewController) {
        this.panelController = new CytomineToIcyPanelController(this, viewController);
    }

    private void setupView() {
        GridBagLayout layout = this.createPanelLayout();
        this.setLayout(layout);
        JPanel magnificationPanel = this.createMagnificationsPanel();
        GridBagConstraints magnificationPanelConstraints = CytomineToIcyPanel.createConstraints(0, 0, 1, 0, 0, 5, 0);
        this.add((Component)magnificationPanel, magnificationPanelConstraints);
        this.progressBar = this.createProgressBar();
        GridBagConstraints progressBarConstraints = CytomineToIcyPanel.createConstraints(0, 1, 2, 5, 5, 5, 5);
        this.add((Component)this.progressBar, progressBarConstraints);
        JPanel buttonsPanel = this.createButtonsPanel();
        GridBagConstraints buttonsPanelConstraints = CytomineToIcyPanel.createConstraints(0, 2, 1, 5, 5, 5, 5);
        this.add((Component)buttonsPanel, buttonsPanelConstraints);
        this.setPreferredSize(new Dimension(300, 180));
    }

    private GridBagLayout createPanelLayout() {
        GridBagLayout layout = new GridBagLayout();
        layout.columnWidths = new int[]{0};
        layout.rowHeights = new int[]{0, 0, 0, 1};
        layout.columnWeights = new double[]{1.0};
        layout.rowWeights = new double[]{0.0, 0.0, 0.0, 1.0};
        return layout;
    }

    private JPanel createMagnificationsPanel() {
        JPanel panel = new JPanel();
        GridBagLayout panelLayout = new GridBagLayout();
        panelLayout.columnWidths = new int[]{0, 0, 0};
        panelLayout.rowHeights = new int[]{0, 0};
        panelLayout.columnWeights = new double[]{0.0, 1.0, 0.0};
        panelLayout.rowWeights = new double[]{0.0, 0.0};
        panel.setLayout(panelLayout);
        JLabel magnificationLabel = new JLabel("Magnification");
        GridBagConstraints magnificationLabelConstraints = CytomineToIcyPanel.createConstraints(0, 0, 1, 5, 5, 5, 5);
        panel.add((Component)magnificationLabel, magnificationLabelConstraints);
        this.magnificationComboBox = new JComboBox();
        this.magnificationTextField = new JTextField(String.valueOf(1.0));
        GridBagConstraints magnificationComboBoxConstraints = CytomineToIcyPanel.createConstraints(1, 0, 1, 5, 5, 5, 5);
        panel.add(this.magnificationComboBox, magnificationComboBoxConstraints);
        this.magnificationSourceCheckBox = new JCheckBox("Manual");
        this.magnificationSourceCheckBox.setSelected(false);
        this.magnificationSourceCheckBox.addItemListener(event -> {
            if (event.getStateChange() == 1) {
                this.magnificationTextField.setText(this.magnificationComboBox.getSelectedItem().toString());
                panel.remove(this.magnificationComboBox);
                panel.add((Component)this.magnificationTextField, magnificationComboBoxConstraints);
            } else {
                Object currentItem = this.magnificationComboBox.getSelectedItem();
                this.magnificationComboBox.setSelectedItem(null);
                this.magnificationComboBox.setSelectedItem(currentItem);
                panel.remove(this.magnificationTextField);
                panel.add(this.magnificationComboBox, magnificationComboBoxConstraints);
            }
            panel.updateUI();
        });
        GridBagConstraints magnificationSourceCheckBoxConstraints = CytomineToIcyPanel.createConstraints(2, 0, 1, 5, 5, 5, 5);
        panel.add((Component)this.magnificationSourceCheckBox, magnificationSourceCheckBoxConstraints);
        JLabel outputSizeTitleLabel = new JLabel("Output size:");
        GridBagConstraints outputSizeTitleLabelConstraints = CytomineToIcyPanel.createConstraints(0, 1, 1, 5, 5, 5, 5);
        panel.add((Component)outputSizeTitleLabel, outputSizeTitleLabelConstraints);
        this.outputSizeValueLabel = new JLabel("1000 x 1000 pixels");
        GridBagConstraints outputSizeValueLabelConstraints = CytomineToIcyPanel.createConstraints(1, 1, 1, 5, 5, 5, 5);
        panel.add((Component)this.outputSizeValueLabel, outputSizeValueLabelConstraints);
        return panel;
    }

    private static GridBagConstraints createConstraints(int gridX, int gridY, int fill, int topInset, int leftInset, int bottomInset, int rightInset) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(topInset, leftInset, bottomInset, rightInset);
        constraints.fill = fill;
        constraints.gridx = gridX;
        constraints.gridy = gridY;
        return constraints;
    }

    private JProgressBar createProgressBar() {
        this.progressBar = new JProgressBar();
        this.setProgressIdle();
        return this.progressBar;
    }

    private JPanel createButtonsPanel() {
        JPanel panel = new JPanel();
        GridBagLayout panelLayout = new GridBagLayout();
        panelLayout.columnWidths = new int[]{0, 0};
        panelLayout.rowHeights = new int[]{1};
        panelLayout.columnWeights = new double[]{0.0, 0.0};
        panelLayout.rowWeights = new double[]{0.0};
        panel.setLayout(panelLayout);
        this.startButton = new JButton("Start");
        GridBagConstraints startButtonConstraints = CytomineToIcyPanel.createConstraints(0, 0, 0, 0, 0, 0, 5);
        panel.add((Component)this.startButton, startButtonConstraints);
        this.cancelButton = new JButton("Cancel");
        GridBagConstraints cancelButtonConstraints = CytomineToIcyPanel.createConstraints(1, 0, 0, 0, 0, 0, 0);
        panel.add((Component)this.cancelButton, cancelButtonConstraints);
        return panel;
    }

    public void setAvailableMagnifications(double[] magnifications) {
        DefaultComboBoxModel<Double> comboBoxModel = new DefaultComboBoxModel<Double>((Double[])Arrays.stream(magnifications).boxed().toArray(Double[]::new));
        this.magnificationComboBox.setModel(comboBoxModel);
    }

    public void addMagnificationListener(final ActionListener listener) {
        this.magnificationComboBox.addActionListener(listener);
        this.magnificationTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.warn();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.warn();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.warn();
            }

            private void warn() {
                listener.actionPerformed(new ActionEvent(CytomineToIcyPanel.this.magnificationTextField, 1001, "textChanged"));
            }
        });
    }

    public void removeMagnificationListener(ActionListener listener) {
        this.magnificationComboBox.removeActionListener(listener);
    }

    public void addStartButtonActionListener(ActionListener listener) {
        this.startButton.addActionListener(listener);
    }

    public void removeStartButtonActionListener(ActionListener listener) {
        this.startButton.addActionListener(listener);
    }

    public void addCancelButtonActionListener(ActionListener listener) {
        this.cancelButton.addActionListener(listener);
    }

    public void setStartButtonEnabled(boolean enabled) {
        this.startButton.setEnabled(enabled);
    }

    public void setProgress(String message, double percent) {
        if (percent == 0.0) {
            EventQueue.invokeLater(() -> {
                this.progressBar.setIndeterminate(true);
                this.progressBar.setStringPainted(true);
                String fullMessage = message.isEmpty() ? "Initializing..." : message + ": Initializing...";
                this.progressBar.setString(fullMessage);
            });
        } else {
            EventQueue.invokeLater(() -> {
                int percentage = (int)(percent * 100.0);
                this.progressBar.setIndeterminate(false);
                this.progressBar.setValue(percentage);
                this.progressBar.setStringPainted(true);
                String fullMessage = message.isEmpty() ? percentage + "%" : message + ": " + percentage + "%";
                this.progressBar.setString(fullMessage);
            });
        }
    }

    public void setProgress(double percent) {
        this.setProgress("", percent);
    }

    public void addCloseListener(ActionListener listener) {
        this.panelController.addCloseListener(listener);
    }

    public void setOutputImageSize(Dimension2D outputDimension) {
        this.outputSizeValueLabel.setText(String.format("%d x %d pixels", (int)outputDimension.getWidth(), (int)outputDimension.getHeight()));
    }

    public void setDefaultMagnification() {
        this.magnificationComboBox.setSelectedIndex(0);
    }

    public void setProgressIdle() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        EventQueue.invokeLater(() -> {
            this.progressBar.setIndeterminate(false);
            this.progressBar.setStringPainted(false);
            this.progressBar.setValue(0);
        });
    }

    public CytomineToIcyPanelController getController() {
        return this.panelController;
    }

    public Optional<Double> getSelectedMagnification() {
        if (this.magnificationSourceCheckBox.isSelected()) {
            try {
                return Optional.of(Math.abs(Double.parseDouble(this.magnificationTextField.getText())));
            }
            catch (Exception e) {
                return Optional.ofNullable(null);
            }
        }
        return Optional.ofNullable((Double)this.magnificationComboBox.getSelectedItem());
    }

    public void setMagnificationEnabled(boolean enabled) {
        EventQueue.invokeLater(() -> {
            this.magnificationSourceCheckBox.setEnabled(enabled);
            this.magnificationComboBox.setEnabled(enabled);
            this.magnificationTextField.setEnabled(enabled);
        });
    }
}

