/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui.dialogs;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.japura.gui.GUIImages;
import org.japura.gui.dialogs.AbstractBasicDialog;
import org.japura.gui.dialogs.CustomDialog;
import org.japura.gui.dialogs.QuestionButton;
import org.japura.gui.i18n.GUIStringKeys;
import org.japura.util.i18n.I18nAdapter;

public class QuestionDialog
extends AbstractBasicDialog {
    private static Icon defaultDialogIcon = new ImageIcon(GUIImages.QUESTION);
    private static Icon defaultMessageIcon = new ImageIcon(GUIImages.QUESTION);
    private CustomDialog dialog;
    private QuestionButton defaultButtonForDispose = QuestionButton.NO;

    public static void setDefaultMessageIcon(Icon icon) {
        if (icon != null) {
            defaultMessageIcon = icon;
        }
    }

    public static void setDefaultDialogIcon(Icon icon) {
        if (icon != null) {
            defaultDialogIcon = icon;
        }
    }

    public static Icon getDefaultDialogIcon() {
        return defaultDialogIcon;
    }

    public static Icon getDefaultMessageIcon() {
        return defaultMessageIcon;
    }

    public static boolean show(Component owner, String title, String message) {
        QuestionDialog dialog = new QuestionDialog(title, message);
        return dialog.show(owner);
    }

    public static boolean show(Window owner, String title, String message) {
        QuestionDialog dialog = new QuestionDialog(title, message);
        return dialog.show(owner);
    }

    public static boolean show(String title, String message) {
        QuestionDialog dialog = new QuestionDialog(title, message);
        return dialog.show();
    }

    public QuestionDialog(String title, String message) {
        this.dialog = new CustomDialog(title, message);
        this.dialog.addButton(I18nAdapter.getAdapter().getString(GUIStringKeys.YES.getKey()));
        this.dialog.addButton(I18nAdapter.getAdapter().getString(GUIStringKeys.NO.getKey()));
        this.setFocusedButton(QuestionButton.NO);
        this.setMessageIcon(QuestionDialog.getDefaultMessageIcon());
        if (QuestionDialog.getDefaultDialogIcon() != null) {
            this.setDialogIcon(QuestionDialog.getDefaultDialogIcon());
        }
    }

    public void setDefaultButtonForDispose(QuestionButton button) {
        this.defaultButtonForDispose = button;
    }

    public QuestionButton getDefaultButtonForDispose() {
        return this.defaultButtonForDispose;
    }

    @Override
    protected CustomDialog getDialog() {
        return this.dialog;
    }

    public boolean show() {
        return this.show(null);
    }

    public boolean show(Component owner) {
        Window window = null;
        if (owner != null) {
            window = SwingUtilities.getWindowAncestor(owner);
        }
        return this.show(window);
    }

    public boolean show(Window owner) {
        Integer result = this.getDialog().show(owner);
        if (result == null) {
            result = new Integer(this.getDefaultButtonForDispose().getIndex());
        }
        if (QuestionButton.YES.getIndex() == result.intValue()) {
            return true;
        }
        if (QuestionButton.NO.getIndex() == result.intValue()) {
            return false;
        }
        throw new RuntimeException("Unknow result: " + result);
    }

    public void setFocusedButton(QuestionButton button) {
        if (button != null) {
            this.getDialog().setFocusedButton(button.getIndex());
        }
    }

    public QuestionButton getFocusedButton() {
        Integer index = this.getDialog().getFocusedButton();
        if (index != null) {
            for (QuestionButton button : QuestionButton.values()) {
                if (button.getIndex() != index.intValue()) continue;
                return button;
            }
        }
        return null;
    }

    public String getButtonText(QuestionButton button) {
        if (button == null) {
            return null;
        }
        return this.getDialog().getButtonText(button.getIndex());
    }

    public void setButtonText(QuestionButton button, String text) {
        if (button != null && text != null) {
            this.getDialog().setButtonText(button.getIndex(), text);
        }
    }

    public void setButtonEnabled(QuestionButton button, boolean enabled) {
        if (button != null) {
            this.getDialog().setButtonEnabled(button.getIndex(), enabled);
        }
    }

    public boolean isButtonEnabled(QuestionButton button) {
        if (button != null) {
            return this.getDialog().isButtonEnabled(button.getIndex());
        }
        return false;
    }

    public void addButtonActionKeyCode(QuestionButton button, int keyCode) {
        if (button != null) {
            this.getDialog().addButtonActionKeyCode(button.getIndex(), keyCode);
        }
    }

    public void addButtonAction(QuestionButton button, ActionListener actionListener) {
        if (button != null) {
            this.getDialog().addButtonAction(button.getIndex(), actionListener);
        }
    }
}

