/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui.model;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.japura.gui.event.DateEvent;
import org.japura.gui.event.DateListener;
import org.japura.util.date.DateMask;
import org.japura.util.date.DateSeparator;
import org.japura.util.date.DateUtil;

public class DateDocument
extends PlainDocument {
    private static final long serialVersionUID = 1L;
    private DateSeparator separator;
    private DateMask mask;
    private Locale locale;
    private DateUtil dateUtil;
    private String regex;
    private boolean autoCompleteEnabled = true;
    private Date oldDate;
    private boolean oldDateSetted;

    public DateDocument() {
        this((Locale)null, (DateSeparator)null);
    }

    public DateDocument(Locale locale, DateSeparator separator) {
        this.separator = separator == null ? DateSeparator.SLASH : separator;
        this.mask = DateMask.getMask(locale);
        this.regex = this.buildRegex();
        this.setLocale(locale);
        this.dateUtil = DateUtil.getInstance();
    }

    public Locale getLocale() {
        return this.locale;
    }

    private void setLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.locale = locale;
        this.mask = DateMask.getMask(locale);
    }

    public DateSeparator getSeparator() {
        return this.separator;
    }

    public boolean isAutoCompleteEnabled() {
        return this.autoCompleteEnabled;
    }

    public void setAutoCompleteEnabled(boolean enabled) {
        this.autoCompleteEnabled = enabled;
    }

    private String buildRegex() {
        String year = "([0-9]{1,4})?";
        String dayOrMonth = "([0-9]{1,2})?";
        String sep = "(\\" + this.getSeparator().getSeparator() + ")?";
        String regex = "";
        if (this.mask == DateMask.MMDDYYYY || this.mask == DateMask.DDMMYYYY) {
            regex = dayOrMonth + sep + dayOrMonth + sep + year;
        } else if (this.mask == DateMask.YYYYMMDD || this.mask == DateMask.YYYYDDMM) {
            regex = year + sep + dayOrMonth + sep + dayOrMonth;
        }
        return regex;
    }

    public boolean isValid() {
        if (this.getLength() > 0) {
            return this.getDate() != null;
        }
        return true;
    }

    private GregorianCalendar getGregorianCalendar() {
        Date date = this.getDate();
        if (date != null) {
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTimeInMillis(date.getTime());
            return gc;
        }
        return null;
    }

    public Integer getDay() {
        GregorianCalendar gc = this.getGregorianCalendar();
        if (gc != null) {
            return gc.get(5);
        }
        return null;
    }

    public Integer getMonth() {
        GregorianCalendar gc = this.getGregorianCalendar();
        if (gc != null) {
            return gc.get(2) + 1;
        }
        return null;
    }

    public Integer getYear() {
        GregorianCalendar gc = this.getGregorianCalendar();
        if (gc != null) {
            return gc.get(1);
        }
        return null;
    }

    public Date getDate() {
        try {
            String text = this.getText(0, this.getLength());
            Date date = this.dateUtil.toDate(this.locale, this.getSeparator(), text);
            if (date != null) {
                return date;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void setDate(int day, int month, int year) {
        try {
            this.replace(0, this.getLength(), DateUtil.toString(this.mask, this.getSeparator(), day, month, year), null);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void clear() {
        try {
            this.remove(0, this.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void setDate(long time) {
        try {
            this.replace(0, this.getLength(), this.dateUtil.toString(this.locale, this.getSeparator(), time), null);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void setToCurrentDate() {
        this.setDate(System.currentTimeMillis());
    }

    private String buildCompletedText(String text, String newStr) {
        String regex1 = "";
        String regex2 = "";
        String complt1 = "";
        String complt2 = "";
        String sep = "\\" + this.separator.getSeparator();
        if (this.mask == DateMask.DDMMYYYY || this.mask == DateMask.MMDDYYYY) {
            regex1 = "[0-9]{2}";
            regex2 = "[0-9]{2}" + sep + "[0-9]{2}";
            complt1 = "[0-9]{1,2}(" + sep + "([0-9]{1,4})?)?";
            complt2 = "[0-9]{1,4}";
        } else if (this.mask == DateMask.YYYYMMDD || this.mask == DateMask.YYYYDDMM) {
            regex1 = "[0-9]{4}";
            complt1 = "[0-9]{1,2}(" + sep + "([0-9]{1,2})?)?";
            regex2 = "[0-9]{4}" + sep + "[0-9]{2}";
            complt2 = "[0-9]{1,2}";
        }
        if (text.matches(regex1) && newStr.matches(complt1) || text.matches(regex2) && newStr.matches(complt2)) {
            return this.separator.getSeparator() + newStr;
        }
        return newStr;
    }

    public DateMask getMask() {
        return this.mask;
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        this.oldDate = this.getDate();
        super.remove(offs, len);
        if (this.getCurrentWriter() == null) {
            this.fireListeners(this.oldDate, this.getDate());
        } else {
            this.oldDateSetted = true;
        }
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        String newText = null;
        if (this.getLength() > 0) {
            String text = this.getText(0, this.getLength());
            if (this.isAutoCompleteEnabled() && offs == this.getLength()) {
                str = this.buildCompletedText(text, str);
            }
            newText = text.substring(0, offs) + str + text.substring(offs, this.getLength());
        } else {
            if (this.isAutoCompleteEnabled() && offs == this.getLength()) {
                str = this.buildCompletedText("", str);
            }
            newText = str;
        }
        if (newText.matches(this.regex)) {
            if (!this.oldDateSetted) {
                this.oldDate = this.getDate();
            }
            super.insertString(offs, str, a);
            this.fireListeners(this.oldDate, this.getDate());
        }
    }

    protected void fireListeners(Date oldDate, Date newDate) {
        DateListener[] listeners;
        DateEvent event = new DateEvent(this, newDate, oldDate);
        for (DateListener listener : listeners = (DateListener[])this.listenerList.getListeners(DateListener.class)) {
            listener.dateChanged(event);
        }
        oldDate = null;
        this.oldDateSetted = false;
    }

    public void addDateListener(DateListener listener) {
        this.listenerList.add(DateListener.class, listener);
    }

    public void removeDateListener(DateListener listener) {
        this.listenerList.remove(DateListener.class, listener);
    }
}

