/*
 * Decompiled with CFR 0.152.
 */
package plugins.atournay.jep.utils;

import java.io.File;
import jep.JepConfig;
import jep.JepException;
import jep.MainInterpreter;
import jep.PyConfig;
import jep.SharedInterpreter;
import jep.SubInterpreter;
import plugins.atournay.jep.exec.DefaultClassEnquirer;

public class JepUtils {
    private static JepUtils instance;
    private JepConfig jepConfig;

    private JepUtils() {
    }

    public static JepUtils getInstance() {
        if (instance == null) {
            instance = new JepUtils();
        }
        return instance;
    }

    public String findJepLib(String sitePackagesPath) {
        String[] libFiles;
        String jetPath = "";
        File jepDir = new File(sitePackagesPath, "jep");
        if (!jepDir.isDirectory()) {
            return null;
        }
        for (String libFile : libFiles = new String[]{"libjep.so", "libjep.jnilib", "jep.ddl"}) {
            File lib = new File(jepDir, libFile);
            if (!lib.isFile()) continue;
            jetPath = lib.getAbsolutePath();
        }
        return jetPath;
    }

    public void setJepPath(String jepPath, String pythonRoot) throws JepException {
        this.setJepConfig(new JepConfig());
        this.getJepConfig().setClassEnquirer(new DefaultClassEnquirer());
        if (jepPath.matches(".*conda.*|.*venv")) {
            PyConfig pyConfig = new PyConfig();
            pyConfig.setPythonHome(pythonRoot);
            MainInterpreter.setInitParams(pyConfig);
        }
        SharedInterpreter.setConfig(this.getJepConfig());
        MainInterpreter.setJepLibraryPath(jepPath);
    }

    public SubInterpreter openSubPython() {
        return this.openSubPython(new JepConfig());
    }

    public SubInterpreter openSubPython(JepConfig jepConfig) {
        return new SubInterpreter(jepConfig);
    }

    public void closeSubPython(SubInterpreter subInterpreter) {
        subInterpreter.close();
    }

    public JepConfig getJepConfig() {
        return this.jepConfig;
    }

    private void setJepConfig(JepConfig newJepConfig) {
        this.jepConfig = newJepConfig;
    }
}

