/*
 * Decompiled with CFR 0.152.
 */
package jep.python;

import java.lang.reflect.Proxy;
import jep.Jep;
import jep.JepAccess;
import jep.JepException;
import jep.python.InvocationHandler;
import jep.python.PyPointer;

public class PyObject
extends JepAccess
implements AutoCloseable {
    protected final PyPointer pointer;

    protected PyObject(Jep jep, long l) throws JepException {
        super(jep);
        this.pointer = new PyPointer(this, this.getMemoryManager(), this.getThreadState(), l);
    }

    protected long getPyObject() {
        return this.pointer.pyObject;
    }

    protected void checkValid() throws JepException {
        this.jep.isValidThread();
        if (this.pointer.isDisposed()) {
            throw new JepException(this.getClass().getSimpleName() + " has been closed.");
        }
    }

    @Override
    public void close() throws JepException {
        this.jep.isValidThread();
        this.pointer.dispose();
    }

    public Object getAttr(String string) throws JepException {
        this.checkValid();
        return this.getAttr(this.pointer.tstate, this.pointer.pyObject, string, Object.class);
    }

    public <T> T getAttr(String string, Class<T> clazz) throws JepException {
        this.checkValid();
        return clazz.cast(this.getAttr(this.pointer.tstate, this.pointer.pyObject, string, clazz));
    }

    private native Object getAttr(long var1, long var3, String var5, Class<?> var6) throws JepException;

    public void setAttr(String string, Object object) throws JepException {
        this.checkValid();
        this.setAttr(this.pointer.tstate, this.pointer.pyObject, string, object);
    }

    private native void setAttr(long var1, long var3, String var5, Object var6) throws JepException;

    public void delAttr(String string) throws JepException {
        this.checkValid();
        this.delAttr(this.pointer.tstate, this.pointer.pyObject, string);
    }

    private native void delAttr(long var1, long var3, String var5) throws JepException;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        this.checkValid();
        return this.equals(this.pointer.tstate, this.pointer.pyObject, object);
    }

    public String toString() {
        this.checkValid();
        return this.toString(this.pointer.tstate, this.pointer.pyObject);
    }

    public int hashCode() {
        this.checkValid();
        Long l = this.hashCode(this.pointer.tstate, this.pointer.pyObject);
        return l.hashCode();
    }

    private native boolean equals(long var1, long var3, Object var5);

    private native String toString(long var1, long var3);

    private native long hashCode(long var1, long var3);

    public <T> T proxy(Class<T> clazz, Class<?> ... classArray) throws JepException {
        ClassLoader classLoader = this.getClassLoader();
        Class[] classArray2 = null;
        if (classArray == null || classArray.length == 0) {
            classArray2 = new Class[]{clazz};
        } else {
            classArray2 = new Class[classArray.length + 1];
            classArray2[0] = clazz;
            System.arraycopy(classArray, 0, classArray2, 1, classArray.length);
        }
        InvocationHandler invocationHandler = new InvocationHandler(this, false);
        return clazz.cast(Proxy.newProxyInstance(classLoader, classArray2, (java.lang.reflect.InvocationHandler)invocationHandler));
    }

    public <T> T as(Class<T> clazz) throws JepException {
        return clazz.cast(this.as(this.pointer.tstate, this.pointer.pyObject, clazz));
    }

    private native Object as(long var1, long var3, Class<?> var5) throws JepException;
}

