/*
 * Decompiled with CFR 0.152.
 */
package plugins.atournay.jep.utils;

import icy.gui.dialog.MessageDialog;
import icy.gui.frame.IcyFrame;
import icy.system.IcyExceptionHandler;
import icy.system.thread.ThreadUtil;
import java.awt.GridLayout;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.JTextArea;
import plugins.atournay.jep.prefs.JepPreferences;
import plugins.atournay.jep.utils.Utils;

public class PythonUtils {
    private static PythonUtils instance;

    private PythonUtils() {
    }

    public static PythonUtils getInstance() {
        if (instance == null) {
            instance = new PythonUtils();
        }
        return instance;
    }

    public HashMap<String, String> detectCondaEnvironments() {
        HashMap<String, String> condaEnvs = new HashMap<String, String>();
        String[] cmd = new String[]{"conda", "env", "list"};
        try {
            Process process = new ProcessBuilder(cmd).start();
            BufferedReader stdOut = new BufferedReader(new InputStreamReader(process.getInputStream()));
            Pattern pattern = Pattern.compile("#|([^.A-z]conda)|(environments:)|\\*| ");
            List stdOutStr = stdOut.lines().flatMap(pattern::splitAsStream).collect(Collectors.toList()).stream().filter(e -> !e.equals("")).collect(Collectors.toList());
            for (int i = 0; i < stdOutStr.size(); i += 2) {
                condaEnvs.put((String)stdOutStr.get(i), (String)stdOutStr.get(i + 1));
            }
        }
        catch (IOException e2) {
            return null;
        }
        return condaEnvs;
    }

    public Set<String> getCondaEnvNames() {
        return this.detectCondaEnvironments() != null ? this.detectCondaEnvironments().keySet() : null;
    }

    public String findPythonExecutable(String path, boolean isDirectory) {
        if (isDirectory) {
            File[] pythonFiles;
            File pathToTest = new File(path);
            File[] fileArray = pythonFiles = Utils.getInstance().isWindows() ? pathToTest.listFiles(File::isFile) : pathToTest.listFiles((file, name) -> name.equals("bin") && file.isDirectory());
            if (pythonFiles != null) {
                if (Utils.getInstance().isWindows()) {
                    File foundPython = Arrays.stream(pythonFiles).filter(x -> Pattern.compile("python?3?(?:\\.exe|$)").matcher(x.getAbsolutePath()).find()).findFirst().orElse(null);
                    return foundPython != null ? foundPython.getAbsolutePath() : null;
                }
                for (File binDirectory : pythonFiles) {
                    File[] binFiles = binDirectory.listFiles((file, name) -> name.matches("python?3?(?:\\.exe|$)"));
                    if (binFiles == null) continue;
                    return Arrays.stream(binFiles).findFirst().map(File::getAbsolutePath).orElse(null);
                }
            }
        } else {
            if (Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) {
                return path;
            }
            return null;
        }
        return null;
    }

    public String setSitePackagesDirectory() {
        String[] command = new String[]{JepPreferences.getInstance().getPythonExecPath(), "-c", "import sys; print([p for p in sys.path if p.endswith(\\\"site-packages\\\")])"};
        String sitePackagesPath = "";
        try {
            String terminalLine;
            Process process = Runtime.getRuntime().exec(command);
            BufferedReader streamInput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader streamError = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            block2: while ((terminalLine = streamInput.readLine()) != null) {
                String[] spList;
                for (String spPath : spList = terminalLine.replaceAll("[\\[\\]' ]", "").split(",")) {
                    System.out.println(spPath);
                    if (!spPath.contains("site-packages")) continue;
                    sitePackagesPath = spPath;
                    continue block2;
                }
            }
            while ((terminalLine = streamError.readLine()) != null) {
                System.err.println(terminalLine);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sitePackagesPath;
    }

    public void installPythonPackage(String packageNames) {
        String pythonExec = Utils.getInstance().isWindows() ? JepPreferences.getInstance().getPythonExecPath().replace("\\", "\\\\") : JepPreferences.getInstance().getPythonExecPath();
        ArrayList packageList = Arrays.stream(packageNames.trim().split(" ")).filter(s -> !s.equals("")).map(String::trim).collect(Collectors.toCollection(ArrayList::new));
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(pythonExec);
        commandLine.add("-m");
        commandLine.add("pip");
        commandLine.add("install");
        commandLine.addAll(packageList);
        IcyFrame[] installFrame = new IcyFrame[1];
        JTextArea outputArea = new JTextArea();
        ThreadUtil.invokeNow(() -> {
            installFrame[0] = new IcyFrame("Installing Python packages " + packageNames, false, false);
            installFrame[0].getContentPane().setLayout(new GridLayout());
            installFrame[0].setSize(1000, 300);
            installFrame[0].setVisible(true);
            installFrame[0].addToDesktopPane();
            installFrame[0].requestFocus();
            installFrame[0].getContentPane().add(outputArea);
        });
        ThreadUtil.bgRun(() -> {
            BufferedReader bufferedErrReader;
            BufferedReader bufferedReader;
            Process sysProc;
            ProcessBuilder command = new ProcessBuilder(commandLine);
            try {
                sysProc = command.start();
                bufferedReader = new BufferedReader(new InputStreamReader(sysProc.getInputStream()));
                bufferedErrReader = new BufferedReader(new InputStreamReader(sysProc.getErrorStream()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            try {
                String lineError;
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    System.out.println(line);
                    String finalLine = line;
                    ThreadUtil.invokeLater(() -> {
                        outputArea.append(finalLine);
                        outputArea.append("\n");
                        installFrame[0].validate();
                    });
                }
                while ((lineError = bufferedErrReader.readLine()) != null) {
                    System.out.println(lineError);
                    String finalLineError = lineError;
                    ThreadUtil.invokeLater(() -> {
                        outputArea.append(finalLineError);
                        outputArea.append("");
                        installFrame[0].validate();
                    });
                }
                sysProc.waitFor();
                Thread.sleep(2000L);
                ThreadUtil.invokeLater(() -> installFrame[0].dispose());
            }
            catch (IOException | InterruptedException e) {
                MessageDialog.showDialog((String)("Error while trying to install " + packageNames), (String)e.toString(), (int)0);
                IcyExceptionHandler.showErrorMessage((Throwable)new RuntimeException(e), (boolean)true);
            }
        });
    }
}

