/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.scale;

import icy.gui.main.GlobalSequenceListener;
import icy.gui.viewer.Viewer;
import icy.main.Icy;
import icy.painter.Overlay;
import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginDaemon;
import icy.preferences.XMLPreferences;
import icy.sequence.Sequence;
import icy.system.IcyHandledException;
import plugins.tprovoost.scale.ScaleBarOverlay;

public class Scale
extends Plugin
implements PluginDaemon,
GlobalSequenceListener {
    private static XMLPreferences preferences = null;

    public void init() {
        if (preferences == null) {
            preferences = this.getPreferencesRoot();
        }
        Icy.getMainInterface().addGlobalSequenceListener((GlobalSequenceListener)this);
    }

    public void run() {
        for (Sequence s : this.getSequences()) {
            Scale.addScaleBarTo(s);
        }
    }

    public void stop() {
        for (Sequence s : this.getSequences()) {
            Scale.removeScaleBarFrom(s);
        }
        Icy.getMainInterface().removeGlobalSequenceListener((GlobalSequenceListener)this);
    }

    public void sequenceOpened(Sequence sequence) {
        Scale.addScaleBarTo(sequence);
    }

    public void sequenceClosed(Sequence sequence) {
        Scale.removeScaleBarFrom(sequence);
    }

    public static ScaleBarOverlay addScaleBarTo(Sequence sequence) {
        if (sequence == null) {
            throw new IcyHandledException("Cannot add the scale bar: no sequence specified");
        }
        if (sequence.hasOverlay(ScaleBarOverlay.class)) {
            return (ScaleBarOverlay)((Object)sequence.getOverlays(ScaleBarOverlay.class).get(0));
        }
        ScaleBarOverlay overlay = new ScaleBarOverlay(preferences);
        sequence.addOverlay((Overlay)overlay);
        String name = sequence.getName().toLowerCase();
        if (name.startsWith("rendering") || name.startsWith("screen shot")) {
            for (Viewer viewer : sequence.getViewers()) {
                viewer.getCanvas().getLayer((Overlay)overlay).setVisible(false);
            }
        }
        return overlay;
    }

    public static void removeScaleBarFrom(Sequence sequence) {
        if (sequence == null) {
            throw new IcyHandledException("Cannot remove the scale bar: no sequence specified");
        }
        for (Overlay o : sequence.getOverlays(ScaleBarOverlay.class)) {
            sequence.removeOverlay(o);
        }
    }
}

