/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.scale;

import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvas2D;
import icy.math.MathUtil;
import icy.math.UnitUtil;
import icy.painter.Overlay;
import icy.preferences.GeneralPreferences;
import icy.preferences.XMLPreferences;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;
import icy.util.ColorUtil;
import icy.util.GraphicsUtil;
import icy.util.ShapeUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.swing.JLabel;
import javax.swing.JPanel;
import plugins.adufour.vars.gui.model.IntegerRangeModel;
import plugins.adufour.vars.gui.model.VarEditorModel;
import plugins.adufour.vars.gui.swing.SwingVarEditor;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarBoolean;
import plugins.adufour.vars.lang.VarColor;
import plugins.adufour.vars.lang.VarEnum;
import plugins.adufour.vars.lang.VarInteger;
import plugins.kernel.canvas.VtkCanvas;
import plugins.tprovoost.scale.ScaleBarLocation;
import plugins.tprovoost.scale.ScaleBarUnit;

public class ScaleBarOverlay
extends Overlay {
    private static final double[] scaleRoundedFactors = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 20.0, 30.0, 40.0, 50.0, 60.0, 70.0, 80.0, 90.0, 100.0, 200.0, 300.0, 400.0, 500.0, 600.0, 700.0, 800.0, 900.0};
    private final XMLPreferences preferences;
    private final Line2D.Double line;
    private JPanel optionPanel;
    private boolean init = false;
    private final VarEnum<ScaleBarLocation> location;
    private final VarColor color;
    private final VarBoolean opaque;
    private final VarBoolean showText;
    private final VarInteger size;
    private final VarInteger thickness;
    private final VarEnum<ScaleBarUnit> unit;
    private final VarBoolean autoSize;

    public ScaleBarOverlay(final XMLPreferences preferences) {
        super("Scale bar", Overlay.OverlayPriority.TOPMOST);
        this.preferences = preferences;
        this.line = new Line2D.Double();
        this.location = new VarEnum<ScaleBarLocation>("Location", ScaleBarLocation.valueOf(preferences.get("location", ScaleBarLocation.VIEWER_BOTTOM_LEFT.name()))){

            public void setValue(ScaleBarLocation newValue) {
                if (((ScaleBarLocation)((Object)this.getValue())).equals((Object)newValue)) {
                    return;
                }
                super.setValue((Object)newValue);
                preferences.put("location", newValue.name());
                ScaleBarOverlay.this.painterChanged();
            }
        };
        this.color = new VarColor("Color", new Color(preferences.getInt("color", new Color(255, 255, 255, 255).getRGB()))){

            public void setValue(Color newValue) {
                if (((Color)this.getValue()).equals(newValue)) {
                    return;
                }
                super.setValue((Object)newValue);
                preferences.putInt("color", newValue.getRGB());
                ScaleBarOverlay.this.painterChanged();
            }
        };
        this.opaque = new VarBoolean("Opaque", preferences.getBoolean("opaque", false)){

            public void setValue(Boolean newValue) {
                if (((Boolean)this.getValue()).equals(newValue)) {
                    return;
                }
                super.setValue((Object)newValue);
                preferences.putBoolean("opaque", newValue.booleanValue());
                ScaleBarOverlay.this.painterChanged();
            }
        };
        this.showText = new VarBoolean("Display size", preferences.getBoolean("showText", true)){

            public void setValue(Boolean newValue) {
                if (((Boolean)this.getValue()).equals(newValue)) {
                    return;
                }
                super.setValue((Object)newValue);
                preferences.putBoolean("showText", newValue.booleanValue());
                ScaleBarOverlay.this.painterChanged();
            }
        };
        this.size = new VarInteger("Size", preferences.getInt("size", 10)){

            public void setValue(Integer newValue) {
                if (this.getValue().equals(newValue)) {
                    return;
                }
                super.setValue((Object)newValue);
                preferences.putInt("size", newValue.intValue());
                ScaleBarOverlay.this.painterChanged();
            }
        };
        this.thickness = new VarInteger("Thickness", preferences.getInt("thickness", 5)){

            public void setValue(Integer newValue) {
                if (this.getValue().equals(newValue)) {
                    return;
                }
                super.setValue((Object)newValue);
                preferences.putInt("thickness", newValue.intValue());
                ScaleBarOverlay.this.painterChanged();
            }
        };
        this.unit = new VarEnum<ScaleBarUnit>("Unit", ScaleBarUnit.valueOf(preferences.get("unit", ScaleBarUnit.MICRO.name()))){

            public void setValue(ScaleBarUnit newValue) {
                if (((ScaleBarUnit)((Object)this.getValue())).equals((Object)newValue)) {
                    return;
                }
                super.setValue((Object)newValue);
                preferences.put("unit", newValue.name());
                ScaleBarOverlay.this.painterChanged();
            }
        };
        this.autoSize = new VarBoolean("Auto-adjust size", preferences.getBoolean("autoSize", false)){

            public void setValue(Boolean newValue) {
                if (((Boolean)this.getValue()).equals(newValue)) {
                    return;
                }
                super.setValue((Object)newValue);
                preferences.putBoolean("autoSize", newValue.booleanValue());
                ScaleBarOverlay.this.painterChanged();
            }
        };
        Integer currentSize = this.size.getValue();
        this.size.setDefaultEditorModel((VarEditorModel)new IntegerRangeModel(Integer.valueOf(10), Integer.valueOf(1), Integer.valueOf(999), Integer.valueOf(1)));
        this.size.setValue((Object)currentSize);
        Integer currentThickness = this.thickness.getValue();
        this.thickness.setDefaultEditorModel((VarEditorModel)new IntegerRangeModel(Integer.valueOf(5), Integer.valueOf(1), Integer.valueOf(20), Integer.valueOf(1)));
        this.thickness.setValue((Object)currentThickness);
        ThreadUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ScaleBarOverlay.this.initOptionPanel();
            }
        });
    }

    private void initOptionPanel() {
        this.optionPanel = new JPanel(new GridBagLayout());
        for (Var variable : new Var[]{this.location, this.color, this.opaque, this.autoSize, this.size, this.thickness, this.showText}) {
            SwingVarEditor editor;
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(2, 10, 2, 5);
            gbc.fill = 1;
            this.optionPanel.add((Component)new JLabel(variable.getName()), gbc);
            if (variable == this.size) {
                gbc.weightx = 0.5;
                editor = (SwingVarEditor)variable.createVarEditor(true);
                this.optionPanel.add((Component)editor.getEditorComponent(), gbc);
                gbc.gridwidth = 0;
                SwingVarEditor unitEditor = (SwingVarEditor)this.unit.createVarEditor(true);
                this.optionPanel.add((Component)unitEditor.getEditorComponent(), gbc);
                continue;
            }
            gbc.weightx = 1.0;
            gbc.gridwidth = 0;
            editor = (SwingVarEditor)variable.createVarEditor(true);
            this.optionPanel.add((Component)editor.getEditorComponent(), gbc);
        }
    }

    public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
        double sizeY;
        double sizeX;
        double unit;
        if (canvas instanceof VtkCanvas && !this.init) {
            this.init = true;
            return;
        }
        if (g == null || !(canvas instanceof IcyCanvas2D)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        IcyCanvas2D canvas2d = (IcyCanvas2D)canvas;
        if (((Boolean)this.autoSize.getValue()).booleanValue()) {
            int sizeW = Math.min(canvas.getCanvasSizeX() / 4, Math.max(canvas.getCanvasSizeX() / 7, 120));
            if (((ScaleBarLocation)((Object)this.location.getValue())).isRelativeToImage()) {
                sizeW = (int)Math.min((double)sizeW, (double)sequence.getSizeX() * canvas.getScaleX() * 0.5);
            }
            double valueReal = (double)sizeW * sequence.getPixelSizeX() / canvas.getScaleX();
            UnitUtil.UnitPrefix bestUnit = UnitUtil.getBestUnit((double)(valueReal * 0.1), (UnitUtil.UnitPrefix)UnitUtil.UnitPrefix.MICRO, (int)1);
            double valueRealBestUnit = UnitUtil.getValueInUnit((double)valueReal, (UnitUtil.UnitPrefix)UnitUtil.UnitPrefix.MICRO, (UnitUtil.UnitPrefix)bestUnit);
            double closestScale = MathUtil.closest((double)valueRealBestUnit, (double[])scaleRoundedFactors);
            this.size.setValue((Object)((int)closestScale));
            this.unit.setValue((Object)ScaleBarUnit.getUnitFrom(bestUnit));
        }
        String text = this.size.getValue() + " " + this.unit.getValue();
        double length = UnitUtil.getValueInUnit((double)this.size.getValue().intValue(), (UnitUtil.UnitPrefix)((ScaleBarUnit)((Object)this.unit.getValue())).asUnitPrefix(), (UnitUtil.UnitPrefix)UnitUtil.UnitPrefix.MICRO) / sequence.getPixelSizeX();
        if (((ScaleBarLocation)((Object)this.location.getValue())).isRelativeToImage()) {
            unit = canvas.canvasToImageDeltaX(1);
            sizeX = canvas.getImageSizeX();
            sizeY = canvas.getImageSizeY();
        } else {
            unit = 1.0;
            sizeX = canvas.getCanvasSizeX();
            sizeY = canvas.getCanvasSizeY();
            length = canvas.imageToCanvasDeltaX(length);
            g2.transform(canvas2d.getInverseTransform());
        }
        float finalThickness = (float)(this.thickness.getValue().doubleValue() * unit);
        float fontSize = (float)((double)(GeneralPreferences.getGuiFontSize() + 2) * unit);
        double borderDist = 20.0 * unit;
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setStroke(new BasicStroke(finalThickness, 0, 0));
        Rectangle2D textBnds = new Rectangle2D.Double();
        if (((Boolean)this.showText.getValue()).booleanValue()) {
            g2.setFont(g2.getFont().deriveFont(1, fontSize));
            textBnds = GraphicsUtil.getStringBounds((Graphics)g2, (String)text);
        }
        switch ((ScaleBarLocation)((Object)this.location.getValue())) {
            case VIEWER_BOTTOM_LEFT: 
            case IMAGE_BOTTOM_LEFT: {
                this.line.x1 = borderDist;
                this.line.x2 = this.line.x1 + length;
                this.line.y1 = sizeY - (textBnds.getHeight() + borderDist / 2.0);
                break;
            }
            case VIEWER_BOTTOM_RIGHT: 
            case IMAGE_BOTTOM_RIGHT: {
                this.line.x1 = sizeX - borderDist;
                this.line.x2 = this.line.x1 - length;
                this.line.y1 = sizeY - (textBnds.getHeight() + borderDist / 2.0);
                break;
            }
            case VIEWER_TOP_LEFT: 
            case IMAGE_TOP_LEFT: {
                this.line.x1 = borderDist;
                this.line.x2 = this.line.x1 + length;
                this.line.y1 = borderDist / 2.0;
                break;
            }
            case VIEWER_TOP_RIGHT: 
            case IMAGE_TOP_RIGHT: {
                this.line.x1 = sizeX - borderDist;
                this.line.x2 = this.line.x1 - length;
                this.line.y1 = borderDist / 2.0;
            }
        }
        this.line.y2 = this.line.y1;
        if (((Boolean)this.opaque.getValue()).booleanValue()) {
            if (ColorUtil.getLuminance((Color)((Color)this.color.getValue())) > 128) {
                g2.setColor(Color.black);
            } else {
                g2.setColor(Color.white);
            }
            Rectangle2D rect = this.line.getBounds2D();
            ShapeUtil.enlarge((RectangularShape)rect, (double)(8.0 * unit), (double)(8.0 * unit), (boolean)true);
            if (((Boolean)this.showText.getValue()).booleanValue()) {
                rect.setRect(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight() + textBnds.getHeight());
            }
            g2.fill(rect);
        } else {
            if (ColorUtil.getLuminance((Color)((Color)this.color.getValue())) > 128) {
                g2.setColor(Color.darkGray);
            } else {
                g2.setColor(Color.lightGray);
            }
            this.line.x1 += unit;
            this.line.y1 += unit;
            this.line.x2 += unit;
            this.line.y2 += unit;
            g2.draw(this.line);
            this.line.x1 -= unit;
            this.line.y1 -= unit;
            this.line.x2 -= unit;
            this.line.y2 -= unit;
        }
        g2.setColor((Color)this.color.getValue());
        g2.draw(this.line);
        if (((Boolean)this.showText.getValue()).booleanValue()) {
            float baseX = (float)this.line.getBounds().getCenterX();
            float baseY = (float)(this.line.getBounds().getCenterY() + unit * 4.0);
            float x = (float)((double)baseX - textBnds.getWidth() / 2.0);
            float y = (float)((double)baseY - textBnds.getY());
            if (!((Boolean)this.opaque.getValue()).booleanValue()) {
                if (ColorUtil.getLuminance((Color)((Color)this.color.getValue())) > 128) {
                    g2.setColor(Color.darkGray);
                } else {
                    g2.setColor(Color.lightGray);
                }
                g2.drawString(text, (float)((double)x + unit), (float)((double)y + unit));
                g2.setColor((Color)this.color.getValue());
            }
            g2.drawString(text, x, y);
        }
        g2.dispose();
    }

    public JPanel getOptionsPanel() {
        return this.optionPanel;
    }

    public boolean getAutoSize() {
        return (Boolean)this.autoSize.getValue();
    }

    public Color getColor() {
        return (Color)this.color.getValue();
    }

    public boolean getOpaque() {
        return (Boolean)this.opaque.getValue();
    }

    public ScaleBarLocation getLocation() {
        return (ScaleBarLocation)((Object)this.location.getValue());
    }

    public double getSize() {
        return this.size.getValue().intValue();
    }

    public boolean getTextDisplay() {
        return (Boolean)this.showText.getValue();
    }

    public void setAutoSize(boolean autoSize) {
        this.autoSize.setValue((Object)autoSize);
    }

    public void setColor(Color color) {
        this.color.setValue((Object)color);
    }

    public void setOpaque(boolean opaque) {
        this.opaque.setValue((Object)opaque);
    }

    public void setLocation(ScaleBarLocation location) {
        this.location.setValue((Object)location);
    }

    public void setTextDisplay(boolean displayText) {
        this.showText.setValue((Object)displayText);
    }

    public void setSize(int size) {
        this.size.setValue((Object)size);
    }

    public void setUnit(UnitUtil.UnitPrefix unit) {
        this.unit.setValue((Object)ScaleBarUnit.getUnitFrom(unit));
    }
}

