package plugins.lagache.trackmanager.processors;

import icy.file.FileUtil;
import icy.gui.frame.progress.AnnounceFrame;
import icy.gui.util.GuiUtil;
import icy.main.Icy;
import icy.sequence.Sequence;
import icy.swimmingPool.SwimmingObject;
import icy.util.XLSUtil;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;

import java.awt.Checkbox;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;

import plugins.fab.trackmanager.PluginTrackManagerProcessor;
import plugins.fab.trackmanager.TrackGroup;
import plugins.fab.trackmanager.TrackManager;
import plugins.fab.trackmanager.TrackPool;
import plugins.fab.trackmanager.TrackSegment;
import plugins.nchenouard.spot.Detection;

public class Dynamics_classifier  extends PluginTrackManagerProcessor implements ActionListener {
		
	
	
	JPanel columnsPanel;
	
	Integer min = new Integer(0);
	Integer max = new Integer(100);
	Integer step = new Integer(1);

	Double mind = new Double(0.);
	Double maxd = new Double(1.);
	Double stepd = new Double(0.01);
	
	SpinnerNumberModel Tracklet_size = new SpinnerNumberModel(new Integer(1), min, max, step);
	JSpinner nb1Spinner = new JSpinner(Tracklet_size);
	SpinnerNumberModel Perc_virtual = new SpinnerNumberModel(new Double(1), mind, maxd, stepd);
	JSpinner nb2Spinner = new JSpinner(Perc_virtual);
	Checkbox immobile = new Checkbox("Extract immobile tracks first", false);
	JButton exportButton = new JButton("export to console");
    JButton exportExcelButton = new JButton("export to excel");

	public Dynamics_classifier() {

		setName( "Classify tracks dynamics");
		
		panel.setLayout( new BoxLayout( panel , BoxLayout.PAGE_AXIS ) );									
		columnsPanel = new JPanel(new GridLayout(0, 2));
		columnsPanel.add(new JLabel("Size of tracklets"));columnsPanel.add(nb1Spinner);		
		columnsPanel.add(new JLabel("Max. % of virtual detections"));columnsPanel.add(nb2Spinner);
		panel.add(columnsPanel);
		
		panel.add(immobile);
		exportButton.addActionListener(this);
	    exportExcelButton.addActionListener(this);
	    panel.add(GuiUtil.besidesPanel(exportButton, exportExcelButton));
		
	}
	
	@Override
	public void Close() {
	}

	@Override
	public void Compute() {
	}

	@Override
	public void displaySequenceChanged() {

		
	}

	 public void actionPerformed(ActionEvent e)
	    {

	        // if ( e.getSource() == useRoiAsBoundsForChartButton )
	        // {
	        // Shape shape = (Shape) trackPool.getDisplaySequence().getROIs().get( 0 );
	        // chartRectangleInSequence = (Rectangle2D) shape.getBounds2D().clone();
	        // }
	        if (e.getSource() == exportButton)
	        {
	        	classify_dynamics(false);
	        }

	        if (e.getSource() == exportExcelButton)
	        {
	        	classify_dynamics(true);
	        }

	        trackPool.fireTrackEditorProcessorChange();

	    }

	private void classify_dynamics(Boolean excel) {
		
		
		int tracklet_size=Tracklet_size.getNumber().intValue();
		double perc=Perc_virtual.getNumber().doubleValue();
		ArrayList<TrackSegment> tracks_liste = (ArrayList<TrackSegment>)(trackPool.getTrackSegmentList().clone());
		//delete_virtual
		ArrayList<TrackSegment> tracks_liste_nov = delete_virtual(tracks_liste,perc,tracklet_size);
		//we first remove/classify immobile tracks
		ArrayList<TrackSegment> tracks_immo = define_immobile_tracks(tracks_liste_nov);
		if (immobile.getState()) {
		tracks_liste_nov.removeAll(tracks_immo);}
		HashMap<TrackSegment,HashMap<TrackSegment,Integer>> classified_tracklets = define_tracklets(tracks_liste_nov,tracklet_size+1);
		motion_classification(classified_tracklets, tracklet_size);
		if (excel) {
			exportToXLS(classified_tracklets, tracklet_size);
		}
		}

	
	private ArrayList<TrackSegment> delete_virtual(ArrayList<TrackSegment> track_liste,double perc_v,int T)
	{
		ArrayList<TrackSegment> liste_wov = new ArrayList<TrackSegment>();
		for (TrackSegment ts:track_liste) {
			if (ts.getDetectionList().size()>T){
			int nb_v=0;int nb_succ=0;
			for (Detection d:ts.getDetectionList()) {
				if (d.getDetectionType()==2) {
					nb_v+=1;nb_succ+=1;
					if (nb_succ==3) {break;}
					else {nb_succ=0;}															
				}
			}
			double pc = (double)(nb_v/ts.getDetectionList().size());
			if (pc<perc_v) {liste_wov.add(ts);}
			}		}
		return liste_wov;
	}
	private ArrayList<TrackSegment> define_immobile_tracks(ArrayList<TrackSegment> tracks_liste){
	ArrayList<TrackSegment> tracks_immo = new ArrayList<TrackSegment>();	
	for (TrackSegment ts:tracks_liste) {
		double extent = 0;		
		for (Detection d1:ts.getDetectionList()) {
			for (Detection d2:ts.getDetectionList()) {
				double dist = Math.hypot(d1.getX()-d2.getX(), d1.getY()-d2.getY());
				if (dist>extent) {extent=dist;}				
			}}
		if (extent<2*Math.sqrt(2)) {tracks_immo.add(ts);}
		}
	return tracks_immo;	
	}
	
	private HashMap<TrackSegment,HashMap<TrackSegment,Integer>> define_tracklets(ArrayList<TrackSegment> tracks_liste,int tracklet_size){
		HashMap<TrackSegment,HashMap<TrackSegment,Integer>> classified_tracklets = new HashMap<TrackSegment,HashMap<TrackSegment,Integer>>();
		for (TrackSegment ts:tracks_liste) {
			int i=0;						
			HashMap<TrackSegment, Integer> tracklets_c = new HashMap<TrackSegment, Integer>();			
			while (i<ts.getDetectionList().size()-tracklet_size+1) {				
				ArrayList<Detection> tracklet_det = new ArrayList<Detection>();
				for (int j=0; j<tracklet_size;j++) {
					tracklet_det.add(ts.getDetectionAt(i+j));
				}
				TrackSegment tracklet = new TrackSegment(tracklet_det);
				//for tracklet classification: 0=immobile, 1=confined, 2= brownian and 3=directed				
				tracklets_c.put(tracklet, 0);				
				i=i+tracklet_size;
			}
			classified_tracklets.put(ts,tracklets_c);								
			}			
			return classified_tracklets;
			}
		
	private void motion_classification(HashMap<TrackSegment,HashMap<TrackSegment,Integer>> classified_tracklets, int T) {
		//for tracklet classification: 0=immobile, 1=confined, 2= brownian and 3=directed
						//quantiles of order alpha/2 and (1-alpha/2) with alpha =0.05
			//quantiles depend on the length of the trajectories !

		//by default, quantiles correspond to N=5
			double q1= .724;
			double q2= 2.464;
			if (T==5) {  
			     q1=  .724; 
			     q2=  2.464; }
			if (T==10) {  				
			     q1=.725;
			     q2=2.626;} 
			if (T==30) {  				
			     q1=.754;
			     q2=2.794;}
			Iterator iterator = classified_tracklets.entrySet().iterator();
			int nb_brownian=0;
			int nb_confined=0;
			int nb_directed=0;			
			int nb_tracklets=0;
	        while (iterator.hasNext()) { 	        	
	        	Map.Entry<TrackSegment, HashMap<TrackSegment,Integer>> entry = (Entry<TrackSegment, HashMap<TrackSegment, Integer>>) iterator.next();
	        	TrackSegment ts = entry.getKey();
	        	HashMap<TrackSegment,Integer> tracklets = classified_tracklets.get(ts);
	        	Iterator iterator2 = tracklets.entrySet().iterator();
	        	while (iterator2.hasNext()) {
	        		Map.Entry<TrackSegment,Integer> entry2 = (Entry<TrackSegment, Integer>) iterator2.next();
	        		TrackSegment tsl = (TrackSegment) entry2.getKey();
	        		nb_tracklets++;
	        		//computation of max distance
	        		Detection ini= tsl.getDetectionAt(0);
	        		double dist=0;double sig = 0;
	        		ArrayList<Detection> liste = tsl.getDetectionList();
	        		for (int i=1;i<liste.size();i++) {
	        			Detection d = liste.get(i);
	        			Detection d0 = liste.get(i-1);	        			
	        			double temp=Math.sqrt(Math.pow(ini.getX()-d.getX(), 2)+Math.pow(ini.getY()-d.getY(), 2));
	        			dist = Math.max(dist, temp);
	        			sig+=Math.pow(d.getX()-d0.getX(), 2)+Math.pow(d.getY()-d0.getY(), 2);
	        		}
	        		sig = Math.sqrt(sig/2);
	        		//statistical test
	        		double stat = dist/sig;
	        		if (stat<q1) {//confined
	        				tracklets.put(tsl, 1);nb_confined++;}	        			
	        		else
	        			if (stat>q2){tracklets.put(tsl, 3);nb_directed++;}
	        			else {tracklets.put(tsl, 2);nb_brownian++;}
	        		}
	        	double temp=0;
	        	temp++;
	        	}	        			        		        
	        System.out.println("nb tracklets :" + nb_tracklets);
	        System.out.println("% Confined :" + (float)nb_confined/nb_tracklets);
	        System.out.println("% Brownian :" + (float)nb_brownian/nb_tracklets);
	        System.out.println("% Directed :" + (float)nb_directed/nb_tracklets);
	}	


	private void exportToXLS(HashMap<TrackSegment,HashMap<TrackSegment,Integer>> classified_tracklets, Integer tracklets_size ) {

		JFileChooser chooser = new JFileChooser();
		chooser.setDialogTitle("Select xls file.");
		
		int returnVal = chooser.showOpenDialog(null);
		if(returnVal != JFileChooser.APPROVE_OPTION) return;
		

		//initialisation excel
		int cursorY = 0;		
		WritableWorkbook WW = null;
		WritableSheet WS = null;
		int page = 1;
		try {
				File f = chooser.getSelectedFile();
				if (!FileUtil.getFileExtension(f.getPath(), false)
						.equalsIgnoreCase("xls"))
					f = new File(f.getPath() + ".xls");
				WW = XLSUtil.loadWorkbookForWrite(f); 
				}							
			 
		catch (Exception e) {
				e.printStackTrace();
				return;}
		
		WS  = XLSUtil.createNewPage(WW, "Tracks" + page);
		XLSUtil.setCellString(WS, 0, cursorY, "track #");
		XLSUtil.setCellString(WS, 1 , cursorY, "t0");
		XLSUtil.setCellString(WS, 2 , cursorY, "tf");			
		XLSUtil.setCellString(WS, 3 , cursorY, "Duration");
		XLSUtil.setCellString(WS, 4 , cursorY, "nb of tracklets");		
		XLSUtil.setCellString(WS, 5 , cursorY, "nb of Confined tracklets");
		XLSUtil.setCellString(WS, 6 , cursorY, "nb of Brownian tracklets");
		XLSUtil.setCellString(WS, 7 , cursorY, "nb of Directed tracklets");
		XLSUtil.setCellString(WS, 8 , cursorY, "nb of changes");
		XLSUtil.setCellString(WS, 9 , cursorY, "Mean change time");
		cursorY++;int index = 0;			
		Iterator iterator = classified_tracklets.entrySet().iterator();
		while (iterator.hasNext()) { 	        	
        	Map.Entry<TrackSegment, HashMap<TrackSegment,Integer>> entry = (Entry<TrackSegment, HashMap<TrackSegment, Integer>>) iterator.next();
        	TrackSegment ts = entry.getKey();
        	XLSUtil.setCellNumber(WS, 0 , cursorY, index );index++;
        	XLSUtil.setCellNumber(WS, 1 , cursorY, ts.getFirstDetection().getT() );
        	XLSUtil.setCellNumber(WS, 2 , cursorY, ts.getLastDetection().getT() );
        	XLSUtil.setCellNumber(WS, 3 , cursorY, ts.getLastDetection().getT()-ts.getFirstDetection().getT() );
        	HashMap<TrackSegment,Integer> tracklets = classified_tracklets.get(ts);
        	Iterator iterator2 = tracklets.entrySet().iterator();
        	int nb_brownian=0;
    		int nb_confined=0;
    		int nb_directed=0;			
    		int nb_tracklets=0;            
    		//initial type of motion
    		Map.Entry<TrackSegment,Integer> entry2 = (Entry<TrackSegment, Integer>) iterator2.next();    		
    		int current_motion = entry2.getValue();int change_time = 0;
    		double mean_change_time=0;int nb_changes=0;
    		nb_tracklets++;
    		if (entry2.getValue()==1) {nb_confined++;}
    		if (entry2.getValue()==2) {nb_brownian++;}
    		if (entry2.getValue()==3) {nb_directed++;}
        	while (iterator2.hasNext()) {
        		entry2 = (Entry<TrackSegment, Integer>) iterator2.next();
        		TrackSegment tsl = (TrackSegment) entry2.getKey();
        		nb_tracklets++;
        		if (entry2.getValue()==1) {nb_confined++;}
        		if (entry2.getValue()==2) {nb_brownian++;}
        		if (entry2.getValue()==3) {nb_directed++;}
        		if (entry2.getValue()!=current_motion) {
        			current_motion=entry2.getValue();
        			mean_change_time+=change_time;
        			change_time=0;
        			nb_changes++;}
        		else {change_time+=tracklets_size;}
        	}
        	XLSUtil.setCellNumber(WS, 4 , cursorY, nb_tracklets);		
    		XLSUtil.setCellNumber(WS, 5 , cursorY, nb_confined);
    		XLSUtil.setCellNumber(WS, 6 , cursorY, nb_brownian);
    		XLSUtil.setCellNumber(WS, 7 , cursorY, nb_directed);
    		XLSUtil.setCellNumber(WS, 8 , cursorY, nb_changes);
    		if (nb_changes>0) {
    		XLSUtil.setCellNumber(WS, 9 , cursorY, (float)(mean_change_time/nb_changes));}
    		cursorY++;
		}
				
		try {
			XLSUtil.saveAndClose(WW);
			} catch (WriteException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();}
		
	}	public static void sendTracksToPool(final TrackGroup trackGroup) {
		SwingUtilities.invokeLater(new Runnable()
		{
			@Override
			public void run() {
				// Add the given trackGroup
				SwimmingObject result = new SwimmingObject(trackGroup);// should
				Icy.getMainInterface().getSwimmingPool().add(result);				
			}
		});
	}
	
}
