/*
 * Decompiled with CFR 0.152.
 */
package be.cytomine.client;

import be.cytomine.client.Cytomine;
import be.cytomine.client.CytomineException;
import be.cytomine.client.HttpClient;
import be.cytomine.client.models.User;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class CytomineConnection {
    private static final Logger log = LogManager.getLogger(Cytomine.class);
    private String host;
    private String login;
    private String pass;
    private String publicKey;
    private String privateKey;
    private User currentUser;

    CytomineConnection(String host, String publicKey, String privateKey) {
        this.host = host;
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.login = publicKey;
        this.pass = privateKey;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public User getCurrentUser() throws CytomineException {
        return this.getCurrentUser(false);
    }

    public User getCurrentUser(boolean forceRefresh) throws CytomineException {
        if (forceRefresh || this.currentUser == null) {
            User user = new User();
            user.set("current", "current");
            this.currentUser = (User)user.fetch(null);
        }
        return this.currentUser;
    }

    private void analyzeCode(int code, JSONObject json) throws CytomineException {
        if (code >= 400 && code < 600) {
            throw new CytomineException(code, json);
        }
        if (code == 302) {
            throw new CytomineException(code, json);
        }
    }

    private JSONObject createJSONResponse(int code, String response) throws CytomineException {
        try {
            Object obj = JSONValue.parse((String)response);
            return (JSONObject)obj;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new CytomineException(code, response);
        }
        catch (Error e) {
            log.error((Object)e);
            throw new CytomineException(code, response);
        }
    }

    public JSONObject doRequest(Method method, String URL2, String data) throws CytomineException {
        HttpClient client = new HttpClient(this.publicKey, this.privateKey, this.getHost());
        try {
            client.authorize(method.toString(), URL2, "", "application/json,*/*");
            client.connect(this.getHost() + URL2);
            int code = 400;
            switch (method) {
                case GET: {
                    code = client.get();
                    break;
                }
                case POST: {
                    code = client.post(data);
                    break;
                }
                case DELETE: {
                    code = client.delete();
                    break;
                }
                case PUT: {
                    code = client.put(data);
                }
            }
            String response = client.getResponseData();
            client.disconnect();
            JSONObject json = this.createJSONResponse(code, response);
            this.analyzeCode(code, json);
            return json;
        }
        catch (IOException e) {
            throw new CytomineException(e);
        }
    }

    public JSONObject doGet(String URL2) throws CytomineException {
        return this.doRequest(Method.GET, URL2, null);
    }

    public JSONObject doPost(String URL2, String data) throws CytomineException {
        return this.doRequest(Method.POST, URL2, data);
    }

    public JSONObject doDelete(String URL2) throws CytomineException {
        return this.doRequest(Method.DELETE, URL2, null);
    }

    public JSONObject doPut(String URL2, String data) throws CytomineException {
        return this.doRequest(Method.PUT, URL2, data);
    }

    public JSONObject uploadFile(String url, byte[] data, Map<String, String> entityParts) throws CytomineException {
        try {
            HttpClient client = null;
            MultipartEntity entity = new MultipartEntity();
            entity.addPart("files[]", (ContentBody)new ByteArrayBody(data, new Date().getTime() + "file"));
            if (entityParts != null) {
                for (Map.Entry<String, String> entry : entityParts.entrySet()) {
                    entity.addPart(entry.getKey(), (ContentBody)new StringBody(entry.getValue()));
                }
            }
            client = new HttpClient(this.publicKey, this.privateKey, this.getHost());
            client.authorize("POST", url, entity.getContentType().getValue(), "application/json,*/*");
            client.connect(this.getHost() + url);
            int code = client.post(entity);
            String response = client.getResponseData();
            log.debug("response=" + response);
            client.disconnect();
            JSONObject json = this.createJSONResponse(code, response);
            this.analyzeCode(code, json);
            return json;
        }
        catch (IOException e) {
            throw new CytomineException(e);
        }
    }

    public JSONObject uploadFile(String url, byte[] data) throws CytomineException {
        return this.uploadFile(url, data, null);
    }

    public JSONObject uploadFile(String url, File file, Map<String, String> entityParts) throws CytomineException {
        try {
            if (!entityParts.containsKey("filename")) {
                entityParts.put("filename", file.getName());
            }
            return this.uploadFile(url, Files.readAllBytes(file.toPath()), entityParts);
        }
        catch (IOException e) {
            throw new CytomineException(e);
        }
    }

    public JSONObject uploadFile(String url, File file) throws CytomineException {
        HashMap<String, String> entity = new HashMap<String, String>();
        entity.put("filename", file.getName());
        return this.uploadFile(url, file, entity);
    }

    public JSONObject uploadFile(String url, String file) throws CytomineException {
        return this.uploadFile(url, new File(file));
    }

    public JSONArray uploadImage(String file, String url, Map<String, String> entityParts) throws CytomineException {
        try {
            HttpClient client = null;
            MultipartEntity entity = new MultipartEntity();
            for (Map.Entry<String, String> entry : entityParts.entrySet()) {
                entity.addPart(entry.getKey(), (ContentBody)new StringBody(entry.getValue()));
            }
            entity.addPart("files[]", (ContentBody)new FileBody(new File(file)));
            client = new HttpClient(this.publicKey, this.privateKey, this.getHost());
            client.authorize("POST", url, entity.getContentType().getValue(), "application/json,*/*");
            client.connect(this.getHost() + url);
            int code = client.post(entity);
            String response = client.getResponseData();
            log.debug("response=" + response);
            client.disconnect();
            Object obj = JSONValue.parse((String)response);
            return (JSONArray)obj;
        }
        catch (IOException e) {
            throw new CytomineException(e);
        }
    }

    public void downloadPicture(String url, String dest) throws CytomineException {
        this.downloadPicture(url, dest, "jpg");
    }

    public void downloadPicture(String url, String dest, String format) throws CytomineException {
        HttpClient client = null;
        try {
            client = new HttpClient(this.publicKey, this.privateKey, this.getHost());
            BufferedImage img = client.readBufferedImageFromURL(url);
            ImageIO.write((RenderedImage)img, format, new File(dest));
        }
        catch (Exception e) {
            throw new CytomineException(0, e.toString());
        }
    }

    public void downloadPictureWithRedirect(String url, String dest, String format) throws CytomineException {
        HttpClient client = null;
        try {
            client = new HttpClient(this.publicKey, this.privateKey, this.getHost());
            BufferedImage img = HttpClient.readBufferedImageFromRETRIEVAL(url, this.login, this.pass, this.getHost());
            ImageIO.write((RenderedImage)img, format, new File(dest));
        }
        catch (Exception e) {
            throw new CytomineException(0, e.toString());
        }
    }

    public BufferedImage getPictureAsBufferedImage(String url, String format) throws CytomineException {
        HttpClient client = null;
        try {
            client = new HttpClient(this.publicKey, this.privateKey, this.getHost());
            return client.readBufferedImageFromURL(url);
        }
        catch (Exception e) {
            throw new CytomineException(0, e.toString());
        }
    }

    public void downloadFile(String url, String dest) throws CytomineException {
        try {
            HttpClient client = new HttpClient(this.publicKey, this.privateKey, this.getHost());
            int code = client.get(this.getHost() + url, dest);
            this.analyzeCode(code, (JSONObject)JSONValue.parse((String)"{}"));
        }
        catch (Exception e) {
            throw new CytomineException(0, e.toString());
        }
    }

    private static enum Method {
        GET,
        PUT,
        POST,
        DELETE;

    }
}

