/*
 * Decompiled with CFR 0.152.
 */
package be.cytomine.client.models;

import be.cytomine.client.Cytomine;
import be.cytomine.client.CytomineConnection;
import be.cytomine.client.CytomineException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONObject;

public abstract class Model<T extends Model> {
    JSONObject attr = new JSONObject();
    HashMap<String, String> params = new HashMap();
    LinkedHashMap<String, String> filters = new LinkedHashMap();

    public String toJSON() {
        return this.attr.toString();
    }

    public String toURL() {
        return this.getJSONResourceURL();
    }

    public String getJSONResourceURL() {
        Long id = this.getId();
        String base = "/api/";
        base = base + this.getFilterPrefix();
        base = base + this.getDomainName();
        base = id != null ? base + "/" + id + ".json?" : base + ".json?";
        for (Map.Entry<String, String> param : this.params.entrySet()) {
            base = base + param.getKey() + "=" + param.getValue() + "&";
        }
        base = base.substring(0, base.length() - 1);
        return base;
    }

    public String getDomainName() {
        return this.getClass().getSimpleName().toLowerCase();
    }

    protected String getFilterPrefix() {
        StringBuilder prefix = new StringBuilder("");
        this.filters.forEach((k, v) -> prefix.append(k + "/" + v + "/"));
        return prefix.toString();
    }

    public T fetch(Long id) throws CytomineException {
        return this.fetch(Cytomine.getInstance().getDefaultCytomineConnection(), id);
    }

    public T fetch(CytomineConnection connection, Long id) throws CytomineException {
        this.set("id", id);
        JSONObject json = connection.doGet(this.toURL());
        this.setAttr(json);
        return (T)this;
    }

    public T save() throws CytomineException {
        return this.save(Cytomine.getInstance().getDefaultCytomineConnection());
    }

    public T save(CytomineConnection connection) throws CytomineException {
        JSONObject json = connection.doPost(this.toURL(), this.toJSON());
        if (json.get((Object)this.getDomainName()) == null) {
            this.setAttr((JSONObject)json.get((Object)this.getClass().getSimpleName().toLowerCase()));
        } else {
            this.setAttr((JSONObject)json.get((Object)this.getDomainName()));
        }
        return (T)this;
    }

    public void delete() throws CytomineException {
        this.delete(Cytomine.getInstance().getDefaultCytomineConnection());
    }

    public void delete(CytomineConnection connection) throws CytomineException {
        this.delete(connection, this);
    }

    public void delete(Long id) throws CytomineException {
        this.delete(Cytomine.getInstance().getDefaultCytomineConnection(), id);
    }

    public void delete(CytomineConnection connection, Long id) throws CytomineException {
        this.set("id", id);
        this.delete(connection, this);
    }

    private void delete(T model) throws CytomineException {
        this.delete(Cytomine.getInstance().getDefaultCytomineConnection(), model);
    }

    private void delete(CytomineConnection connection, T model) throws CytomineException {
        connection.doDelete(((Model)model).toURL());
    }

    public T update() throws CytomineException {
        return this.update(Cytomine.getInstance().getDefaultCytomineConnection());
    }

    public T update(CytomineConnection connection) throws CytomineException {
        JSONObject json = connection.doPut(this.toURL(), this.toJSON());
        if (json.get((Object)this.getDomainName()) == null) {
            this.setAttr((JSONObject)json.get((Object)this.getClass().getSimpleName().toLowerCase()));
        } else {
            this.setAttr((JSONObject)json.get((Object)this.getDomainName()));
        }
        return (T)this;
    }

    public T update(HashMap<String, Object> attributes) throws CytomineException {
        return this.update(Cytomine.getInstance().getDefaultCytomineConnection(), attributes);
    }

    public T update(CytomineConnection connection, HashMap<String, Object> attributes) throws CytomineException {
        attributes.forEach((k, v) -> this.set((String)k, v));
        return this.update(connection);
    }

    public Long getId() {
        return this.getLong("id");
    }

    public JSONObject getAttr() {
        return this.attr;
    }

    public Object get(String name) {
        try {
            return this.attr.get((Object)name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getStr(String name) {
        if (this.get(name) == null) {
            return null;
        }
        return this.get(name) + "";
    }

    public Integer getInt(String name) {
        String str = this.getStr(name);
        if (str == null) {
            return null;
        }
        return Integer.parseInt(str);
    }

    public Long getLong(String name) {
        String str = this.getStr(name);
        if (str == null) {
            return null;
        }
        return Long.parseLong(str);
    }

    public Double getDbl(String name) {
        if (this.get(name) == null) {
            return null;
        }
        if (this.get(name).getClass().getName().equals("java.lang.Long")) {
            return ((Long)this.get(name)).doubleValue();
        }
        return (Double)this.get(name);
    }

    public Boolean getBool(String name) {
        return (Boolean)this.get(name);
    }

    public List getList(String name) {
        return (List)this.get(name);
    }

    public String getFilter(String name) {
        return this.filters.get(name);
    }

    boolean isFilterBy(String name) {
        return this.filters.containsKey(name);
    }

    public void addParams(String name, String value) {
        this.params.put(name, value);
    }

    public void setAttr(JSONObject attr) {
        this.attr = attr;
    }

    public void set(String name, Object value) {
        this.attr.put((Object)name, value);
    }

    public void addFilter(String name, String value) {
        if (value != null) {
            this.filters.put(name, value);
        }
    }

    public String toString() {
        return this.getDomainName() + this.getId();
    }

    public int hashCode() {
        if (this.getId() != null) {
            return this.getId().intValue();
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Model)) {
            return false;
        }
        return ((Model)o).getId().equals(this.getId());
    }
}

