/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.core.connection.persistence;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;
import javax.json.bind.annotation.JsonbProperty;
import org.bioimageanalysis.icy.icytomine.core.connection.persistence.UserCredential;

public class Preferences {
    private static Path DEFAULT_PREFERENCES_PATH = Paths.get(Paths.get("", new String[0]).toAbsolutePath().toString(), "preferences/icytomine.prefs");
    private static Preferences instance;
    private Map<String, HashMap<String, UserCredential>> availableCytomineCredentials = new HashMap<String, HashMap<String, UserCredential>>();
    @JsonbProperty(nillable=true)
    private String defaultHost = null;
    @JsonbProperty(nillable=true)
    private String defaultUser = null;

    public static Path getDefaultPreferencesPath() {
        return DEFAULT_PREFERENCES_PATH;
    }

    protected Preferences() {
    }

    public static Preferences getInstance() {
        if (instance == null) {
            instance = new Preferences();
        }
        return instance;
    }

    public Map<String, HashMap<String, UserCredential>> getAvailableCytomineCredentials() {
        return this.availableCytomineCredentials;
    }

    public void setAvailableCytomineCredentials(Map<String, HashMap<String, UserCredential>> cytomineCredentials) {
        this.availableCytomineCredentials = cytomineCredentials;
    }

    public String getDefaultHost() {
        return this.defaultHost;
    }

    public Optional<String> getDefaultHostURL() {
        return Optional.ofNullable(this.defaultHost);
    }

    public void setDefaultHost(String defaultHost) throws IllegalArgumentException {
        if (defaultHost != null && !this.getAvailableCytomineCredentials().containsKey(defaultHost)) {
            throw new IllegalArgumentException("Invalid host " + defaultHost);
        }
        this.defaultHost = defaultHost;
    }

    public String getDefaultUser() {
        return this.defaultUser;
    }

    public Optional<String> getDefaultUserName() {
        return Optional.ofNullable(this.defaultUser);
    }

    public void setDefaultUser(String defaultUser) throws IllegalArgumentException {
        Optional<String> defaultHostURL = this.getDefaultHostURL();
        if (defaultHostURL.isPresent()) {
            HashMap<String, UserCredential> users = this.getAvailableCytomineCredentials().get(defaultHostURL.get());
            if (defaultUser != null && users == null) {
                throw new IllegalArgumentException("default host " + defaultHostURL.get() + " does not exist in the hosts");
            }
            if (defaultUser != null && !users.containsKey(defaultUser)) {
                throw new IllegalArgumentException("Invalid user " + defaultUser);
            }
        } else {
            this.defaultUser = null;
        }
        this.defaultUser = defaultUser;
    }

    public static void save(Path path) throws IOException {
        Preferences instance = Preferences.getInstance();
        try {
            if (Files.notExists(DEFAULT_PREFERENCES_PATH.getParent(), new LinkOption[0])) {
                Files.createDirectories(DEFAULT_PREFERENCES_PATH.getParent(), new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new IOException("Exception preparing preferences path.", e);
        }
        try {
            Throwable e = null;
            Object var3_6 = null;
            try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING));){
                try {
                    Throwable throwable = null;
                    Object var6_12 = null;
                    try (Jsonb builder = JsonbBuilder.create(new JsonbConfig().setProperty("jsonb.formatting", true));){
                        builder.toJson((Object)instance, output);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception jsonE) {
                    throw new IOException("Exception converting preferences.", jsonE);
                }
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (FileNotFoundException e) {
            throw new IOException("Exception exporting preferences.", e);
        }
    }

    public static void save() throws IOException {
        Preferences.save(Preferences.getDefaultPreferencesPath());
    }

    public static void load(Path path) throws IOException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedInputStream input = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
                try {
                    Throwable throwable2 = null;
                    Object var5_10 = null;
                    try (Jsonb builder = JsonbBuilder.create(new JsonbConfig().setProperty("jsonb.formatting", true));){
                        instance = builder.fromJson((InputStream)input, Preferences.class);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Exception jsonE) {
                    throw new IOException("Exception converting preferences.", jsonE);
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new IOException("Exception loading preferences.", e);
        }
    }

    public static void load() throws IOException {
        Preferences.load(Preferences.getDefaultPreferencesPath());
    }

    public static void loadOrDefault() throws IOException {
        if (Files.exists(Preferences.getDefaultPreferencesPath(), new LinkOption[0])) {
            Preferences.load();
        } else {
            Preferences.clear();
        }
    }

    public static void clear() {
        instance = new Preferences();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.availableCytomineCredentials == null ? 0 : this.availableCytomineCredentials.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Preferences)) {
            return false;
        }
        Preferences other = (Preferences)obj;
        return !(this.availableCytomineCredentials == null ? other.availableCytomineCredentials != null : !this.availableCytomineCredentials.equals(other.availableCytomineCredentials));
    }

    public String toString() {
        return String.format("Preferences [availableCytomineCredentials=%s]", this.availableCytomineCredentials);
    }
}

