/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.core.image.annotation;

import icy.common.listener.ProgressListener;
import icy.painter.Anchor2D;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClientException;
import org.bioimageanalysis.icy.icytomine.core.model.Image;
import org.bioimageanalysis.icy.icytomine.core.model.Term;
import org.bioimageanalysis.icy.icytomine.core.model.UserAnnotation;
import org.bioimageanalysis.icy.icytomine.geom.WKTUtils;
import plugins.kernel.roi.roi2d.ROI2DEllipse;
import plugins.kernel.roi.roi2d.ROI2DLine;
import plugins.kernel.roi.roi2d.ROI2DPoint;
import plugins.kernel.roi.roi2d.ROI2DPolyLine;
import plugins.kernel.roi.roi2d.ROI2DPolygon;
import plugins.kernel.roi.roi2d.ROI2DRectangle;
import plugins.kernel.roi.roi2d.ROI2DShape;

public class RoiAnnotationSender {
    private Image imageInformation;
    private Sequence sequence;
    private boolean selectedRois;
    private Set<ProgressListener> progressListeners;
    private Map<String, Term> availableTerms;
    private Point2D sequenceLocationAtZeroResolution;
    private double sequencePixelScaleFactor;

    public RoiAnnotationSender(Image imageInformation, Sequence sequence, boolean selectedRois) {
        this.imageInformation = imageInformation;
        this.sequence = sequence;
        this.selectedRois = selectedRois;
        this.sequenceLocationAtZeroResolution = null;
        this.sequencePixelScaleFactor = Double.NaN;
        this.computeAvailableTerms();
        this.progressListeners = new HashSet<ProgressListener>();
    }

    private void computeAvailableTerms() {
        try {
            Set<Term> terms = this.imageInformation.getProject().getOntology().getTerms(false);
            this.availableTerms = terms.stream().collect(Collectors.toMap(t -> t.getName().orElse("Not specified").toLowerCase(), t -> t));
        }
        catch (CytomineClientException e) {
            this.availableTerms = new HashMap<String, Term>(0);
        }
    }

    public void addProgressListener(ProgressListener listener) {
        this.progressListeners.add(listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        this.progressListeners.remove(listener);
    }

    public List<UserAnnotation> send() throws InterruptedException, CytomineClientException {
        List<? extends ROI2D> rois = this.getROIs();
        int numRois = rois.size();
        int processedRois = 0;
        ArrayList<UserAnnotation> createdAnnotations = new ArrayList<UserAnnotation>(rois.size());
        for (ROI2D rOI2D : rois) {
            UserAnnotation createdAnnotation;
            this.checkThreadInterruption();
            try {
                try {
                    createdAnnotation = this.sendROI(rOI2D);
                }
                catch (UnsupportedOperationException e) {
                    this.notifyProgress(++processedRois, numRois);
                    continue;
                }
            }
            catch (Throwable throwable) {
                this.notifyProgress(++processedRois, numRois);
                throw throwable;
            }
            this.notifyProgress(++processedRois, numRois);
            createdAnnotations.add(createdAnnotation);
        }
        return createdAnnotations;
    }

    private List<? extends ROI2D> getROIs() {
        Set<String> ids = this.getExistingAnnotationIds();
        if (this.selectedRois) {
            return this.sequence.getSelectedROI2Ds().stream().filter(roi -> !ids.contains(this.getAnnotationId((ROI2D)roi))).collect(Collectors.toList());
        }
        return this.sequence.getROI2Ds().stream().filter(roi -> !ids.contains(this.getAnnotationId((ROI2D)roi))).collect(Collectors.toList());
    }

    private String getAnnotationId(ROI2D roi) {
        Long id;
        String idString = roi.getProperty("cytomineId");
        try {
            id = Long.parseUnsignedLong(idString);
        }
        catch (NumberFormatException e) {
            id = Long.MIN_VALUE;
        }
        return id.toString();
    }

    private Set<String> getExistingAnnotationIds() {
        try {
            return this.imageInformation.getAbstractAnnotations(false).keySet().stream().map(aId -> aId.toString()).collect(Collectors.toSet());
        }
        catch (CytomineClientException e) {
            e.printStackTrace();
            return new HashSet<String>();
        }
    }

    private void checkThreadInterruption() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    private UserAnnotation sendROI(ROI2D roi) throws CytomineClientException, UnsupportedOperationException {
        String description = this.getRoiWTKDesciption(roi);
        Set<Term> terms = this.getRoiTermsBasedOnName(roi);
        UserAnnotation annotation = this.createAnnotation(description, terms);
        return annotation;
    }

    private UserAnnotation createAnnotation(String description, Set<Term> terms) throws CytomineClientException {
        UserAnnotation annotation = this.imageInformation.getClient().addUserAnnotationWithTerms(this.imageInformation.getId(), description, terms.stream().map(term -> term.getId()).collect(Collectors.toList()));
        return annotation;
    }

    private String getRoiWTKDesciption(ROI2D roi) throws UnsupportedOperationException {
        if (roi instanceof ROI2DShape) {
            ROI2DShape shapeRoi = (ROI2DShape)roi;
            shapeRoi = this.adjustRoiToFullImage(shapeRoi);
            return WKTUtils.createFromROI2DShape(shapeRoi);
        }
        throw new UnsupportedOperationException("Unsupported roi type: " + roi.getClassName());
    }

    private ROI2DShape adjustRoiToFullImage(ROI2DShape roi) {
        List<Point2D> adjustedPoints = this.getAdjustedPoints(roi);
        if (roi instanceof ROI2DPoint) {
            return new ROI2DPoint(adjustedPoints.get(0));
        }
        if (roi instanceof ROI2DLine) {
            return new ROI2DLine(adjustedPoints.get(0), adjustedPoints.get(1));
        }
        if (roi instanceof ROI2DPolyLine) {
            return new ROI2DPolyLine(adjustedPoints);
        }
        if (roi instanceof ROI2DRectangle) {
            return new ROI2DRectangle(adjustedPoints.get(0), adjustedPoints.get(2));
        }
        if (roi instanceof ROI2DEllipse) {
            return new ROI2DEllipse(adjustedPoints.get(0), adjustedPoints.get(2));
        }
        if (roi instanceof ROI2DPolygon) {
            return new ROI2DPolygon(adjustedPoints);
        }
        throw new RuntimeException("unsupported shape roi: " + roi.getClassName());
    }

    private List<Point2D> getAdjustedPoints(ROI2DShape roi) {
        this.computeSequenceLocationAtZeroResolution();
        this.computeSequencePixelScaleFactor();
        List controlPoints = roi.getControlPoints();
        ArrayList<Point2D> adjustedPoints = new ArrayList<Point2D>(controlPoints.size());
        for (Anchor2D anchor : controlPoints) {
            Point2D.Double adjustedPoint = new Point2D.Double(this.sequenceLocationAtZeroResolution.getX() + anchor.getX() * this.sequencePixelScaleFactor, (double)this.imageInformation.getSizeY().orElse(1).intValue() - (this.sequenceLocationAtZeroResolution.getY() + anchor.getY() * this.sequencePixelScaleFactor));
            adjustedPoints.add(adjustedPoint);
        }
        return adjustedPoints;
    }

    private void computeSequenceLocationAtZeroResolution() {
        if (this.sequenceLocationAtZeroResolution == null) {
            this.sequenceLocationAtZeroResolution = new Point2D.Double(this.sequence.getPositionX() / this.imageInformation.getResolution().orElse(1.0), this.sequence.getPositionY() / this.imageInformation.getResolution().orElse(1.0));
        }
    }

    private void computeSequencePixelScaleFactor() {
        if (Double.isNaN(this.sequencePixelScaleFactor)) {
            Optional<Double> res = this.imageInformation.getResolution();
            this.sequencePixelScaleFactor = this.sequence.getPixelSizeX() / res.orElse(1.0);
        }
    }

    private Set<Term> getRoiTermsBasedOnName(ROI2D roi) {
        String[] termStrings;
        HashSet<Term> terms = new HashSet<Term>();
        String termString = roi.getName();
        String[] stringArray = termStrings = termString.split(",");
        int n = termStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String termName = stringArray[n2];
            if (this.isValidTerm(termName = termName.trim().toLowerCase())) {
                terms.add(this.availableTerms.get(termName));
            }
            ++n2;
        }
        return terms;
    }

    private boolean isValidTerm(String termName) {
        return this.availableTerms.containsKey(termName);
    }

    private void notifyProgress(int processedRois, int numRois) {
        this.progressListeners.forEach(l -> {
            boolean bl = l.notifyProgress((double)processedRois, (double)numRois);
        });
    }
}

