/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.core.model;

import be.cytomine.client.models.Annotation;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.simplify.TopologyPreservingSimplifier;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClient;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClientException;
import org.bioimageanalysis.icy.icytomine.core.model.AlgorithmAnnotation;
import org.bioimageanalysis.icy.icytomine.core.model.Entity;
import org.bioimageanalysis.icy.icytomine.core.model.Image;
import org.bioimageanalysis.icy.icytomine.core.model.Property;
import org.bioimageanalysis.icy.icytomine.core.model.ReviewedAnnotation;
import org.bioimageanalysis.icy.icytomine.core.model.Term;
import org.bioimageanalysis.icy.icytomine.core.model.User;
import org.bioimageanalysis.icy.icytomine.core.model.UserAnnotation;

public abstract class AbstractAnnotation
extends Entity {
    private Geometry latestSimplifiedGeometry;
    private int latestSimplifiedGeometryResolution;
    private Rectangle2D adjustedApproximativeBounds;
    private Rectangle2D approximativeBounds;
    private Rectangle2D bounds;
    private Rectangle2D adjustedBounds;
    private Geometry geometry;
    private String locationString;
    private List<Property> annotationProperties;
    private Map<Long, Set<Long>> termUsers;

    public AbstractAnnotation(CytomineClient client, Annotation model) {
        super(client, model);
    }

    public static List<AbstractAnnotation> getAnnotationsInImage(Image image) {
        ArrayList<AbstractAnnotation> foundAnnotations = new ArrayList<AbstractAnnotation>();
        foundAnnotations.addAll(UserAnnotation.getUserAnnotationsInImage(image).values());
        foundAnnotations.addAll(AlgorithmAnnotation.getAlgorithmAnnotationsInImage(image).values());
        foundAnnotations.addAll(ReviewedAnnotation.getReviewedAnnotationsInImage(image).values());
        return foundAnnotations;
    }

    public Annotation getInternalAnnotation() {
        return (Annotation)this.getModel();
    }

    public Optional<Long> getImageInstanceId() {
        return this.getLong("image");
    }

    public Optional<Long> getUserId() {
        return this.getLong("user");
    }

    public Geometry getSimplifiedGeometryForResolution(int resolution) throws CytomineClientException {
        double pixelTolerance = 1.0;
        if (resolution > 0) {
            int i = 0;
            while (i < resolution) {
                pixelTolerance *= 2.0;
                ++i;
            }
        } else if (resolution < 0) {
            int i = 0;
            while (i < -resolution) {
                pixelTolerance /= 2.0;
                ++i;
            }
        }
        if (this.geometry == null || this.latestSimplifiedGeometry == null || this.latestSimplifiedGeometryResolution != resolution) {
            this.latestSimplifiedGeometry = this.getSimplifiedGeometry(pixelTolerance);
            this.latestSimplifiedGeometryResolution = resolution;
        }
        return this.latestSimplifiedGeometry;
    }

    public Rectangle2D getYAdjustedApproximativeBounds() throws CytomineClientException {
        if (this.adjustedApproximativeBounds == null) {
            Rectangle2D approximativeBounds = this.getApproximativeBounds();
            this.adjustedApproximativeBounds = new Rectangle2D.Double(approximativeBounds.getMinX(), (double)this.getImage().getSizeY().get().intValue() - approximativeBounds.getMaxY(), approximativeBounds.getWidth(), approximativeBounds.getHeight());
            if (this.adjustedApproximativeBounds.isEmpty()) {
                this.adjustedApproximativeBounds = new Rectangle2D.Double(this.adjustedApproximativeBounds.getX() - Double.MIN_VALUE, this.adjustedApproximativeBounds.getY() - Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE);
            }
        }
        return this.adjustedApproximativeBounds;
    }

    public Rectangle2D getApproximativeBounds() throws CytomineClientException {
        if (this.approximativeBounds == null) {
            Geometry simplifiedGeometry = this.getSimplifiedGeometry(10.0);
            Envelope envelope = simplifiedGeometry.getEnvelopeInternal();
            this.approximativeBounds = new Rectangle2D.Double(envelope.getMinX(), envelope.getMinY(), envelope.getWidth(), envelope.getHeight());
        }
        return this.approximativeBounds;
    }

    private Geometry getSimplifiedGeometry(double pixelTolerance) throws CytomineClientException {
        pixelTolerance = pixelTolerance > 0.0 ? pixelTolerance : 0.0;
        Geometry baseGeometry = this.getGeometryAtZeroResolution(false);
        if (baseGeometry == null) {
            throw new CytomineClientException(String.format("Null base geometry (annotation id=%d)", this.getId()));
        }
        TopologyPreservingSimplifier simplifier = new TopologyPreservingSimplifier(baseGeometry);
        simplifier.setDistanceTolerance(pixelTolerance);
        return simplifier.getResultGeometry();
    }

    public Rectangle2D getBounds() {
        if (this.bounds == null) {
            Envelope envelope = this.getGeometryAtZeroResolution(false).getEnvelopeInternal();
            this.bounds = new Rectangle2D.Double(envelope.getMinX(), envelope.getMinY(), envelope.getWidth(), envelope.getHeight());
            if (this.bounds.isEmpty()) {
                this.bounds = new Rectangle2D.Double(this.bounds.getX() - Double.MIN_VALUE, this.bounds.getY() - Double.MIN_VALUE, 9.9E-324, 9.9E-324);
            }
        }
        return this.bounds;
    }

    public Rectangle2D getYAdjustedBounds() {
        if (this.adjustedBounds == null) {
            Envelope envelope = this.getGeometryAtZeroResolution(false).getEnvelopeInternal();
            this.adjustedBounds = new Rectangle2D.Double(envelope.getMinX(), (double)this.getImage().getSizeY().get().intValue() - envelope.getMaxY(), envelope.getWidth(), envelope.getHeight());
            if (this.adjustedBounds.isEmpty()) {
                this.adjustedBounds = new Rectangle2D.Double(this.adjustedBounds.getX() - Double.MIN_VALUE, this.adjustedBounds.getY() - Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE);
            }
        }
        return this.adjustedBounds;
    }

    public Geometry getGeometryAtZeroResolution(boolean recompute) throws CytomineClientException {
        if (this.geometry == null || recompute) {
            this.retrieveGeometry();
        }
        return this.geometry;
    }

    private void retrieveGeometry() throws CytomineClientException {
        this.geometry = null;
        Optional<String> location = this.getLocation();
        if (location.isPresent()) {
            WKTReader reader = new WKTReader();
            try {
                this.geometry = reader.read(location.get());
            }
            catch (ParseException e) {
                throw new CytomineClientException(String.format("Couldn't create geometry for annotation %d", this.getId()), e);
            }
        }
    }

    public Optional<String> getLocation() throws CytomineClientException {
        if (this.locationString == null) {
            Optional<String> locationString = this.getStr("location");
            this.locationString = locationString.isPresent() ? locationString.get() : (String)this.getClient().getAnnotationLocation(this.getId()).orElse(null);
        }
        return Optional.ofNullable(this.locationString);
    }

    public User getUser() throws CytomineClientException {
        return this.getClient().getUser(this.getUserId().get());
    }

    public Image getImage() throws CytomineClientException {
        return this.getClient().getImageInstance(this.getImageInstanceId().get());
    }

    public List<Property> getProperties(boolean recompute) throws CytomineClientException {
        if (this.annotationProperties == null || recompute) {
            this.annotationProperties = this.getClient().getAbstractAnnotationProperties(this);
        }
        return this.annotationProperties;
    }

    public Color getColor() {
        Set<Term> terms = this.getAssociatedTermsByCurrentUser();
        if (terms.isEmpty()) {
            terms = this.getAssociatedTerms();
        }
        Color color = !terms.isEmpty() ? terms.iterator().next().getColor() : Term.DEFAULT_TERM_COLOR;
        return color;
    }

    public Set<Term> getAssociatedTermsByCurrentUser() throws CytomineClientException {
        Long userId = this.getClient().getCurrentUser().getId();
        return this.getAssociatedTermsByUser(userId);
    }

    public Set<Term> getAssociatedTermsByUser(long userId) throws CytomineClientException {
        return this.getTermUsers().entrySet().stream().filter(entry -> ((Set)entry.getValue()).contains(userId)).map(e -> (Long)e.getKey()).distinct().map(id -> this.getClient().getTerm((long)id)).collect(Collectors.toSet());
    }

    public Set<Term> getAssociatedTerms() throws CytomineClientException {
        return this.getTermUsers().keySet().stream().map(id -> this.getClient().getTerm((long)id)).collect(Collectors.toSet());
    }

    public Map<Long, Set<Long>> getTermUsers() throws CytomineClientException {
        if (this.termUsers == null) {
            try {
                this.termUsers = this.getClient().getAnnotationUsersByTerm(this);
            }
            catch (Exception e) {
                throw new CytomineClientException(String.format("Could not create term users map for annotation %d", this.getId()), e);
            }
        }
        return this.termUsers;
    }

    public void associateTerms(Map<Term, Boolean> termSelection) throws CytomineClientException {
        this.getClient().associateTermsToAnnotation(this, termSelection);
        this.termUsers = null;
        this.getInternalAnnotation().getAttr().remove((Object)"userByTerm");
        this.getTermUsers();
    }

    @Override
    public String toString() {
        return String.format("Annotation (%s). Id: %s", this.getClass().getTypeName(), String.valueOf(this.getId()));
    }
}

