/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.explorer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.SystemColor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.EtchedBorder;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClient;
import org.bioimageanalysis.icy.icytomine.ui.core.explorer.ExplorerPanelController;
import org.bioimageanalysis.icy.icytomine.ui.core.explorer.ImageDetailsPanel;
import org.bioimageanalysis.icy.icytomine.ui.core.explorer.ImagePanel;
import org.bioimageanalysis.icy.icytomine.ui.core.explorer.ProjectDetailsPanel;
import org.bioimageanalysis.icy.icytomine.ui.core.explorer.ProjectPanel;

public class ExplorerPanel
extends JPanel {
    private static final long serialVersionUID = 2595438652951822963L;
    private ProjectPanel projectPanel;
    private ImagePanel imagePanel;
    private ProjectDetailsPanel projectDetailsPanel;
    private ImageDetailsPanel imageDetailsPanel;
    private JSplitPane navigationPane;
    private JLabel hostAddressLabel;
    private JPanel mainPanel;
    private ExplorerPanelController controller;

    public ExplorerPanel() {
        this.setView();
        this.setController();
    }

    private void setView() {
        this.setBorder(null);
        this.setBackground(SystemColor.control);
        this.setMinimumSize(new Dimension(500, 300));
        this.setPreferredSize(new Dimension(730, 410));
        this.setGridBagLayout();
        this.setMainPanel();
    }

    private void setGridBagLayout() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[1];
        gridBagLayout.rowHeights = new int[2];
        gridBagLayout.columnWeights = new double[]{1.0};
        gridBagLayout.rowWeights = new double[]{0.0, 1.0};
        this.setLayout(gridBagLayout);
    }

    private void setMainPanel() {
        this.createMainPanel();
        this.setHostComponents();
        this.setNavigationPane();
        GridBagConstraints mainPanelConstraints = new GridBagConstraints();
        mainPanelConstraints.fill = 1;
        mainPanelConstraints.gridx = 0;
        mainPanelConstraints.gridy = 1;
        this.add((Component)this.mainPanel, mainPanelConstraints);
    }

    private void createMainPanel() {
        this.mainPanel = new JPanel();
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[2];
        gbl_panel.rowHeights = new int[2];
        gbl_panel.columnWeights = new double[]{0.0, 1.0};
        gbl_panel.rowWeights = new double[]{0.0, 1.0};
        this.mainPanel.setLayout(gbl_panel);
    }

    private void setHostComponents() {
        JLabel hostTitleLabel = new JLabel("Connected as ");
        hostTitleLabel.setFont(new Font("Tahoma", 1, 11));
        hostTitleLabel.setHorizontalAlignment(4);
        hostTitleLabel.setAlignmentX(1.0f);
        hostTitleLabel.setAlignmentY(0.5f);
        GridBagConstraints hostTitleLabelConstraints = new GridBagConstraints();
        hostTitleLabelConstraints.fill = 1;
        hostTitleLabelConstraints.anchor = 13;
        hostTitleLabelConstraints.gridx = 0;
        hostTitleLabelConstraints.gridy = 0;
        this.mainPanel.add((Component)hostTitleLabel, hostTitleLabelConstraints);
        this.hostAddressLabel = new JLabel("No server specified");
        GridBagConstraints hostAddressLabelConstraints = new GridBagConstraints();
        hostAddressLabelConstraints.fill = 1;
        hostAddressLabelConstraints.anchor = 18;
        hostAddressLabelConstraints.gridx = 1;
        hostAddressLabelConstraints.gridy = 0;
        this.mainPanel.add((Component)this.hostAddressLabel, hostAddressLabelConstraints);
    }

    private void setNavigationPane() {
        this.navigationPane = new JSplitPane();
        this.navigationPane.setDoubleBuffered(true);
        this.navigationPane.setContinuousLayout(true);
        this.navigationPane.setResizeWeight(0.66);
        this.navigationPane.setMinimumSize(new Dimension(730, 300));
        this.navigationPane.setPreferredSize(new Dimension(720, 390));
        this.navigationPane.setBorder(new EtchedBorder(1, null, null));
        this.setNavigationPaneDivisions();
        GridBagConstraints navigationPaneConstraints = new GridBagConstraints();
        navigationPaneConstraints.anchor = 11;
        navigationPaneConstraints.fill = 1;
        navigationPaneConstraints.gridwidth = 2;
        navigationPaneConstraints.gridx = 0;
        navigationPaneConstraints.gridy = 1;
        this.mainPanel.add((Component)this.navigationPane, navigationPaneConstraints);
    }

    private void setNavigationPaneDivisions() {
        this.navigationPane.setDividerSize(2);
        JSplitPane projectImageSplitPane = new JSplitPane();
        projectImageSplitPane.setDoubleBuffered(true);
        projectImageSplitPane.setContinuousLayout(true);
        projectImageSplitPane.setResizeWeight(0.5);
        projectImageSplitPane.setDividerSize(2);
        projectImageSplitPane.setBorder(null);
        this.projectPanel = new ProjectPanel();
        projectImageSplitPane.setLeftComponent(this.projectPanel);
        this.imagePanel = new ImagePanel();
        projectImageSplitPane.setRightComponent(this.imagePanel);
        this.navigationPane.setLeftComponent(projectImageSplitPane);
        this.projectDetailsPanel = new ProjectDetailsPanel();
        this.imageDetailsPanel = new ImageDetailsPanel();
        this.navigationPane.setRightComponent(this.projectDetailsPanel);
    }

    private void setController() {
        this.controller = new ExplorerPanelController(this);
    }

    public JLabel getHostAddressLabel() {
        return this.hostAddressLabel;
    }

    public ProjectPanel getProjectPanel() {
        return this.projectPanel;
    }

    public ImagePanel getImagePanel() {
        return this.imagePanel;
    }

    public ProjectDetailsPanel getProjectDetailsPanel() {
        return this.projectDetailsPanel;
    }

    public ImageDetailsPanel getImageDetailsPanel() {
        return this.imageDetailsPanel;
    }

    public void showNoDetails() {
        this.navigationPane.setRightComponent(null);
    }

    public void showProjectDetails() {
        this.navigationPane.setRightComponent(this.projectDetailsPanel);
        this.projectDetailsPanel.updateLayout();
    }

    public void showImageDetails() {
        this.navigationPane.setRightComponent(this.imageDetailsPanel);
        this.imageDetailsPanel.updateLayout();
    }

    public void addOpenViewerListener(ImagePanel.ImageSelectionListener listener) {
        this.controller.addImageViewerRequestListener(listener);
    }

    public void setClient(CytomineClient client) {
        this.controller.setClient(client);
    }
}

