/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.login;

import icy.gui.dialog.MessageDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class EditHostDialog
extends JDialog {
    private String originalHostName;
    private Container contentPane;
    private JTextField hostTextField;
    private JButton editHostButton;
    private JButton cancelButton;
    private ActionListener editHostButtonListener;

    public EditHostDialog(Frame owner, String hostName) {
        super(owner, "Edit Host - Icytomine", true);
        this.originalHostName = hostName;
        this.contentPane = this.getContentPane();
        this.setPreferredSize(new Dimension(275, 140));
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setResizable(false);
        this.adjustLayout();
        this.addHostLabel();
        this.addHostTextField();
        this.addEditHostButton();
        this.addCancelButton();
        this.setCancelButtonHandler();
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    private void adjustLayout() {
        this.contentPane.setPreferredSize(new Dimension(300, 210));
        GridBagLayout contentPanelLayout = new GridBagLayout();
        contentPanelLayout.columnWidths = new int[]{1, 1};
        contentPanelLayout.rowHeights = new int[3];
        contentPanelLayout.columnWeights = new double[]{0.0, 0.0};
        contentPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.0};
        this.contentPane.setLayout(contentPanelLayout);
    }

    private void addHostLabel() {
        JLabel hostLabel = new JLabel("Specify the host address");
        GridBagConstraints hostLabelConstraints = new GridBagConstraints();
        hostLabelConstraints.gridwidth = 2;
        hostLabelConstraints.insets = new Insets(10, 0, 5, 0);
        hostLabelConstraints.gridx = 0;
        hostLabelConstraints.gridy = 0;
        this.contentPane.add((Component)hostLabel, hostLabelConstraints);
    }

    private void addHostTextField() {
        this.hostTextField = new JTextField();
        this.hostTextField.setColumns(10);
        this.hostTextField.setText(this.originalHostName);
        GridBagConstraints hostTextFieldConstraints = new GridBagConstraints();
        hostTextFieldConstraints.gridwidth = 2;
        hostTextFieldConstraints.insets = new Insets(0, 0, 5, 0);
        hostTextFieldConstraints.fill = 2;
        hostTextFieldConstraints.gridx = 0;
        hostTextFieldConstraints.gridy = 1;
        this.contentPane.add((Component)this.hostTextField, hostTextFieldConstraints);
    }

    private void addEditHostButton() {
        this.editHostButton = new JButton("Update host");
        this.editHostButton.setMinimumSize(new Dimension(95, 23));
        this.editHostButton.setMaximumSize(new Dimension(95, 23));
        this.editHostButton.setPreferredSize(new Dimension(95, 23));
        this.editHostButton.setAlignmentX(0.5f);
        GridBagConstraints editHostButtonConstraints = new GridBagConstraints();
        editHostButtonConstraints.insets = new Insets(0, 0, 0, 5);
        editHostButtonConstraints.gridx = 0;
        editHostButtonConstraints.gridy = 2;
        this.contentPane.add((Component)this.editHostButton, editHostButtonConstraints);
    }

    private void addCancelButton() {
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setMinimumSize(new Dimension(95, 23));
        this.cancelButton.setMaximumSize(new Dimension(95, 23));
        this.cancelButton.setPreferredSize(new Dimension(95, 23));
        this.cancelButton.setAlignmentX(0.5f);
        GridBagConstraints cancelButtonConstraints = new GridBagConstraints();
        cancelButtonConstraints.gridx = 1;
        cancelButtonConstraints.gridy = 2;
        this.contentPane.add((Component)this.cancelButton, cancelButtonConstraints);
    }

    public void setHostEditionListener(HostEditionListener listener) {
        if (this.editHostButtonListener == null) {
            this.editHostButtonListener = e -> {
                String hostName = this.hostTextField.getText();
                try {
                    listener.requestEdition(this.originalHostName, hostName);
                    this.setVisible(false);
                    this.dispose();
                }
                catch (RuntimeException ex) {
                    MessageDialog.showDialog((String)"Error updating host", (String)ex.getMessage(), (int)0);
                }
            };
        }
        this.editHostButton.addActionListener(this.editHostButtonListener);
    }

    public void unsetHostEditionListener() {
        if (this.editHostButtonListener != null) {
            this.editHostButton.removeActionListener(this.editHostButtonListener);
        }
    }

    private void setCancelButtonHandler() {
        this.cancelButton.addActionListener(e -> {
            this.setVisible(false);
            this.dispose();
        });
    }

    public static interface HostEditionListener {
        public void requestEdition(String var1, String var2) throws RuntimeException;
    }
}

