/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.viewer;

import icy.gui.frame.IcyFrame;
import icy.gui.frame.IcyFrameAdapter;
import icy.gui.frame.IcyFrameEvent;
import icy.gui.frame.IcyFrameListener;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.bioimageanalysis.icy.icytomine.core.model.Image;
import org.bioimageanalysis.icy.icytomine.core.view.CachedAbstractAnnotationView;
import org.bioimageanalysis.icy.icytomine.core.view.CachedImageView;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.ViewerPanel;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.ViewerPanelController;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.controller.view.provider.CachedViewProvider;
import org.pushingpixels.substance.api.skin.SubstanceOfficeBlack2007LookAndFeel;

public class ViewerFrame
extends IcyFrame {
    private ViewerPanel viewerComponentContainer;
    private ViewerPanelController viewerController;
    private JPanel loadingPanel;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel((LookAndFeel)new SubstanceOfficeBlack2007LookAndFeel());
                    ViewerFrame frame = new ViewerFrame();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public ViewerFrame() {
        super("Viewer - Icytomine", true, true, true, true);
        this.setDefaultCloseOperation(2);
        this.addToDesktopPane();
        this.center();
        this.setLoadingPane();
    }

    private void setLoadingPane() {
        this.loadingPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[1];
        gridBagLayout.rowHeights = new int[1];
        gridBagLayout.columnWeights = new double[]{1.0};
        gridBagLayout.rowWeights = new double[]{1.0};
        this.loadingPanel.setLayout(gridBagLayout);
        JLabel loadingLabel = new JLabel("Loading viewer...");
        loadingLabel.setHorizontalAlignment(0);
        GridBagConstraints loadingLabelConstraints = new GridBagConstraints();
        loadingLabelConstraints.anchor = 11;
        loadingLabelConstraints.fill = 1;
        loadingLabelConstraints.gridx = 0;
        loadingLabelConstraints.gridy = 0;
        this.loadingPanel.add((Component)loadingLabel, loadingLabelConstraints);
        this.setContentPane(this.loadingPanel);
    }

    public void setImageInstance(Image imageInstance) throws RuntimeException {
        try {
            CachedViewProvider viewProvider = new CachedViewProvider(new CachedImageView(imageInstance), new CachedAbstractAnnotationView(imageInstance));
            this.setTitle(String.valueOf(imageInstance.getName().orElse(String.valueOf(imageInstance.getId()))) + " - Icytomine");
            SwingUtilities.invokeLater(() -> {
                this.viewerComponentContainer = new ViewerPanel(viewProvider);
                this.viewerController = new ViewerPanelController(this.viewerComponentContainer);
                this.addFrameListener((IcyFrameListener)new IcyFrameAdapter(){

                    public void icyFrameClosed(IcyFrameEvent e) {
                        System.out.println("frame closed");
                        ViewerFrame.this.viewerController.stopViewer();
                    }
                });
                this.setContentPane(this.viewerComponentContainer);
                this.setSize(this.viewerComponentContainer.getPreferredSize());
                this.setMinimumSize(this.viewerComponentContainer.getMinimumSize());
                this.viewerController.startViewer();
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading image: " + e.getMessage(), e);
        }
    }
}

