/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.viewer;

import icy.gui.frame.IcyFrame;
import icy.gui.frame.IcyFrameAdapter;
import icy.gui.frame.IcyFrameEvent;
import icy.gui.frame.IcyFrameListener;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.JPanel;
import org.bioimageanalysis.icy.icytomine.core.model.AbstractAnnotation;
import org.bioimageanalysis.icy.icytomine.core.model.AlgorithmAnnotation;
import org.bioimageanalysis.icy.icytomine.core.model.Entity;
import org.bioimageanalysis.icy.icytomine.core.model.Image;
import org.bioimageanalysis.icy.icytomine.core.model.User;
import org.bioimageanalysis.icy.icytomine.core.model.UserAnnotation;
import org.bioimageanalysis.icy.icytomine.core.model.UserJob;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.ViewerPanel;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.abstractannotations.AbstractAnnotationManagerPanel;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.abstractannotations.AbstractAnnotationTable;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.abstractannotations.layers.AnnotationLayer;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.cytomine2Icy.CytomineToIcyPanel;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.icy2Cytomine.file.IcyFileToCytominePanel;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.icy2Cytomine.folder.IcyFolderToCytominePanel;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.icy2Cytomine.sequence.IcySequenceToCytominePanel;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.controller.view.ViewController;

public class ViewerPanelController {
    private ViewerPanel viewerContainer;
    private ViewController viewController;
    private IcyFrame annotationsFrame;
    private IcyFrame cytomineToIcyFrame;
    private IcyFrame icySequenceToCytomineFrame;
    private IcyFrame icyFileToCytomineFrame;
    private IcyFrame icyFolderToCytomineFrame;

    public ViewerPanelController(ViewerPanel viewerContainer) {
        this.viewerContainer = viewerContainer;
    }

    public void startViewer() {
        this.viewController = this.viewerContainer.getViewCanvasPanel().getViewController();
        this.setViewControllerListeners();
        this.setViewerContainerListeners();
        this.viewerContainer.setZoomLimit(this.getZoomLevel(0.0));
        Image targetImage = this.viewController.getImageInformation();
        this.viewController.adjustImageZoomToView();
        HashSet<UserAnnotation> initialTargetAnnotations = new HashSet<UserAnnotation>(targetImage.getUserAnnotationsWithGeometry(targetImage.getClient().getCurrentUser(), true).values());
        this.viewController.setTargetAnnotations(initialTargetAnnotations);
        this.viewController.setVisibileAnnotations(initialTargetAnnotations);
    }

    private void setViewControllerListeners() {
        this.viewController.addCursorPositionListener(newPosition -> this.viewerContainer.setCursorPosition(newPosition, this.getPositionInMicrons(newPosition)));
        this.viewController.addResolutionListener(newResolution -> this.viewerContainer.setZoomLevel(this.getZoomLevel(newResolution)));
        this.viewController.addAnnotationSelectionListener(this.getAnnotationSelectionHandler());
    }

    private Point2D getPositionInMicrons(Point2D position) {
        double pixelSize = this.viewController.getImageInformation().getResolution().orElse(1.0);
        return new Point2D.Double(position.getX() * pixelSize, position.getY() * pixelSize);
    }

    private double getZoomLevel(double resolutionLevel) {
        int intMagnification = this.viewController.getImageInformation().getMagnification().orElse(1);
        double magnification = intMagnification;
        return magnification /= Math.pow(2.0, resolutionLevel);
    }

    private AbstractAnnotationTable.AnnotationSelectionListener getAnnotationSelectionHandler() {
        return selectedAnnotations -> {
            if (this.annotationsFrame != null) {
                ((AbstractAnnotationManagerPanel)this.annotationsFrame.getContentPane()).setSelectedAnnotations(selectedAnnotations);
            }
        };
    }

    private void setViewerContainerListeners() {
        this.viewerContainer.addZoomInListener(e -> this.viewController.zoomIn());
        this.viewerContainer.addZoomOutListener(e -> this.viewController.zoomOut());
        this.viewerContainer.addZoomLevelSelectedListener(zoomLevel -> this.viewController.setResolution(this.getResolutionLevel(zoomLevel)));
        this.viewerContainer.addAnnotationFilterMenuListener(this.getAnnotationMenuHandler());
        this.viewerContainer.addAnnotationRefreshMenuListener(this.getAnnotationRefreshMenuHandler());
        this.viewerContainer.addCytomineToIcyMenuListener(this.getCytomineToIcyMenuHandler());
        this.viewerContainer.addIcySequenceToCytomineMenuListener(this.getIcySequenceToCytomineMenuHandler());
        this.viewerContainer.addIcyFileToCytomineMenuListener(this.getIcyFileToCytomineMenuHandler());
        this.viewerContainer.addIcyFolderToCytomineMenuListener(this.getIcyFolderToCytomineMenuHandler());
    }

    private double getResolutionLevel(double zoomLevel) {
        int intMagnification = this.viewController.getImageInformation().getMagnification().orElse(1);
        double magnification = intMagnification;
        return Math.log(magnification / zoomLevel) / Math.log(2.0);
    }

    private ActionListener getAnnotationMenuHandler() {
        return e -> {
            AbstractAnnotationManagerPanel annotationsPanel;
            System.out.println("Opening annotations menu...");
            if (this.annotationsFrame != null) {
                annotationsPanel = (AbstractAnnotationManagerPanel)this.annotationsFrame.getContentPane();
                this.annotationsFrame.close();
                annotationsPanel.removeAnnotationLayersVisibilityListener(this::onLayersVisibilityChanged);
                annotationsPanel.removeAnnotationsVisibilityListener(this::onAnnotationVisibilityChanged);
                annotationsPanel.removeAnnotationSelectionListener(this::onAnnotationSelectionChanged);
                annotationsPanel.removeAnnotationDoubleClickListener(this::onAnnotationFocusRequested);
                annotationsPanel.removeAnnotationTermSelectionCommitListener(this::onAnnotationTermCommited);
                annotationsPanel.removeAnnotationDeletionListener(this::onAnnotationDeleted);
            }
            annotationsPanel = new AbstractAnnotationManagerPanel();
            annotationsPanel.addAnnotationLayersVisibilityListener(this::onLayersVisibilityChanged);
            annotationsPanel.addAnnotationsVisibilityListener(this::onAnnotationVisibilityChanged);
            annotationsPanel.addAnnotationSelectionListener(this::onAnnotationSelectionChanged);
            annotationsPanel.addAnnotationDoubleClickListener(this::onAnnotationFocusRequested);
            annotationsPanel.addAnnotationTermSelectionCommitListener(this::onAnnotationTermCommited);
            annotationsPanel.addAnnotationDeletionListener(this::onAnnotationDeleted);
            Image targetImage = this.viewController.getImageInformation();
            annotationsPanel.setTargetImage(targetImage);
            annotationsPanel.setLayers(this.createAnnotationLayers(targetImage));
            Set<AbstractAnnotation> visibleAnnotations = this.viewController.getVisibleAnnotations();
            Set<AbstractAnnotation> selectedAnnotations = this.viewController.getSelectedAnnotations();
            Map<AbstractAnnotation, Boolean> targetAnnotationVisibilities = this.viewController.getTargetAnnotations().stream().collect(Collectors.toMap(Function.identity(), a -> visibleAnnotations.contains(a)));
            annotationsPanel.setTargetAnnotations(targetAnnotationVisibilities);
            this.annotationsFrame = ViewerPanelController.createIcyDialog("Annotations - Icytomine", annotationsPanel, true);
            this.annotationsFrame.setSize(new Dimension(400, 400));
            annotationsPanel.setSelectedAnnotations(selectedAnnotations);
            this.annotationsFrame.setVisible(true);
        };
    }

    private List<AnnotationLayer> createAnnotationLayers(Image targetImage) {
        Map<User, List<UserAnnotation>> userLayers = targetImage.getClient().getImageUserAnnotations(targetImage).values().stream().collect(Collectors.groupingBy(a -> a.getUser()));
        Map<UserJob, List<AlgorithmAnnotation>> algoLayers = targetImage.getClient().getImageAlgorithmAnnotations(targetImage).values().stream().collect(Collectors.groupingBy(a -> a.getUserJob()));
        ArrayList<AnnotationLayer> layers = new ArrayList<AnnotationLayer>(userLayers.size() + algoLayers.size());
        userLayers.entrySet().stream().forEach(e -> {
            boolean bl = layers.add(new AnnotationLayer(((User)e.getKey()).getName().orElse("Unknown"), AnnotationLayer.LayerType.USER, (Entity)e.getKey(), new HashSet<AbstractAnnotation>((Collection)e.getValue())));
        });
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy h:mm:ss a");
        algoLayers.entrySet().stream().forEach(e -> {
            boolean bl = layers.add(new AnnotationLayer(String.valueOf(((UserJob)e.getKey()).getName().orElse("Unknown")) + " - " + formatter.format(((UserJob)e.getKey()).getDate().get()), AnnotationLayer.LayerType.ALGORITHM, (Entity)e.getKey(), new HashSet<AbstractAnnotation>((Collection)e.getValue())));
        });
        return layers;
    }

    private void onLayersVisibilityChanged(Map<AnnotationLayer, Boolean> layersState) {
        Set visibleLayers = layersState.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toSet());
        Set<User> users = visibleLayers.stream().filter(l -> l.getLayerType() == AnnotationLayer.LayerType.USER).map(l -> (User)l.getLayerTypeEntity()).collect(Collectors.toSet());
        Set<UserJob> userJobs = visibleLayers.stream().filter(l -> l.getLayerType() == AnnotationLayer.LayerType.ALGORITHM).map(l -> (UserJob)l.getLayerTypeEntity()).collect(Collectors.toSet());
        Map<Long, UserAnnotation> visibleUserAnnotations = this.viewController.getImageInformation().getUserAnnotationsWithGeometry(users);
        Map<Long, AlgorithmAnnotation> visibleAlgoAnnotations = this.viewController.getImageInformation().getAlgorithmAnnotationsWithGeometry(userJobs);
        HashSet<AbstractAnnotation> visibleAnnotations = new HashSet<AbstractAnnotation>(visibleUserAnnotations.size() + visibleAlgoAnnotations.size());
        visibleAnnotations.addAll(visibleUserAnnotations.values());
        visibleAnnotations.addAll(visibleAlgoAnnotations.values());
        Set nonVisibleAnnotations = layersState.entrySet().stream().filter(e -> (Boolean)e.getValue() == false).map(Map.Entry::getKey).reduce(new HashSet(), (annotations, layer) -> {
            annotations.addAll(layer.getIncludedAnnotations());
            return annotations;
        }, (a1, a2) -> {
            a1.addAll(a2);
            return a1;
        });
        this.viewController.addTargetAbstractAnnotations(visibleAnnotations);
        this.viewController.removeTargetAbstractAnnotations(nonVisibleAnnotations);
        this.viewController.addVisibileAbstractAnnotations(visibleAnnotations);
        Map<AbstractAnnotation, Boolean> annotationVisibilities = visibleAnnotations.stream().collect(Collectors.toMap(Function.identity(), a -> true));
        ((AbstractAnnotationManagerPanel)this.annotationsFrame.getContentPane()).addTargetAnnotations(annotationVisibilities);
        ((AbstractAnnotationManagerPanel)this.annotationsFrame.getContentPane()).removeTargetAnnotations(nonVisibleAnnotations);
    }

    private void onAnnotationVisibilityChanged(Set<AbstractAnnotation> newVisibleAnnotations) {
        this.viewController.setVisibileAnnotations(newVisibleAnnotations);
    }

    private void onAnnotationSelectionChanged(Set<AbstractAnnotation> selectedAnnotations) {
        this.viewController.setSelectedAnnotations(selectedAnnotations);
    }

    private void onAnnotationFocusRequested(AbstractAnnotation a) {
        this.viewController.focusOnAnnotation(a);
    }

    private void onAnnotationTermCommited(Set<AbstractAnnotation> annotations) {
        HashSet<AbstractAnnotation> annotationsToSelect = new HashSet<AbstractAnnotation>(this.viewController.getSelectedAnnotations());
        annotationsToSelect.addAll(annotations);
        this.viewController.getViewProvider().addTargetAbstractAnnotations(annotations);
        Map<AbstractAnnotation, Boolean> visibilities = annotations.stream().collect(Collectors.toMap(Function.identity(), a -> true));
        ((AbstractAnnotationManagerPanel)this.annotationsFrame.getContentPane()).addTargetAnnotations(visibilities);
        ((AbstractAnnotationManagerPanel)this.annotationsFrame.getContentPane()).setSelectedAnnotations(annotationsToSelect);
    }

    private void onAnnotationDeleted(Set<AbstractAnnotation> annotations) {
        this.viewController.removeTargetAbstractAnnotations(annotations);
        ((AbstractAnnotationManagerPanel)this.annotationsFrame.getContentPane()).removeTargetAnnotations(annotations);
    }

    private ActionListener getAnnotationRefreshMenuHandler() {
        return event -> this.viewController.refreshView();
    }

    private static IcyFrame createIcyDialog(String title, JPanel contentPane, boolean resizable) {
        IcyFrame frame = new IcyFrame(title, resizable, true, false, false);
        frame.setDefaultCloseOperation(2);
        frame.setMinimumSize(new Dimension(10, 10));
        frame.setContentPane((Container)contentPane);
        frame.setSize(contentPane.getPreferredSize());
        frame.addToDesktopPane();
        frame.center();
        frame.setAlwaysOnTop(true);
        return frame;
    }

    private ActionListener getCytomineToIcyMenuHandler() {
        return e -> {
            System.out.println("Opening cytomine -> icy dialog...");
            if (this.cytomineToIcyFrame != null) {
                this.cytomineToIcyFrame.close();
            }
            final CytomineToIcyPanel contentPane = new CytomineToIcyPanel(this.viewController);
            this.cytomineToIcyFrame = ViewerPanelController.createIcyDialog("Download view from Cytomine - Icytomine", contentPane, false);
            contentPane.addCloseListener(a -> this.cytomineToIcyFrame.close());
            this.cytomineToIcyFrame.addFrameListener((IcyFrameListener)new IcyFrameAdapter(){

                public void icyFrameClosed(IcyFrameEvent e) {
                    contentPane.getController().close();
                }
            });
            this.cytomineToIcyFrame.setVisible(true);
        };
    }

    private ActionListener getIcySequenceToCytomineMenuHandler() {
        return e -> {
            System.out.println("Opening icy sequence -> cytomine dialog...");
            if (this.icySequenceToCytomineFrame != null) {
                this.icySequenceToCytomineFrame.close();
            }
            final IcySequenceToCytominePanel contentPane = new IcySequenceToCytominePanel(this.viewController);
            this.icySequenceToCytomineFrame = ViewerPanelController.createIcyDialog("Send Sequence ROIs to Cytomine - Icytomine", contentPane, false);
            contentPane.addCloseListener(a -> this.icySequenceToCytomineFrame.close());
            this.icySequenceToCytomineFrame.addFrameListener((IcyFrameListener)new IcyFrameAdapter(){

                public void icyFrameClosed(IcyFrameEvent e) {
                    contentPane.getController().close();
                }
            });
            this.icySequenceToCytomineFrame.setVisible(true);
        };
    }

    private ActionListener getIcyFileToCytomineMenuHandler() {
        return e -> {
            System.out.println("Opening icy file -> cytomine dialog...");
            if (this.icyFileToCytomineFrame != null) {
                this.icyFileToCytomineFrame.close();
            }
            final IcyFileToCytominePanel contentPane = new IcyFileToCytominePanel(this.viewController);
            this.icyFileToCytomineFrame = ViewerPanelController.createIcyDialog("Send File ROIs to Cytomine - Icytomine", contentPane, false);
            contentPane.getController().addCloseListener(a -> this.icyFileToCytomineFrame.close());
            this.icyFileToCytomineFrame.addFrameListener((IcyFrameListener)new IcyFrameAdapter(){

                public void icyFrameClosed(IcyFrameEvent e) {
                    contentPane.getController().close();
                }
            });
            this.icyFileToCytomineFrame.setVisible(true);
        };
    }

    private ActionListener getIcyFolderToCytomineMenuHandler() {
        return e -> {
            System.out.println("Opening icy folder -> cytomine dialog...");
            if (this.icyFolderToCytomineFrame != null) {
                this.icyFolderToCytomineFrame.close();
            }
            final IcyFolderToCytominePanel contentPane = new IcyFolderToCytominePanel(this.viewController);
            this.icyFolderToCytomineFrame = ViewerPanelController.createIcyDialog("Send Folder ROIs to Cytomine - Icytomine", contentPane, false);
            contentPane.getController().addCloseListener(a -> this.icyFolderToCytomineFrame.close());
            this.icyFolderToCytomineFrame.addFrameListener((IcyFrameListener)new IcyFrameAdapter(){

                public void icyFrameClosed(IcyFrameEvent e) {
                    contentPane.getController().close();
                }
            });
            this.icyFolderToCytomineFrame.setVisible(true);
        };
    }

    public void stopViewer() {
        this.closeFrame(this.annotationsFrame);
        this.closeFrame(this.cytomineToIcyFrame);
        this.closeFrame(this.icySequenceToCytomineFrame);
        this.closeFrame(this.icyFileToCytomineFrame);
        this.closeFrame(this.icyFolderToCytomineFrame);
        this.viewController.stopView();
    }

    private void closeFrame(IcyFrame frame) {
        if (frame != null) {
            frame.close();
        }
    }
}

