/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.abstractannotations.actions;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.bioimageanalysis.icy.icytomine.core.model.Term;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.abstractannotations.actions.AnnotationTermSelector;

public class AbstractAnnotationActionPanel
extends JPanel {
    private static final long serialVersionUID = 8091126232634101873L;
    private AnnotationTermSelector termSelector;
    private JButton btnSetTerms;
    private JButton btnDeleteAnnotation;
    private List<AnnotationTermAssociationListener> termAssociationChangeListeners;

    public AbstractAnnotationActionPanel() {
        this.setupUI();
        this.createListenerLists();
        this.setUIListeners();
    }

    private void setupUI() {
        this.setTitledBorder();
        this.setGridBagLayout();
        this.addTermAssociationControls();
        this.addAnnotationDeletionControls();
    }

    private void setTitledBorder() {
        this.setBorder(new TitledBorder(null, "Actions", 4, 2, null, null));
    }

    private void setGridBagLayout() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[4];
        gridBagLayout.rowHeights = new int[3];
        gridBagLayout.columnWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
    }

    private void addTermAssociationControls() {
        JLabel lblAssociatedTerms = new JLabel("Associated terms");
        GridBagConstraints gbc_lblAssociatedTerms = new GridBagConstraints();
        gbc_lblAssociatedTerms.insets = new Insets(0, 0, 5, 5);
        gbc_lblAssociatedTerms.anchor = 13;
        gbc_lblAssociatedTerms.gridx = 0;
        gbc_lblAssociatedTerms.gridy = 0;
        this.add((Component)lblAssociatedTerms, gbc_lblAssociatedTerms);
        this.termSelector = new AnnotationTermSelector();
        GridBagConstraints gbc_termSelector = new GridBagConstraints();
        gbc_termSelector.insets = new Insets(0, 0, 5, 5);
        gbc_termSelector.fill = 2;
        gbc_termSelector.gridx = 1;
        gbc_termSelector.gridy = 0;
        this.add((Component)this.termSelector, gbc_termSelector);
        this.btnSetTerms = new JButton("Set");
        GridBagConstraints gbc_btnSetTerms = new GridBagConstraints();
        gbc_btnSetTerms.insets = new Insets(0, 0, 5, 0);
        gbc_btnSetTerms.gridx = 2;
        gbc_btnSetTerms.gridy = 0;
        this.add((Component)this.btnSetTerms, gbc_btnSetTerms);
    }

    private void addAnnotationDeletionControls() {
        JLabel lblDeleteAnnotation = new JLabel("Delete selected annotation(s)");
        GridBagConstraints gbc_lblDeleteAnnotation = new GridBagConstraints();
        gbc_lblDeleteAnnotation.anchor = 13;
        gbc_lblDeleteAnnotation.insets = new Insets(0, 0, 0, 5);
        gbc_lblDeleteAnnotation.gridx = 0;
        gbc_lblDeleteAnnotation.gridy = 1;
        this.add((Component)lblDeleteAnnotation, gbc_lblDeleteAnnotation);
        this.btnDeleteAnnotation = new JButton("Delete");
        GridBagConstraints gbc_btnDeleteAnnotation = new GridBagConstraints();
        gbc_btnDeleteAnnotation.anchor = 17;
        gbc_btnDeleteAnnotation.insets = new Insets(0, 0, 0, 5);
        gbc_btnDeleteAnnotation.gridx = 1;
        gbc_btnDeleteAnnotation.gridy = 1;
        this.add((Component)this.btnDeleteAnnotation, gbc_btnDeleteAnnotation);
    }

    private void createListenerLists() {
        this.termAssociationChangeListeners = new ArrayList<AnnotationTermAssociationListener>(1);
    }

    private void setUIListeners() {
        this.btnSetTerms.addActionListener(this::onTermAssociationRequested);
    }

    private void onTermAssociationRequested(ActionEvent event) {
        this.termAssociationChangeListeners.forEach(l -> l.onTermSelectionChangeRequested(this.termSelector.getSelectedTerms()));
    }

    public void setAvailableTerms(Collection<Term> terms) {
        this.termSelector.setAvailableTerms(terms);
    }

    public Set<Term> getAvailableTerms() {
        return this.termSelector.getAvailableTerms();
    }

    public void setSelectedTerms(Set<Term> terms) {
        this.termSelector.setSelectedTerms(terms);
    }

    public void addAnnotationTermAssociationListener(AnnotationTermAssociationListener listener) {
        this.termAssociationChangeListeners.add(listener);
    }

    public void removeAnnotationTermAssociationListener(AnnotationTermAssociationListener listener) {
        this.termAssociationChangeListeners.remove(listener);
    }

    public void addAnnotationDeleteListener(ActionListener listener) {
        this.btnDeleteAnnotation.addActionListener(listener);
    }

    public void removeAnnotationDeleteListener(ActionListener listener) {
        this.btnDeleteAnnotation.removeActionListener(listener);
    }

    public static interface AnnotationTermAssociationListener {
        public void onTermSelectionChangeRequested(Set<Term> var1);
    }
}

