/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.abstractannotations.filters;

import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.ComboBoxModel;
import org.bioimageanalysis.icy.icytomine.core.model.Term;
import org.bioimageanalysis.icy.icytomine.core.model.filters.abstrct.AbstractAnnotationFilter;
import org.bioimageanalysis.icy.icytomine.core.model.filters.abstrct.AbstractAnnotationFilterByTerm;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.abstractannotations.filters.AbstractAnnotationFilterPanel;
import org.bioimageanalysis.icy.icytomine.ui.general.JCheckableItem;
import org.bioimageanalysis.icy.icytomine.ui.general.JCheckedComboBox;

public class AbstractAnnotationFilterByTermPanel
extends AbstractAnnotationFilterPanel<AbstractAnnotationFilterByTerm.TermItem> {
    private static final long serialVersionUID = -2425902310352423296L;
    private AbstractAnnotationFilterByTerm termFilter;
    private Set<AbstractAnnotationFilterByTerm.TermItem> termItems;

    public AbstractAnnotationFilterByTermPanel() {
        this.setLabelText("Terms:");
        this.termFilter = new AbstractAnnotationFilterByTerm();
        this.setAnnotationFilter(this.termFilter);
    }

    public void setPreviousFilter(AbstractAnnotationFilter previousFilter) {
        this.termFilter.setPreviousFilter(previousFilter);
    }

    public void setAvailableTerms(Set<Term> terms) {
        this.termItems = terms.stream().map(t -> new AbstractAnnotationFilterByTerm.TermItem((Term)t)).collect(Collectors.toSet());
        this.termItems.add(AbstractAnnotationFilterByTerm.TermItem.NO_TERM);
        this.termItems.add(AbstractAnnotationFilterByTerm.TermItem.ALL);
        this.termItems.add(AbstractAnnotationFilterByTerm.TermItem.NONE);
        this.termFilter.setActiveTerms(new HashSet<AbstractAnnotationFilterByTerm.TermItem>(this.termItems));
        this.setModel(this.termItems.toArray(new AbstractAnnotationFilterByTerm.TermItem[this.termItems.size()]), item -> item.toString(), item -> item != AbstractAnnotationFilterByTerm.TermItem.NONE);
    }

    @Override
    protected void choiceChanged(ActionEvent e) {
        JCheckableItem checkableItem = (JCheckableItem)((JCheckedComboBox)e.getSource()).getSelectedItem();
        AbstractAnnotationFilterByTerm.TermItem termItem = (AbstractAnnotationFilterByTerm.TermItem)checkableItem.object;
        if (termItem == AbstractAnnotationFilterByTerm.TermItem.ALL) {
            Set<AbstractAnnotationFilterByTerm.TermItem> activeTerms = this.termFilter.getActiveTerms();
            this.termItems.stream().filter(t -> t != AbstractAnnotationFilterByTerm.TermItem.ALL && t != AbstractAnnotationFilterByTerm.TermItem.NONE).forEach(t -> {
                boolean bl = activeTerms.add((AbstractAnnotationFilterByTerm.TermItem)t);
            });
            ComboBoxModel model = ((JCheckedComboBox)e.getSource()).getModel();
            int i = 0;
            while (i < model.getSize()) {
                JCheckableItem elem = (JCheckableItem)model.getElementAt(i);
                if (elem.getObject() == AbstractAnnotationFilterByTerm.TermItem.NONE) {
                    elem.setSelected(false);
                } else {
                    elem.setSelected(true);
                }
                ++i;
            }
            ((JCheckedComboBox)e.getSource()).invalidate();
        } else if (termItem == AbstractAnnotationFilterByTerm.TermItem.NONE) {
            this.termFilter.getActiveTerms().removeAll(this.termItems);
            ComboBoxModel model = ((JCheckedComboBox)e.getSource()).getModel();
            int i = 0;
            while (i < model.getSize()) {
                JCheckableItem elem = (JCheckableItem)model.getElementAt(i);
                elem.setSelected(false);
                ++i;
            }
            ((JCheckedComboBox)e.getSource()).invalidate();
        } else if (!checkableItem.isSelected()) {
            this.termFilter.getActiveTerms().add(termItem);
        } else {
            this.termFilter.getActiveTerms().remove(termItem);
        }
        this.termFilter.computeActiveAnnotations(AbstractAnnotationFilter.ComputationMode.RECOMPUTE_JUST_THIS);
    }
}

