/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.abstractannotations.filters;

import java.awt.event.ActionEvent;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.ComboBoxModel;
import org.bioimageanalysis.icy.icytomine.core.model.User;
import org.bioimageanalysis.icy.icytomine.core.model.filters.abstrct.AbstractAnnotationFilter;
import org.bioimageanalysis.icy.icytomine.core.model.filters.abstrct.AbstractAnnotationFilterByUser;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.abstractannotations.filters.AbstractAnnotationFilterPanel;
import org.bioimageanalysis.icy.icytomine.ui.general.JCheckableItem;
import org.bioimageanalysis.icy.icytomine.ui.general.JCheckedComboBox;

public class AbstractAnnotationFilterByUserPanel
extends AbstractAnnotationFilterPanel<AbstractAnnotationFilterByUser.UserItem> {
    private static final long serialVersionUID = 8625556747093295599L;
    private AbstractAnnotationFilterByUser userFilter;
    private Set<AbstractAnnotationFilterByUser.UserItem> userItems;

    public AbstractAnnotationFilterByUserPanel() {
        this.setLabelText("Users:");
        this.userFilter = new AbstractAnnotationFilterByUser();
        this.setAnnotationFilter(this.userFilter);
    }

    public void setPreviousFilter(AbstractAnnotationFilter previousFilter) {
        this.userFilter.setPreviousFilter(previousFilter);
    }

    public void setAvailableUsers(Set<User> users) {
        this.userItems = users.stream().map(u -> new AbstractAnnotationFilterByUser.UserItem((User)u)).collect(Collectors.toSet());
        List sortedItems = this.userItems.stream().sorted(Comparator.comparing(ui -> ui.getUser().getName().orElse("Unknown"))).collect(Collectors.toList());
        sortedItems.add(AbstractAnnotationFilterByUser.UserItem.NO_USER);
        sortedItems.add(AbstractAnnotationFilterByUser.UserItem.ALL);
        sortedItems.add(AbstractAnnotationFilterByUser.UserItem.NONE);
        this.userItems.add(AbstractAnnotationFilterByUser.UserItem.NO_USER);
        this.userItems.add(AbstractAnnotationFilterByUser.UserItem.ALL);
        this.userItems.add(AbstractAnnotationFilterByUser.UserItem.NONE);
        this.userFilter.setActiveUsers(new HashSet<AbstractAnnotationFilterByUser.UserItem>(this.userItems));
        this.setModel((AbstractAnnotationFilterByUser.UserItem[])sortedItems.stream().toArray(AbstractAnnotationFilterByUser.UserItem[]::new), item -> item.toString(), item -> item != AbstractAnnotationFilterByUser.UserItem.NONE);
    }

    @Override
    protected void choiceChanged(ActionEvent e) {
        JCheckableItem checkableItem = (JCheckableItem)((JCheckedComboBox)e.getSource()).getSelectedItem();
        AbstractAnnotationFilterByUser.UserItem userItem = (AbstractAnnotationFilterByUser.UserItem)checkableItem.object;
        if (userItem == AbstractAnnotationFilterByUser.UserItem.ALL) {
            Set<AbstractAnnotationFilterByUser.UserItem> activeUsers = this.userFilter.getActiveUsers();
            this.userItems.stream().filter(u -> u != AbstractAnnotationFilterByUser.UserItem.ALL && u != AbstractAnnotationFilterByUser.UserItem.NONE).forEach(u -> {
                boolean bl = activeUsers.add((AbstractAnnotationFilterByUser.UserItem)u);
            });
            ComboBoxModel model = ((JCheckedComboBox)e.getSource()).getModel();
            int i = 0;
            while (i < model.getSize()) {
                JCheckableItem elem = (JCheckableItem)model.getElementAt(i);
                if (elem.getObject() == AbstractAnnotationFilterByUser.UserItem.NONE) {
                    elem.setSelected(false);
                } else {
                    elem.setSelected(true);
                }
                ++i;
            }
            ((JCheckedComboBox)e.getSource()).invalidate();
        } else if (userItem == AbstractAnnotationFilterByUser.UserItem.NONE) {
            this.userFilter.getActiveUsers().removeAll(this.userItems);
            ComboBoxModel model = ((JCheckedComboBox)e.getSource()).getModel();
            int i = 0;
            while (i < model.getSize()) {
                JCheckableItem elem = (JCheckableItem)model.getElementAt(i);
                elem.setSelected(false);
                ++i;
            }
            ((JCheckedComboBox)e.getSource()).invalidate();
        } else if (!checkableItem.isSelected()) {
            this.userFilter.getActiveUsers().add(userItem);
        } else {
            this.userFilter.getActiveUsers().remove(userItem);
        }
        this.userFilter.computeActiveAnnotations(AbstractAnnotationFilter.ComputationMode.RECOMPUTE_JUST_THIS);
    }
}

