/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.abstractannotations.filters;

import icy.resource.ResourceUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Function;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.bioimageanalysis.icy.icytomine.core.model.AbstractAnnotation;
import org.bioimageanalysis.icy.icytomine.core.model.filters.abstrct.AbstractAnnotationFilter;
import org.bioimageanalysis.icy.icytomine.ui.general.JCheckableItem;
import org.bioimageanalysis.icy.icytomine.ui.general.JCheckedComboBox;

public abstract class AbstractAnnotationFilterPanel<E>
extends JPanel {
    private JLabel lblFilterLabel;
    private JCheckedComboBox<E> checkedSelectorFilterOptions;
    private JButton btnDeleteFilter;
    private AbstractAnnotationFilter filter;

    public AbstractAnnotationFilterPanel() {
        this.setupUI();
    }

    private void setupUI() {
        this.setGridBagLayout();
        this.addFilterLabel();
        this.addFilterSelector();
        this.addFilterDeletionButton();
    }

    private void setGridBagLayout() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[4];
        gridBagLayout.rowHeights = new int[2];
        gridBagLayout.columnWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
    }

    private void addFilterLabel() {
        this.lblFilterLabel = new JLabel("Filter");
        GridBagConstraints gbc_lblFilterLabel = new GridBagConstraints();
        gbc_lblFilterLabel.insets = new Insets(0, 0, 0, 5);
        gbc_lblFilterLabel.anchor = 13;
        gbc_lblFilterLabel.gridx = 0;
        gbc_lblFilterLabel.gridy = 0;
        this.add((Component)this.lblFilterLabel, gbc_lblFilterLabel);
    }

    private void addFilterSelector() {
        this.checkedSelectorFilterOptions = new JCheckedComboBox();
        GridBagConstraints gbc_checkedSelectorFilterOptions = new GridBagConstraints();
        gbc_checkedSelectorFilterOptions.insets = new Insets(0, 0, 0, 5);
        gbc_checkedSelectorFilterOptions.fill = 2;
        gbc_checkedSelectorFilterOptions.gridx = 1;
        gbc_checkedSelectorFilterOptions.gridy = 0;
        this.add(this.checkedSelectorFilterOptions, gbc_checkedSelectorFilterOptions);
    }

    private void addFilterDeletionButton() {
        this.btnDeleteFilter = new JButton(new ImageIcon(ResourceUtil.ICON_DELETE.getScaledInstance(15, 15, 4)));
        this.btnDeleteFilter.setMinimumSize(new Dimension(15, 15));
        this.btnDeleteFilter.setPreferredSize(new Dimension(21, 21));
        GridBagConstraints gbc_btnDeleteFilter = new GridBagConstraints();
        gbc_btnDeleteFilter.gridx = 2;
        gbc_btnDeleteFilter.gridy = 0;
        this.add((Component)this.btnDeleteFilter, gbc_btnDeleteFilter);
    }

    public void setLabelText(String text) {
        this.lblFilterLabel.setText(text);
    }

    public void setAnnotationFilter(AbstractAnnotationFilter filter) {
        this.filter = filter;
    }

    public AbstractAnnotationFilter getAnnotationFilter() {
        return this.filter;
    }

    public void setModel(E[] items, Function<E, String> labelFunction, Function<E, Boolean> selectionFunction) {
        JCheckableItem[] checkableItems = (JCheckableItem[])Arrays.stream(items).map(it -> new JCheckableItem<Object>(it, (String)labelFunction.apply(it), (Boolean)selectionFunction.apply(it))).toArray(JCheckableItem[]::new);
        this.checkedSelectorFilterOptions.setModel(new DefaultComboBoxModel<JCheckableItem>(checkableItems));
        this.checkedSelectorFilterOptions.addActionListener(this::choiceChanged);
    }

    protected abstract void choiceChanged(ActionEvent var1);

    public void addRemoveButtonActionListener(ActionListener listener) {
        this.btnDeleteFilter.addActionListener(listener);
    }

    public void removeRemoveButtonActionListener(ActionListener listener) {
        this.btnDeleteFilter.removeActionListener(listener);
    }

    public static interface AnnotationFilterListener {
        public void filterUpdated(Set<AbstractAnnotation> var1);
    }
}

