/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.view;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.controller.view.ViewController;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.controller.view.ViewControllerFactory;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.controller.view.provider.ViewProvider;

public class ViewCanvasPanel
extends JPanel {
    static final AlphaComposite comp = AlphaComposite.getInstance(3);
    BufferedImage[] layers;
    private ViewProvider viewProvider;
    private ViewController viewController;
    private Rectangle selectionBox;

    public ViewCanvasPanel(ViewProvider viewProvider) {
        this.setBackground(Color.GRAY);
        this.setLayout(new BorderLayout(0, 0));
        this.layers = new BufferedImage[]{new BufferedImage(10, 10, 2)};
        this.viewProvider = viewProvider;
        this.viewProvider.addViewListener(newViews -> this.refreshCanvas(newViews));
        this.viewController = ViewControllerFactory.create(this.viewProvider, this);
    }

    private void refreshCanvas(BufferedImage ... newViews) {
        this.layers = newViews;
        this.repaint();
    }

    public ViewProvider getViewProvider() {
        return this.viewProvider;
    }

    public ViewController getViewController() {
        return this.viewController;
    }

    public void updateCanvas() {
        this.refreshCanvas(this.viewProvider.getView(this.getSize()));
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.drawLayers(g);
    }

    private void drawLayers(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.drawImage((Image)this.layers[0], 0, 0, this);
        g2.setComposite(comp);
        int i = 1;
        while (i < this.layers.length) {
            g2.drawImage((Image)this.layers[1], 0, 0, null);
            ++i;
        }
        if (this.selectionBox != null) {
            this.drawSelectionBox(g2);
        }
        g2.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawSelectionBox(Graphics2D g2) {
        Rectangle rectangle = this.selectionBox;
        synchronized (rectangle) {
            g2.setColor(new Color(255, 255, 255, 128));
            g2.fillRect(this.selectionBox.x, this.selectionBox.y, this.selectionBox.width, this.selectionBox.height);
            g2.setColor(Color.WHITE);
            g2.setStroke(new BasicStroke(3.0f));
            g2.drawRect(this.selectionBox.x, this.selectionBox.y, this.selectionBox.width, this.selectionBox.height);
            g2.setColor(Color.BLACK);
            g2.setStroke(new BasicStroke(1.0f));
            g2.drawRect(this.selectionBox.x, this.selectionBox.y, this.selectionBox.width, this.selectionBox.height);
        }
    }

    public void setSelectionBox(Point2D start, Point2D end) {
        int x = (int)Math.min(start.getX(), end.getX());
        int y = (int)Math.min(start.getY(), end.getY());
        int width = (int)Math.max(start.getX(), end.getX()) - x;
        int height = (int)Math.max(start.getY(), end.getY()) - y;
        this.selectionBox = new Rectangle(x, y, width, height);
    }

    public void unsetSelectionBox() {
        this.selectionBox = null;
    }
}

