/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.viewer.controller.view;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import icy.type.dimension.Dimension2D;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.bioimageanalysis.icy.icytomine.core.model.AbstractAnnotation;
import org.bioimageanalysis.icy.icytomine.core.model.Image;
import org.bioimageanalysis.icy.icytomine.core.view.converters.MagnitudeResolutionConverter;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.abstractannotations.AbstractAnnotationTable;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.view.ViewCanvasPanel;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.controller.view.ViewController;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.controller.view.provider.ViewProvider;

public class CachedViewController
implements ViewController {
    private Image imageInformation;
    private ViewCanvasPanel viewCanvasPanel;
    private Point2D viewPositionAt0Resolution;
    private double resolutionLevel;
    private Point2D lastDragStartPositionInView;
    private Point2D lastDragStartPositionInImage;
    private Collection<ResolutionListener> resolutionListeners;
    private Collection<PositionListener> cursorPositionListeners;
    private Collection<AbstractAnnotationTable.AnnotationSelectionListener> annotationSelectionListener;

    public CachedViewController(Image imageInformation, ViewCanvasPanel viewCanvasPanel) {
        this.imageInformation = imageInformation;
        this.resolutionListeners = new HashSet<ResolutionListener>();
        this.cursorPositionListeners = new HashSet<PositionListener>();
        this.annotationSelectionListener = new HashSet<AbstractAnnotationTable.AnnotationSelectionListener>();
        this.viewCanvasPanel = viewCanvasPanel;
        this.viewPositionAt0Resolution = new Point2D.Double();
        this.resolutionLevel = 0.0;
        this.lastDragStartPositionInView = new Point2D.Double();
        this.lastDragStartPositionInImage = new Point2D.Double();
        this.setCanvasEventListeners();
    }

    private void setCanvasEventListeners() {
        this.setCanvasMouseEventListeners();
        this.setCanvasComponentEventListeners();
    }

    private void setCanvasMouseEventListeners() {
        this.viewCanvasPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                CachedViewController.this.startMouseDragAt(e.getPoint());
            }
        });
        this.viewCanvasPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!e.isControlDown()) {
                    CachedViewController.this.selectAnnotationAt(e.getPoint());
                } else {
                    CachedViewController.this.toggleAnnotationAt(e.getPoint());
                }
            }
        });
        this.viewCanvasPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (CachedViewController.this.lastDragStartPositionInView != null && e.isShiftDown()) {
                    CachedViewController.this.selectAnnotationsInArea(CachedViewController.this.lastDragStartPositionInView, e.getPoint());
                }
                CachedViewController.this.clearMouseDrag();
            }
        });
        this.viewCanvasPanel.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if ((e.getModifiersEx() & 0x40) == 64) {
                    CachedViewController.this.mouseSelectTo(e.getPoint());
                } else {
                    CachedViewController.this.mouseDragTo(e.getPoint());
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                CachedViewController.this.notifyMouseMovedTo(e.getPoint());
            }
        });
        this.viewCanvasPanel.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                CachedViewController.this.notifyMouseWheelMovedTo(e.getWheelRotation(), e.getPoint());
            }
        });
    }

    private void setCanvasComponentEventListeners() {
        this.viewCanvasPanel.addComponentListener(new RepaintOnResizeListener());
    }

    private void adjustZoomToFitInView() {
        this.adjustResolutionToFitInView();
        this.viewPositionAt0Resolution = new Point2D.Double();
        this.viewCanvasPanel.getViewProvider().setPosition(this.viewPositionAt0Resolution);
        this.viewCanvasPanel.getViewProvider().setResolutionLevel(this.resolutionLevel);
        this.notifyResolutionChanged();
    }

    private void adjustResolutionToFitInView() {
        Dimension presentedImageDimension = this.imageInformation.getSize().get();
        Dimension viewDimension = this.viewCanvasPanel.getBounds().getSize();
        double widthAdjustedResolution = Math.log(presentedImageDimension.getWidth() / viewDimension.getWidth()) / Math.log(2.0);
        double heightAdjustedResolution = Math.log(presentedImageDimension.getHeight() / viewDimension.getHeight()) / Math.log(2.0);
        this.resolutionLevel = Math.min(Math.max(widthAdjustedResolution, heightAdjustedResolution), (double)(this.imageInformation.getDepth().get() + 1L));
    }

    private void notifyResolutionChanged() {
        this.resolutionListeners.forEach(l -> l.resolutionChanged(this.resolutionLevel));
    }

    private void startMouseDragAt(Point position) {
        this.lastDragStartPositionInView = position;
        this.lastDragStartPositionInImage.setLocation(this.viewPositionAt0Resolution);
    }

    private void mouseSelectTo(Point position) {
        this.viewCanvasPanel.setSelectionBox(this.lastDragStartPositionInView, position);
        this.viewCanvasPanel.updateCanvas();
    }

    private void mouseDragTo(Point position) {
        this.moveViewBy(this.lastDragStartPositionInView.getX() - position.getX(), this.lastDragStartPositionInView.getY() - position.getY());
        this.refreshView();
    }

    private void moveViewBy(double x, double y) {
        Point2D deltaPosition = MagnitudeResolutionConverter.convertPoint2D(new Point2D.Double(x, y), this.resolutionLevel, 0.0);
        this.viewPositionAt0Resolution.setLocation(this.lastDragStartPositionInImage.getX() + deltaPosition.getX(), this.lastDragStartPositionInImage.getY() + deltaPosition.getY());
    }

    protected void notifyMouseMovedTo(Point2D cursorPosition) {
        Point2D cursorPositionOnImage = this.getImagePositionInCurrentView(cursorPosition);
        this.notifyCursorPositionChanged(cursorPositionOnImage);
    }

    private Point2D getImagePositionInCurrentView(Point2D positionInView) {
        Point2D positionInViewAtZeroResolution = MagnitudeResolutionConverter.convertPoint2D(positionInView, this.resolutionLevel, 0.0);
        return this.getImagePositionFromViewPosition(positionInViewAtZeroResolution);
    }

    private Point2D getImagePositionFromViewPosition(Point2D positionInViewAtZeroResolution) {
        return new Point2D.Double(this.viewPositionAt0Resolution.getX() + positionInViewAtZeroResolution.getX(), this.viewPositionAt0Resolution.getY() + positionInViewAtZeroResolution.getY());
    }

    private void notifyCursorPositionChanged(Point2D cursorPositionOnImage) {
        this.cursorPositionListeners.forEach(l -> l.positionChanged(cursorPositionOnImage));
    }

    protected void notifyMouseWheelMovedTo(int wheelRotation, Point position) {
        Point2D cursorPositionInImageAtZeroResolution = this.getCursorPositionOnImageAtZeroResolution(position);
        this.resolutionLevel += 0.25 * (double)wheelRotation;
        this.viewPositionAt0Resolution = this.getViewPositionAtZeroResolutionFromCursorPosition(cursorPositionInImageAtZeroResolution, position);
        this.refreshView();
    }

    private Point2D getCursorPositionOnImageAtZeroResolution(Point2D position) {
        Point2D positionInViewAtZeroResolution = MagnitudeResolutionConverter.convertPoint2D(position, this.resolutionLevel, 0.0);
        return new Point2D.Double(this.viewPositionAt0Resolution.getX() + positionInViewAtZeroResolution.getX(), this.viewPositionAt0Resolution.getY() + positionInViewAtZeroResolution.getY());
    }

    private Point2D getViewPositionAtZeroResolutionFromCursorPosition(Point2D cursorPositionAtZeroResolution, Point cursorPosititionInView) {
        Point2D positionInViewAtZeroResolution = MagnitudeResolutionConverter.convertPoint2D(cursorPosititionInView, this.resolutionLevel, 0.0);
        return new Point2D.Double(cursorPositionAtZeroResolution.getX() - positionInViewAtZeroResolution.getX(), cursorPositionAtZeroResolution.getY() - positionInViewAtZeroResolution.getY());
    }

    private void selectAnnotationAt(Point displayPoint) {
        Polygon imageArea = this.createImagePolygonAroundDisplayPoint(displayPoint, 4.0);
        Set<AbstractAnnotation> annotationsIntersecting = this.getAnnotationsIntersectingPolygon(imageArea);
        HashSet<AbstractAnnotation> selectedAnnotationSet = new HashSet<AbstractAnnotation>();
        if (!annotationsIntersecting.isEmpty()) {
            selectedAnnotationSet.add(annotationsIntersecting.iterator().next());
        }
        this.setSelectedAnnotations(selectedAnnotationSet);
        this.notifyAnnotationSelection(selectedAnnotationSet);
    }

    private Polygon createImagePolygonAroundDisplayPoint(Point2D displayPoint, double epsilon) {
        Point2D imagePoint = this.getCursorPositionOnImageAtZeroResolution(displayPoint);
        double imageEpsilon = MagnitudeResolutionConverter.convertMagnitude(epsilon, this.resolutionLevel, 0.0);
        Coordinate[] imageAreaCoordinates = new Coordinate[]{new Coordinate(imagePoint.getX() - imageEpsilon, (double)this.imageInformation.getSizeY().get().intValue() - imagePoint.getY() - imageEpsilon), new Coordinate(imagePoint.getX() + imageEpsilon, (double)this.imageInformation.getSizeY().get().intValue() - imagePoint.getY() - imageEpsilon), new Coordinate(imagePoint.getX() + imageEpsilon, (double)this.imageInformation.getSizeY().get().intValue() - imagePoint.getY() + imageEpsilon), new Coordinate(imagePoint.getX() - imageEpsilon, (double)this.imageInformation.getSizeY().get().intValue() - imagePoint.getY() + imageEpsilon), new Coordinate(imagePoint.getX() - imageEpsilon, (double)this.imageInformation.getSizeY().get().intValue() - imagePoint.getY() - imageEpsilon)};
        GeometryFactory factory = new GeometryFactory();
        Polygon imageArea = factory.createPolygon(imageAreaCoordinates);
        return imageArea;
    }

    private Set<AbstractAnnotation> getAnnotationsIntersectingPolygon(Polygon imageArea) {
        Set<AbstractAnnotation> activeAnnotations = this.getActiveAnnotations();
        Set<AbstractAnnotation> intersectingAnnotations = activeAnnotations.stream().filter(a -> {
            Geometry bigGeometry = a.getGeometryAtZeroResolution(false);
            boolean contains = bigGeometry.intersects((Geometry)imageArea);
            return contains;
        }).collect(Collectors.toSet());
        return intersectingAnnotations;
    }

    private void notifyAnnotationSelection(Set<AbstractAnnotation> selectedAnnotationSet) {
        this.annotationSelectionListener.forEach(listener -> listener.selectionChanged(selectedAnnotationSet));
    }

    private void toggleAnnotationAt(Point displayPoint) {
        Polygon imageArea = this.createImagePolygonAroundDisplayPoint(displayPoint, 4.0);
        Set<AbstractAnnotation> annotationsIntersecting = this.getAnnotationsIntersectingPolygon(imageArea);
        HashSet<AbstractAnnotation> newAnnotationSelection = new HashSet<AbstractAnnotation>(this.getSelectedAnnotations());
        if (!annotationsIntersecting.isEmpty()) {
            AbstractAnnotation targetAnnotation = annotationsIntersecting.iterator().next();
            if (newAnnotationSelection.contains(targetAnnotation)) {
                newAnnotationSelection.remove(targetAnnotation);
            } else {
                newAnnotationSelection.add(targetAnnotation);
            }
        }
        this.setSelectedAnnotations(newAnnotationSelection);
        this.notifyAnnotationSelection(newAnnotationSelection);
    }

    private void selectAnnotationsInArea(Point2D point1, Point2D point2) {
        System.out.format("Selection on box from %s to %s\n", point1, point2);
        this.viewCanvasPanel.unsetSelectionBox();
        Polygon imageArea = this.createImageRectangularPolygonFromTwoPoints(point1, point2);
        Set<AbstractAnnotation> annotationsIntersecting = this.getAnnotationsIntersectingPolygon(imageArea);
        this.setSelectedAnnotations(annotationsIntersecting);
        this.notifyAnnotationSelection(annotationsIntersecting);
        this.refreshView();
    }

    private Polygon createImageRectangularPolygonFromTwoPoints(Point2D displayPoint1, Point2D displayPoint2) {
        Point2D imagePoint1 = this.getCursorPositionOnImageAtZeroResolution(displayPoint1);
        Point2D imagePoint2 = this.getCursorPositionOnImageAtZeroResolution(displayPoint2);
        Point2D.Double minPoint = new Point2D.Double(Math.min(imagePoint1.getX(), imagePoint2.getX()), Math.min((double)this.imageInformation.getSizeY().get().intValue() - imagePoint1.getY(), (double)this.imageInformation.getSizeY().get().intValue() - imagePoint2.getY()));
        Point2D.Double maxPoint = new Point2D.Double(Math.max(imagePoint1.getX(), imagePoint2.getX()), Math.max((double)this.imageInformation.getSizeY().get().intValue() - imagePoint1.getY(), (double)this.imageInformation.getSizeY().get().intValue() - imagePoint2.getY()));
        Coordinate[] imageAreaCoordinates = new Coordinate[]{new Coordinate(((Point2D)minPoint).getX(), ((Point2D)minPoint).getY()), new Coordinate(((Point2D)maxPoint).getX(), ((Point2D)minPoint).getY()), new Coordinate(((Point2D)maxPoint).getX(), ((Point2D)maxPoint).getY()), new Coordinate(((Point2D)minPoint).getX(), ((Point2D)maxPoint).getY()), new Coordinate(((Point2D)minPoint).getX(), ((Point2D)minPoint).getY())};
        GeometryFactory factory = new GeometryFactory();
        Polygon imageArea = factory.createPolygon(imageAreaCoordinates);
        return imageArea;
    }

    private void clearMouseDrag() {
        this.lastDragStartPositionInView = null;
    }

    @Override
    public Image getImageInformation() {
        return this.imageInformation;
    }

    @Override
    public void addResolutionListener(ResolutionListener listener) {
        this.resolutionListeners.add(listener);
    }

    @Override
    public void addCursorPositionListener(PositionListener listener) {
        this.cursorPositionListeners.add(listener);
    }

    @Override
    public void addAnnotationSelectionListener(AbstractAnnotationTable.AnnotationSelectionListener listener) {
        this.annotationSelectionListener.add(listener);
    }

    @Override
    public void zoomIn() {
        Point2D centerPositionAtZeroResolution = this.getViewCenterPositionAtZeroResolution();
        this.resolutionLevel -= 1.0;
        this.viewPositionAt0Resolution = this.getViewPositionAtZeroResolutionFromCenterPosition(centerPositionAtZeroResolution);
        this.refreshView();
    }

    @Override
    public void zoomOut() {
        Point2D centerPositionAtZeroResolution = this.getViewCenterPositionAtZeroResolution();
        this.resolutionLevel += 1.0;
        this.viewPositionAt0Resolution = this.getViewPositionAtZeroResolutionFromCenterPosition(centerPositionAtZeroResolution);
        this.refreshView();
    }

    private Point2D getViewCenterPositionAtZeroResolution() {
        Dimension2D canvasSizeAtZeroResolution = MagnitudeResolutionConverter.convertDimension2D(this.viewCanvasPanel.getSize(), this.resolutionLevel, 0.0);
        return new Point2D.Double(this.viewPositionAt0Resolution.getX() + canvasSizeAtZeroResolution.getWidth() / 2.0, this.viewPositionAt0Resolution.getY() + canvasSizeAtZeroResolution.getHeight() / 2.0);
    }

    private Point2D getViewPositionAtZeroResolutionFromCenterPosition(Point2D centerPositionAtZeroResolution) {
        Dimension2D canvasSizeAtZeroResolution = MagnitudeResolutionConverter.convertDimension2D(this.viewCanvasPanel.getSize(), this.resolutionLevel, 0.0);
        return new Point2D.Double(centerPositionAtZeroResolution.getX() - canvasSizeAtZeroResolution.getWidth() / 2.0, centerPositionAtZeroResolution.getY() - canvasSizeAtZeroResolution.getHeight() / 2.0);
    }

    @Override
    public void setResolution(double resolutionLevel) {
        Point2D centerPositionAtZeroResolution = this.getViewCenterPositionAtZeroResolution();
        this.resolutionLevel = resolutionLevel;
        this.viewPositionAt0Resolution = this.getViewPositionAtZeroResolutionFromCenterPosition(centerPositionAtZeroResolution);
        this.refreshView();
    }

    @Override
    public void adjustImageZoomToView() {
        this.adjustZoomToFitInView();
        this.refreshView();
    }

    @Override
    public void updateAnnotations() {
    }

    @Override
    public void refreshView() {
        this.viewCanvasPanel.getViewProvider().setPosition(this.viewPositionAt0Resolution);
        this.viewCanvasPanel.getViewProvider().setResolutionLevel(this.resolutionLevel);
        this.viewCanvasPanel.updateCanvas();
        this.resolutionListeners.stream().forEach(l -> l.resolutionChanged(this.resolutionLevel));
    }

    @Override
    public void stopView() {
        this.viewCanvasPanel.getViewProvider().stop();
    }

    @Override
    public Rectangle2D getCurrentViewBoundsAtZeroResolution() {
        double viewResolution = this.viewCanvasPanel.getViewProvider().getResolution();
        Point2D positionAtZeroResolution = this.viewCanvasPanel.getViewProvider().getPosition();
        Dimension dimensionAtViewResolution = this.viewCanvasPanel.getSize();
        Dimension2D dimensionAtZeroResolution = MagnitudeResolutionConverter.convertDimension2D(dimensionAtViewResolution, viewResolution, 0.0);
        return new Rectangle2D.Double(positionAtZeroResolution.getX(), positionAtZeroResolution.getY(), dimensionAtZeroResolution.getWidth(), dimensionAtZeroResolution.getHeight());
    }

    @Override
    public double getCurrentResolution() {
        return this.viewCanvasPanel.getViewProvider().getResolution();
    }

    @Override
    public void setTargetAnnotations(Set<? extends AbstractAnnotation> annotations) {
        this.viewCanvasPanel.getViewProvider().setTargetAbstractAnnotaions(annotations);
        this.viewCanvasPanel.updateCanvas();
    }

    @Override
    public void addTargetAbstractAnnotations(Set<? extends AbstractAnnotation> annotationsToAdd) {
        this.viewCanvasPanel.getViewProvider().addTargetAbstractAnnotations(annotationsToAdd);
        this.viewCanvasPanel.updateCanvas();
    }

    @Override
    public void removeTargetAbstractAnnotations(Set<? extends AbstractAnnotation> annotationsToRemove) {
        this.viewCanvasPanel.getViewProvider().removeTargetAbstractAnnotations(annotationsToRemove);
        this.viewCanvasPanel.updateCanvas();
    }

    @Override
    public Set<AbstractAnnotation> getTargetAnnotations() {
        return this.viewCanvasPanel.getViewProvider().getTargetAbstractAnnotations();
    }

    @Override
    public void setVisibileAnnotations(Set<? extends AbstractAnnotation> newVisibleAnnotations) {
        this.viewCanvasPanel.getViewProvider().setVisibleAbstractAnnotations(newVisibleAnnotations);
        this.viewCanvasPanel.updateCanvas();
    }

    @Override
    public void addVisibileAbstractAnnotations(Set<AbstractAnnotation> visibleAnnotationsToAdd) {
        this.viewCanvasPanel.getViewProvider().addVisibleAbstractAnnotations(visibleAnnotationsToAdd);
        this.viewCanvasPanel.updateCanvas();
    }

    @Override
    public Set<AbstractAnnotation> getVisibleAnnotations() {
        return this.viewCanvasPanel.getViewProvider().getVisibleAbstractAnnotations();
    }

    @Override
    public Set<AbstractAnnotation> getActiveAnnotations() {
        return this.viewCanvasPanel.getViewProvider().getActiveAbstractAnnotations();
    }

    @Override
    public ViewProvider getViewProvider() {
        return this.viewCanvasPanel.getViewProvider();
    }

    @Override
    public void setSelectedAnnotations(Set<? extends AbstractAnnotation> selectedAnnotations) {
        this.viewCanvasPanel.getViewProvider().setSelectedAbstractAnnotations(selectedAnnotations);
        this.viewCanvasPanel.updateCanvas();
    }

    @Override
    public Set<AbstractAnnotation> getSelectedAnnotations() {
        return this.viewCanvasPanel.getViewProvider().getSelectedAbstractAnnotations();
    }

    @Override
    public void focusOnAnnotation(AbstractAnnotation a) {
        Rectangle2D annotationLocation = a.getYAdjustedApproximativeBounds();
        int margin = 2;
        this.viewPositionAt0Resolution = new Point2D.Double(annotationLocation.getX() - (double)margin, annotationLocation.getY() - (double)margin);
        Dimension2D.Double dimensionAt0Resolution = new Dimension2D.Double(annotationLocation.getWidth() + (double)(2 * margin), annotationLocation.getHeight() + (double)(2 * margin));
        this.resolutionLevel = this.getResolutionLevelToFitDimension((Dimension2D)dimensionAt0Resolution);
        this.refreshView();
    }

    private double getResolutionLevelToFitDimension(Dimension2D dimensionAtZeroResolutionToFit) {
        Dimension viewDimension = this.viewCanvasPanel.getBounds().getSize();
        double widthAdjustedResolution = Math.log(dimensionAtZeroResolutionToFit.getWidth() / ((Dimension2D)viewDimension).getWidth()) / Math.log(2.0);
        double heightAdjustedResolution = Math.log(dimensionAtZeroResolutionToFit.getHeight() / ((Dimension2D)viewDimension).getHeight()) / Math.log(2.0);
        return Math.min(Math.max(widthAdjustedResolution, heightAdjustedResolution), (double)this.imageInformation.getDepth().get().longValue());
    }

    public static interface PositionListener {
        public void positionChanged(Point2D var1);
    }

    public class RepaintOnResizeListener
    extends ComponentAdapter {
        @Override
        public void componentResized(ComponentEvent e) {
            CachedViewController.this.viewCanvasPanel.updateCanvas();
            CachedViewController.this.viewCanvasPanel.invalidate();
        }

        @Override
        public void componentShown(ComponentEvent e) {
            CachedViewController.this.viewCanvasPanel.invalidate();
        }
    }

    public static interface ResolutionListener {
        public void resolutionChanged(double var1);
    }
}

