/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.general;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.bioimageanalysis.icy.icytomine.ui.general.JCheckableItem;

public class JCheckBoxCellRenderer<E>
implements ListCellRenderer<JCheckableItem<E>> {
    private final JLabel label = new JLabel(" ");
    private final JCheckBox check = new JCheckBox(" ");

    @Override
    public Component getListCellRendererComponent(JList<? extends JCheckableItem<E>> list, JCheckableItem<E> value, int index, boolean isSelected, boolean cellHasFocus) {
        if (index < 0) {
            this.label.setText(JCheckBoxCellRenderer.getCheckedItemString(list.getModel()));
            return this.label;
        }
        this.check.setText(Objects.toString(value, ""));
        this.check.setSelected(value.isSelected());
        if (isSelected) {
            this.check.setBackground(list.getSelectionBackground());
            this.check.setForeground(list.getSelectionForeground());
        } else {
            this.check.setBackground(list.getBackground());
            this.check.setForeground(list.getForeground());
        }
        return this.check;
    }

    private static <T extends JCheckableItem<?>> String getCheckedItemString(ListModel<T> model) {
        ArrayList<String> selectedItems = new ArrayList<String>();
        int i = 0;
        while (i < model.getSize()) {
            JCheckableItem v = (JCheckableItem)model.getElementAt(i);
            if (v.isSelected()) {
                selectedItems.add(v.toString());
            }
            ++i;
        }
        if (selectedItems.isEmpty()) {
            return " ";
        }
        return selectedItems.stream().filter(e -> e != null).sorted().collect(Collectors.joining(", "));
    }
}

