/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.general;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.accessibility.Accessible;
import javax.swing.AbstractAction;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.KeyStroke;
import javax.swing.plaf.basic.ComboPopup;
import org.bioimageanalysis.icy.icytomine.ui.general.JCheckBoxCellRenderer;
import org.bioimageanalysis.icy.icytomine.ui.general.JCheckableItem;

public class JCheckedComboBox<E>
extends JComboBox<JCheckableItem<E>> {
    private boolean keepOpen;
    private transient ActionListener listener;

    public JCheckedComboBox() {
    }

    public JCheckedComboBox(ComboBoxModel<JCheckableItem<E>> model) {
        super(model);
    }

    @Override
    public void updateUI() {
        this.setRenderer(null);
        this.removeActionListener(this.listener);
        super.updateUI();
        this.listener = e -> {
            if (((long)e.getModifiers() & 0x10L) != 0L) {
                this.updateItem(this.getSelectedIndex());
                this.keepOpen = true;
            }
        };
        this.setRenderer(new JCheckBoxCellRenderer());
        this.addActionListener(this.listener);
        this.getInputMap(0).put(KeyStroke.getKeyStroke(32, 0), "checkbox-select");
        this.getActionMap().put("checkbox-select", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Accessible a = JCheckedComboBox.this.getAccessibleContext().getAccessibleChild(0);
                if (a instanceof ComboPopup) {
                    JCheckedComboBox.this.updateItem(((ComboPopup)((Object)a)).getList().getSelectedIndex());
                }
            }
        });
    }

    private void updateItem(int selectedIndex) {
        if (this.isPopupVisible()) {
            JCheckableItem item;
            item.setSelected(!(item = (JCheckableItem)this.getItemAt(selectedIndex)).isSelected());
            this.setSelectedIndex(-1);
            this.setSelectedItem(item);
        }
    }

    @Override
    public void setPopupVisible(boolean v) {
        if (this.keepOpen) {
            this.keepOpen = false;
        } else {
            super.setPopupVisible(v);
        }
    }

    public List<JCheckableItem<E>> getCheckableItems() {
        ArrayList<JCheckableItem<JCheckableItem>> checkableItemsList = new ArrayList<JCheckableItem<JCheckableItem>>();
        int i = 0;
        while (i < this.getItemCount()) {
            checkableItemsList.add((JCheckableItem)this.getItemAt(i));
            ++i;
        }
        return checkableItemsList;
    }
}

