/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui.calendar;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import org.japura.gui.calendar.Calendar;
import org.japura.gui.calendar.CalendarComponent;
import org.japura.gui.calendar.CalendarComponentType;
import org.japura.gui.calendar.CalendarProperties;
import org.japura.gui.calendar.DayOfWeek;
import org.japura.gui.calendar.PropertiesProvider;

public class DefaultPropertiesProvider
implements PropertiesProvider {
    private CalendarProperties properties = new CalendarProperties();

    public CalendarProperties getProperties() {
        return this.properties;
    }

    @Override
    public Color getMouseOverForeground(CalendarComponent component) {
        CalendarComponentType type = component.getType();
        if (type.equals((Object)CalendarComponentType.PREVIOUS_YEAR_BUTTON)) {
            return this.getProperties().getMouseOverButtonColor();
        }
        if (type.equals((Object)CalendarComponentType.PREVIOUS_MONTH_BUTTON)) {
            return this.getProperties().getMouseOverButtonColor();
        }
        if (type.equals((Object)CalendarComponentType.NEXT_YEAR_BUTTON)) {
            return this.getProperties().getMouseOverButtonColor();
        }
        if (type.equals((Object)CalendarComponentType.NEXT_MONTH_BUTTON)) {
            return this.getProperties().getMouseOverButtonColor();
        }
        return Color.LIGHT_GRAY;
    }

    @Override
    public Color getDisabledForeground(CalendarComponent component) {
        CalendarComponentType type = component.getType();
        if (type.equals((Object)CalendarComponentType.PREVIOUS_YEAR_BUTTON)) {
            return this.getProperties().getDisabledButtonColor();
        }
        if (type.equals((Object)CalendarComponentType.PREVIOUS_MONTH_BUTTON)) {
            return this.getProperties().getDisabledButtonColor();
        }
        if (type.equals((Object)CalendarComponentType.NEXT_YEAR_BUTTON)) {
            return this.getProperties().getDisabledButtonColor();
        }
        if (type.equals((Object)CalendarComponentType.NEXT_MONTH_BUTTON)) {
            return this.getProperties().getDisabledButtonColor();
        }
        return Color.LIGHT_GRAY;
    }

    @Override
    public Color getForeground(CalendarComponent component) {
        CalendarComponentType type = component.getType();
        Calendar calendar = component.getCalendar();
        if (type.equals((Object)CalendarComponentType.DAY_MONTH)) {
            if (calendar.isSelected(component)) {
                return this.getProperties().getSelectedDayOfMonthForeground();
            }
            if (calendar.isCurrentMonth(component)) {
                return this.getProperties().getDayOfMonthForeground();
            }
            return this.getProperties().getDayOfNonCurrentMonthForeground();
        }
        if (type.equals((Object)CalendarComponentType.DAY_WEEK_HEADER)) {
            DayOfWeek dow = calendar.getDayOfWeek(component);
            return this.getProperties().getDayOfWeekForeground(dow);
        }
        if (type.equals((Object)CalendarComponentType.PREVIOUS_YEAR_BUTTON)) {
            return this.getProperties().getButtonColor();
        }
        if (type.equals((Object)CalendarComponentType.PREVIOUS_MONTH_BUTTON)) {
            return this.getProperties().getButtonColor();
        }
        if (type.equals((Object)CalendarComponentType.NEXT_YEAR_BUTTON)) {
            return this.getProperties().getButtonColor();
        }
        if (type.equals((Object)CalendarComponentType.NEXT_MONTH_BUTTON)) {
            return this.getProperties().getButtonColor();
        }
        if (type.equals((Object)CalendarComponentType.MONTH_LABEL)) {
            return this.getProperties().getMonthForeground();
        }
        if (type.equals((Object)CalendarComponentType.YEAR_LABEL)) {
            return this.getProperties().getYearForeground();
        }
        return Color.BLACK;
    }

    @Override
    public Color getBackground(CalendarComponent component) {
        CalendarComponentType type = component.getType();
        Calendar calendar = component.getCalendar();
        if (type.equals((Object)CalendarComponentType.DAY_MONTH)) {
            if (calendar.isSelected(component)) {
                return this.getProperties().getSelectedDayOfMonthBackground();
            }
            if (calendar.isCurrentMonth(component)) {
                return this.getProperties().getDayOfMonthBackground();
            }
            return this.getProperties().getDayOfNonCurrentMonthBackground();
        }
        if (type.equals((Object)CalendarComponentType.DAY_WEEK_HEADER)) {
            DayOfWeek dow = calendar.getDayOfWeek(component);
            return this.getProperties().getDayOfWeekBackground(dow);
        }
        if (type.equals((Object)CalendarComponentType.TOP_BAR)) {
            return this.getProperties().getTopBarBackground();
        }
        return Color.WHITE;
    }

    @Override
    public DayOfWeek getStartDayOfWeek() {
        return this.getProperties().getStartDayOfWeek();
    }

    @Override
    public Insets getDayOfMonthMargin() {
        return this.getProperties().getDayOfMonthMargin();
    }

    @Override
    public Font getDayOfMonthFont() {
        return this.getProperties().getDayOfMonthFont();
    }

    @Override
    public Insets getDayOfWeekMargin() {
        return this.getProperties().getDayOfWeekMargin();
    }

    @Override
    public Font getDayOfWeekFont() {
        return this.getProperties().getDayOfWeekFont();
    }

    @Override
    public Color getTopDayOfWeekSeparatorColor() {
        return this.getProperties().getTopDayOfWeekSeparatorColor();
    }

    @Override
    public Color getBottomDayOfWeekSeparatorColor() {
        return this.getProperties().getBottomDayOfWeekSeparatorColor();
    }
}

