/*
 * Decompiled with CFR 0.152.
 */
package plugins.danyfel80.cytomine.annotation;

import com.vividsolutions.jts.geom.Geometry;
import icy.plugin.abstract_.Plugin;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bioimageanalysis.icy.icytomine.core.model.AbstractAnnotation;
import org.bioimageanalysis.icy.icytomine.core.model.AlgorithmAnnotation;
import org.bioimageanalysis.icy.icytomine.core.model.Term;
import org.bioimageanalysis.icy.icytomine.core.model.UserJob;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarGenericArray;
import plugins.adufour.vars.lang.VarString;
import vars.cytomine.VarCytomineAbstractAnnotation;

public class GetCytomineAlgorithmAnnotationsInAnnotation
extends Plugin
implements Block {
    private VarCytomineAbstractAnnotation varInTargetAnnotation;
    private VarString varInUserJobIdFilter;
    private VarString varInTermNameFilter;
    private VarGenericArray<AbstractAnnotation[]> varOutAnnotations;
    private AbstractAnnotation targetAnnotation;
    private Set<String> userJobIds;
    private Set<String> termNames;
    Set<AlgorithmAnnotation> resultAnnotations;

    public void declareInput(VarList inputMap) {
        this.varInTargetAnnotation = VarCytomineAbstractAnnotation.ofNullable(null);
        this.varInUserJobIdFilter = new VarString("User Job ids", "");
        this.varInTermNameFilter = new VarString("Term name", "No Term");
        inputMap.add(this.varInTargetAnnotation.getName(), (Var)this.varInTargetAnnotation);
        inputMap.add(this.varInUserJobIdFilter.getName(), (Var)this.varInUserJobIdFilter);
        inputMap.add(this.varInTermNameFilter.getName(), (Var)this.varInTermNameFilter);
    }

    public void declareOutput(VarList outputMap) {
        this.varOutAnnotations = new VarGenericArray("Annotations", AbstractAnnotation[].class, (Object)new AbstractAnnotation[0]);
        outputMap.add(this.varOutAnnotations.getName(), this.varOutAnnotations);
    }

    public void run() {
        this.readParameters();
        this.computeAnnotations();
        this.setOutputValues();
    }

    private void readParameters() {
        this.targetAnnotation = (AbstractAnnotation)this.varInTargetAnnotation.getValue(true);
        this.userJobIds = Arrays.stream(((String)this.varInUserJobIdFilter.getValue(true)).toLowerCase().split(" *, *")).distinct().collect(Collectors.toSet());
        this.termNames = Arrays.stream(((String)this.varInTermNameFilter.getValue(true)).split(" *, *")).filter(t -> !t.isEmpty()).distinct().map(String::toLowerCase).collect(Collectors.toSet());
    }

    private void computeAnnotations() {
        List<UserJob> userJobs = this.targetAnnotation.getImage().getProject().getUserJobs(false);
        Set<Long> targetUserJobIds = userJobs.stream().filter(u -> this.userJobIds.contains(u.getId().toString())).map(u -> u.getId()).collect(Collectors.toSet());
        Map<Long, AlgorithmAnnotation> foundAnnotations = targetUserJobIds.isEmpty() ? this.targetAnnotation.getClient().getImageAlgorithmAnnotationsAt(this.targetAnnotation.getImage().getId(), this.targetAnnotation.getBounds()) : this.targetAnnotation.getClient().getImageAlgorithmAnnotationsAt(this.targetAnnotation.getImage().getId(), targetUserJobIds, this.targetAnnotation.getBounds());
        Set<Term> terms = this.targetAnnotation.getImage().getProject().getOntology().getTerms(false);
        Set targetTerms = terms.stream().filter(t -> this.termNames.contains(t.getName().orElse("").toLowerCase())).collect(Collectors.toSet());
        boolean containsNoTerm = this.termNames.contains("No Term");
        Geometry targetGeometry = this.targetAnnotation.getGeometryAtZeroResolution(false);
        this.resultAnnotations = foundAnnotations.values().stream().filter(a -> !a.getId().equals(this.targetAnnotation.getId())).filter(a -> {
            Set<Term> aTerms = a.getAssociatedTerms();
            return this.termNames.isEmpty() || aTerms.stream().anyMatch(t -> targetTerms.contains(t)) || containsNoTerm && aTerms.isEmpty();
        }).filter(a -> a.getGeometryAtZeroResolution(false).intersects(targetGeometry)).collect(Collectors.toSet());
    }

    private void setOutputValues() {
        this.varOutAnnotations.setValue((Object)((AbstractAnnotation[])this.resultAnnotations.stream().toArray(AbstractAnnotation[]::new)));
    }
}

