/*
 * Decompiled with CFR 0.152.
 */
package plugins.danyfel80.cytomine.annotation;

import icy.plugin.abstract_.PluginActionable;
import icy.sequence.Sequence;
import java.awt.Dimension;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.bioimageanalysis.icy.icytomine.core.image.annotation.AnnotationInserter;
import org.bioimageanalysis.icy.icytomine.core.image.importer.TiledImageImporter;
import org.bioimageanalysis.icy.icytomine.core.model.AbstractAnnotation;
import org.bioimageanalysis.icy.icytomine.core.view.converters.MagnitudeResolutionConverter;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarInteger;
import plugins.adufour.vars.lang.VarSequence;
import vars.cytomine.VarCytomineAbstractAnnotation;
import vars.geom.VarDimension;

public class GetCytomineAnnotationImage
extends PluginActionable
implements Block {
    private VarCytomineAbstractAnnotation varInTargetAnnotation;
    private VarInteger varInResolutionLevel;
    private VarDimension varInPaddingSize;
    private VarSequence varOutAnnotationSequence;
    private AbstractAnnotation targetAnnotation;
    private int resolutionLevel;
    private Dimension paddingSize;
    private Rectangle2D targetImageBounds;
    private BufferedImage targetImage;
    private Sequence annotationSequence;

    public void declareInput(VarList inputMap) {
        this.varInTargetAnnotation = VarCytomineAbstractAnnotation.ofNullable(null);
        this.varInResolutionLevel = new VarInteger("Resolution level", 0);
        this.varInPaddingSize = new VarDimension("Padding size");
        inputMap.add(this.varInTargetAnnotation.getName(), (Var)this.varInTargetAnnotation);
        inputMap.add(this.varInResolutionLevel.getName(), (Var)this.varInResolutionLevel);
        inputMap.add(this.varInPaddingSize.getName(), (Var)this.varInPaddingSize);
    }

    public void declareOutput(VarList outputMap) {
        this.varOutAnnotationSequence = new VarSequence("Annotation sequence", null);
        outputMap.add(this.varOutAnnotationSequence.getName(), (Var)this.varOutAnnotationSequence);
    }

    public void run() {
        try {
            this.readParameters();
            this.computeTargetImageBounds();
            this.retrieveTargetImage();
            this.buildAnnotationSequence();
            this.setOutputValues();
        }
        finally {
            this.cleanReferences();
        }
    }

    private void readParameters() {
        this.targetAnnotation = (AbstractAnnotation)this.varInTargetAnnotation.getValue(true);
        this.resolutionLevel = this.varInResolutionLevel.getValue(true);
        this.paddingSize = Optional.ofNullable((Dimension)this.varInPaddingSize.getValue()).orElse(new Dimension(0, 0));
    }

    private void computeTargetImageBounds() {
        this.targetImageBounds = this.targetAnnotation.getYAdjustedBounds();
        Dimension2D paddingAtResolutionZero = MagnitudeResolutionConverter.convertDimension2D(this.paddingSize, this.resolutionLevel, 0.0);
        double w = this.targetImageBounds.getWidth() + 2.0 * paddingAtResolutionZero.getWidth();
        double h = this.targetImageBounds.getHeight() + 2.0 * paddingAtResolutionZero.getHeight();
        this.targetImageBounds = new Rectangle2D.Double(this.targetImageBounds.getX() - paddingAtResolutionZero.getWidth(), this.targetImageBounds.getY() - paddingAtResolutionZero.getHeight(), w == 0.0 ? 1.0 : w, h == 0.0 ? 1.0 : h);
    }

    private void retrieveTargetImage() throws RuntimeException {
        TiledImageImporter importer = new TiledImageImporter(this.targetAnnotation.getImage());
        Future<BufferedImage> futureTileImage = importer.requestImage(this.resolutionLevel, this.targetImageBounds);
        try {
            this.targetImage = futureTileImage.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private void buildAnnotationSequence() {
        this.annotationSequence = new Sequence(this.targetImage);
        this.insertAnnotationsIntoAnnotationSequence();
        this.setAnnotationSequenceMetadata();
    }

    private void insertAnnotationsIntoAnnotationSequence() {
        AnnotationInserter inserter = new AnnotationInserter(this.annotationSequence);
        HashSet<AbstractAnnotation> annotations = new HashSet<AbstractAnnotation>();
        annotations.add(this.targetAnnotation);
        inserter.insertAnnotations(this.targetImageBounds, this.resolutionLevel, annotations, false);
    }

    private void setAnnotationSequenceMetadata() {
        double pixelSize = this.targetAnnotation.getImage().getResolution().orElse(1.0);
        double scaleFactor = Math.pow(2.0, this.resolutionLevel);
        double pixelSizeAtTargetResolution = pixelSize * scaleFactor;
        this.annotationSequence.setPositionX(this.targetImageBounds.getX() * pixelSize);
        this.annotationSequence.setPositionY(this.targetImageBounds.getY() * pixelSize);
        this.annotationSequence.setPixelSizeX(pixelSizeAtTargetResolution);
        this.annotationSequence.setPixelSizeY(pixelSizeAtTargetResolution);
        this.annotationSequence.setName(String.valueOf(this.targetAnnotation.getImage().getName().orElse("Imported image")) + " at Annotation " + this.targetAnnotation.getId());
    }

    private void setOutputValues() {
        this.varOutAnnotationSequence.setValue(this.annotationSequence);
    }

    private void cleanReferences() {
        this.targetAnnotation = null;
        this.paddingSize = null;
        this.targetImageBounds = null;
        this.targetImage = null;
        this.annotationSequence = null;
    }
}

