/*
 * Decompiled with CFR 0.152.
 */
package plugins.danyfel80.cytomine.annotation;

import com.vividsolutions.jts.geom.Geometry;
import icy.plugin.abstract_.Plugin;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bioimageanalysis.icy.icytomine.core.model.AbstractAnnotation;
import org.bioimageanalysis.icy.icytomine.core.model.Term;
import org.bioimageanalysis.icy.icytomine.core.model.User;
import org.bioimageanalysis.icy.icytomine.core.model.UserAnnotation;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarGenericArray;
import plugins.adufour.vars.lang.VarString;
import vars.cytomine.VarCytomineAbstractAnnotation;

public class GetCytomineUserAnnotationsInAnnotation
extends Plugin
implements Block {
    private VarCytomineAbstractAnnotation varInTargetAnnotation;
    private VarString varInUserNameFilter;
    private VarString varInTermNameFilter;
    private VarGenericArray<AbstractAnnotation[]> varOutAnnotations;
    private AbstractAnnotation targetAnnotation;
    private Set<String> usernames;
    private Set<String> termNames;
    Set<UserAnnotation> resultAnnotations;

    public void declareInput(VarList inputMap) {
        this.varInTargetAnnotation = VarCytomineAbstractAnnotation.ofNullable(null);
        this.varInUserNameFilter = new VarString("User names", "noUser");
        this.varInTermNameFilter = new VarString("Term name", "No Term");
        inputMap.add(this.varInTargetAnnotation.getName(), (Var)this.varInTargetAnnotation);
        inputMap.add(this.varInUserNameFilter.getName(), (Var)this.varInUserNameFilter);
        inputMap.add(this.varInTermNameFilter.getName(), (Var)this.varInTermNameFilter);
    }

    public void declareOutput(VarList outputMap) {
        this.varOutAnnotations = new VarGenericArray("Annotations", AbstractAnnotation[].class, (Object)new AbstractAnnotation[0]);
        outputMap.add(this.varOutAnnotations.getName(), this.varOutAnnotations);
    }

    public void run() {
        this.readParameters();
        this.computeAnnotations();
        this.setOutputValues();
    }

    private void readParameters() {
        this.targetAnnotation = (AbstractAnnotation)this.varInTargetAnnotation.getValue(true);
        this.usernames = Arrays.stream(((String)this.varInUserNameFilter.getValue(true)).toLowerCase().split(" *, *")).filter(u -> !u.isEmpty()).distinct().collect(Collectors.toSet());
        this.termNames = Arrays.stream(((String)this.varInTermNameFilter.getValue(true)).split(" *, *")).filter(t -> !t.isEmpty()).distinct().map(String::toLowerCase).collect(Collectors.toSet());
    }

    private void computeAnnotations() {
        List<User> users = this.targetAnnotation.getImage().getProject().getUsers(false);
        Set<Long> targetUserIds = users.stream().filter(u -> this.usernames.contains(u.getName().orElse("").toLowerCase())).map(u -> u.getId()).collect(Collectors.toSet());
        Map<Long, UserAnnotation> foundAnnotations = targetUserIds.isEmpty() ? this.targetAnnotation.getClient().getImageUserAnnotationsAt(this.targetAnnotation.getImage().getId(), this.targetAnnotation.getBounds()) : this.targetAnnotation.getClient().getImageUserAnnotationsAt(this.targetAnnotation.getImage().getId(), targetUserIds, this.targetAnnotation.getBounds());
        Set<Term> terms = this.targetAnnotation.getImage().getProject().getOntology().getTerms(false);
        Set targetTerms = terms.stream().filter(t -> this.termNames.contains(t.getName().orElse("").toLowerCase())).collect(Collectors.toSet());
        boolean containsNoTerm = this.termNames.contains("No Term");
        Geometry targetGeometry = this.targetAnnotation.getGeometryAtZeroResolution(false);
        this.resultAnnotations = foundAnnotations.values().stream().filter(a -> !a.getId().equals(this.targetAnnotation.getId())).filter(a -> {
            Set<Term> aTerms = a.getAssociatedTerms();
            return this.termNames.isEmpty() || aTerms.stream().anyMatch(t -> targetTerms.contains(t)) || containsNoTerm && aTerms.isEmpty();
        }).filter(a -> a.getGeometryAtZeroResolution(false).intersects(targetGeometry)).collect(Collectors.toSet());
    }

    private void setOutputValues() {
        this.varOutAnnotations.setValue((Object)((AbstractAnnotation[])this.resultAnnotations.stream().toArray(AbstractAnnotation[]::new)));
    }
}

