/*
 * Decompiled with CFR 0.152.
 */
package plugins.danyfel80.cytomine.annotation;

import icy.plugin.abstract_.Plugin;
import icy.sequence.Sequence;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.bioimageanalysis.icy.icytomine.core.image.annotation.AnnotationInserter;
import org.bioimageanalysis.icy.icytomine.core.model.AbstractAnnotation;
import org.bioimageanalysis.icy.icytomine.core.view.converters.MagnitudeResolutionConverter;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarGenericArray;
import plugins.adufour.vars.lang.VarInteger;
import plugins.adufour.vars.lang.VarSequence;

public class InsertCytomineAnnotationsInImage
extends Plugin
implements Block {
    VarSequence varInSequence;
    VarInteger varInResolution;
    VarGenericArray<AbstractAnnotation[]> varInAnnotations;
    private Sequence targetSequence;
    private int resolutionLevel;
    private AbstractAnnotation[] annotations;

    public void declareInput(VarList inputMap) {
        this.varInSequence = new VarSequence("Sequence", null);
        this.varInResolution = new VarInteger("Resolution level", 0);
        this.varInAnnotations = new VarGenericArray("Annotations", AbstractAnnotation[].class, (Object)new AbstractAnnotation[0]);
        inputMap.add(this.varInSequence.getName(), (Var)this.varInSequence);
        inputMap.add(this.varInResolution.getName(), (Var)this.varInResolution);
        inputMap.add(this.varInAnnotations.getName(), this.varInAnnotations);
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add(this.varInSequence.getName(), (Var)this.varInSequence);
    }

    public void run() {
        this.readParameters();
        this.insertAnnotationsInSequence();
    }

    private void readParameters() {
        this.targetSequence = (Sequence)this.varInSequence.getValue(true);
        this.resolutionLevel = this.varInResolution.getValue(true);
        this.annotations = (AbstractAnnotation[])this.varInAnnotations.getValue();
    }

    private void insertAnnotationsInSequence() {
        AnnotationInserter inserter = new AnnotationInserter(this.targetSequence);
        Rectangle2D imageBoundsAtResolutionZero = this.getImageBoundsAtResolutionZero();
        inserter.insertAnnotations(imageBoundsAtResolutionZero, this.resolutionLevel, Arrays.stream(this.annotations).collect(Collectors.toSet()), false);
    }

    private Rectangle2D getImageBoundsAtResolutionZero() {
        double pixelSizeX = this.targetSequence.getPixelSizeX();
        double pixelSizeY = this.targetSequence.getPixelSizeY();
        double positionX = this.targetSequence.getPositionX() / pixelSizeX;
        double positionY = this.targetSequence.getPositionY() / pixelSizeY;
        Rectangle2D.Double boundsAtCurrentResolution = new Rectangle2D.Double(positionX, positionY, this.targetSequence.getWidth(), this.targetSequence.getHeight());
        return MagnitudeResolutionConverter.convertRectangle2D(boundsAtCurrentResolution, this.resolutionLevel, 0.0);
    }
}

