/*
 * Decompiled with CFR 0.152.
 */
package be.cytomine.client.collections;

import be.cytomine.client.Cytomine;
import be.cytomine.client.CytomineConnection;
import be.cytomine.client.CytomineException;
import be.cytomine.client.models.Model;
import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class Collection<T extends Model> {
    JSONArray list = new JSONArray();
    HashMap<String, String> map = new HashMap();
    HashMap<String, String> params = new HashMap();
    protected int max;
    protected int offset;
    private Class<T> type;
    private T modelInstance;

    protected Collection(Class<T> type) {
        this(type, 0, 0);
    }

    public Collection(Class<T> type, int max, int offset) {
        this.max = max;
        this.offset = offset;
        this.type = type;
        try {
            this.modelInstance = (Model)type.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
    }

    public String toURL() throws CytomineException {
        String url = this.getJSONResourceURL() + "?";
        for (Map.Entry<String, String> param : this.params.entrySet()) {
            url = url + param.getKey() + "=" + param.getValue() + "&";
        }
        if (url.charAt(url.length() - 1) == '&') {
            url = url.substring(0, url.length() - 1);
        }
        if (url.contains("?") && url.charAt(url.length() - 1) == '?') {
            url = url.substring(0, url.length() - 1);
        }
        url = url + this.getPaginatorURLParams();
        return url;
    }

    protected String getJSONResourceURL() throws CytomineException {
        if (this.map.size() > 1) {
            throw new CytomineException(400, "Only one filter is allowed by default");
        }
        StringBuilder urlB = new StringBuilder("/api");
        this.map.forEach((k, v) -> urlB.append("/" + k + "/" + v));
        urlB.append("/" + this.getDomainName() + ".json");
        return urlB.toString();
    }

    private String getPaginatorURLParams() {
        return "&max=" + this.max + "&offset=" + this.offset;
    }

    public String getDomainName() throws CytomineException {
        if (this.modelInstance == null) {
            throw new CytomineException(400, "Collection not typed. Not possible to get URL.");
        }
        return ((Model)this.modelInstance).getDomainName();
    }

    public static <T extends Model> Collection<T> fetch(Class<T> clazz) throws CytomineException {
        return Collection.fetch(clazz, 0, 0);
    }

    public static <T extends Model> Collection<T> fetch(CytomineConnection connection, Class<T> clazz) throws CytomineException {
        return Collection.fetch(connection, clazz, 0, 0);
    }

    public static <T extends Model> Collection<T> fetch(Class<T> clazz, int offset, int max) throws CytomineException {
        return Collection.fetch(Cytomine.getInstance().getDefaultCytomineConnection(), clazz, offset, max);
    }

    public static <T extends Model> Collection<T> fetch(CytomineConnection connection, Class<T> clazz, int offset, int max) throws CytomineException {
        Collection<T> c = new Collection<T>(clazz, max, offset);
        return c.fetch(connection);
    }

    public static <T extends Model, U extends Model> Collection<T> fetchWithFilter(Class<T> clazz, Class<U> filter, Long idFilter) throws CytomineException {
        return Collection.fetchWithFilter(Cytomine.getInstance().getDefaultCytomineConnection(), clazz, filter, idFilter, 0, 0);
    }

    public static <T extends Model, U extends Model> Collection<T> fetchWithFilter(CytomineConnection connection, Class<T> clazz, Class<U> filter, Long idFilter) throws CytomineException {
        return Collection.fetchWithFilter(connection, clazz, filter, idFilter, 0, 0);
    }

    public static <T extends Model, U extends Model> Collection<T> fetchWithFilter(Class<T> clazz, Class<U> filter, Long idFilter, int offset, int max) throws CytomineException {
        return Collection.fetchWithFilter(Cytomine.getInstance().getDefaultCytomineConnection(), clazz, filter, idFilter, offset, max);
    }

    public static <T extends Model, U extends Model> Collection<T> fetchWithFilter(CytomineConnection connection, Class<T> clazz, Class<U> filter, Long idFilter, int offset, int max) throws CytomineException {
        Collection<T> c = new Collection<T>(clazz, max, offset);
        try {
            c.addFilter(((Model)filter.newInstance()).getDomainName(), idFilter.toString());
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        return c.fetch(connection, offset, max);
    }

    protected <U extends Model> Collection<T> fetchWithFilter(CytomineConnection connection, Class<U> filter, Long idFilter, int offset, int max) throws CytomineException {
        try {
            this.addFilter(((Model)filter.newInstance()).getDomainName(), idFilter.toString());
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        return this.fetch(connection, offset, max);
    }

    public Collection<T> fetch() throws CytomineException {
        return this.fetch(Cytomine.getInstance().getDefaultCytomineConnection());
    }

    public Collection<T> fetch(CytomineConnection connection) throws CytomineException {
        return this.fetch(connection, this.offset, this.max);
    }

    public Collection<T> fetch(int offset, int max) throws CytomineException {
        return this.fetch(Cytomine.getInstance().getDefaultCytomineConnection(), offset, max);
    }

    public Collection<T> fetch(CytomineConnection connection, int offset, int max) throws CytomineException {
        this.offset = offset;
        this.max = max;
        JSONObject json = connection.doGet(this.toURL());
        this.setList((JSONArray)json.get((Object)"collection"));
        return this;
    }

    public Collection<T> fetchNextPage() throws CytomineException {
        return this.fetchNextPage(Cytomine.getInstance().getDefaultCytomineConnection());
    }

    public Collection<T> fetchNextPage(CytomineConnection connection) throws CytomineException {
        this.offset += this.max;
        return this.fetch(connection);
    }

    public T get(int i) {
        try {
            Model modelInstance = (Model)this.type.newInstance();
            modelInstance.setAttr((JSONObject)this.list.get(i));
            return (T)modelInstance;
        }
        catch (IllegalAccessException | InstantiationException ignored) {
            return null;
        }
    }

    public JSONArray getList() {
        return this.list;
    }

    public void setList(JSONArray list) {
        this.list = list;
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public void add(Object o) {
        this.list.add((Object)((Model)o).getAttr());
    }

    boolean isFilterBy(String name) {
        return this.map.containsKey(name);
    }

    public String getFilter(String name) {
        return this.map.get(name);
    }

    public Map<String, String> getFilters() {
        return this.map;
    }

    public void addFilter(String name, String value) {
        this.map.put(name, value);
    }

    public void addParams(String name, String value) {
        this.params.put(name, value);
    }

    public String toString() {
        try {
            return this.getDomainName() + " collection (" + this.size() + " elements)";
        }
        catch (CytomineException e) {
            return "collection";
        }
    }
}

