/*
 * Decompiled with CFR 0.152.
 */
package be.cytomine.client.models;

import be.cytomine.client.Cytomine;
import be.cytomine.client.CytomineConnection;
import be.cytomine.client.CytomineException;
import be.cytomine.client.models.ICompositePrimaryKey;
import be.cytomine.client.models.Model;
import java.util.Map;
import org.json.simple.JSONObject;

public class Description
extends Model<Description>
implements ICompositePrimaryKey<Description> {
    public Description() {
    }

    public Description(Model model) {
        this(model, null);
    }

    public Description(Model model, String description) {
        this(model.getClass().getSimpleName().toLowerCase(), model.getId(), description);
    }

    public Description(String domain, Long idDomain) {
        this(domain, idDomain, null);
    }

    public Description(String domain, Long idDomain, String description) {
        this.set("domainClassName", Cytomine.convertDomainName(domain));
        this.set("domainIdent", idDomain.toString());
        this.set("data", description);
    }

    @Override
    public String getDomainName() {
        return "description";
    }

    @Override
    public String toURL() {
        Long domainIdent = this.getLong("domainIdent");
        String domainClassName = this.getStr("domainClassName");
        return this.getJSONResourceURL(domainIdent, domainClassName);
    }

    public String getJSONResourceURL(Long domainIdent, String domainClassName) {
        String base = "/api/domain/" + domainClassName + "/" + domainIdent + "/description.json?";
        for (Map.Entry param : this.params.entrySet()) {
            base = base + (String)param.getKey() + "=" + (String)param.getValue() + "&";
        }
        base = base.substring(0, base.length() - 1);
        return base;
    }

    public Description fetch(Model model) throws CytomineException {
        return this.fetch(Cytomine.getInstance().getDefaultCytomineConnection(), model);
    }

    public Description fetch(CytomineConnection connection, Model model) throws CytomineException {
        return this.fetch(connection, model.getClass().getSimpleName().toLowerCase(), model.getId().toString());
    }

    @Override
    public Description fetch(String domainClassName, String domainIdent) throws CytomineException {
        return this.fetch(Cytomine.getInstance().getDefaultCytomineConnection(), domainClassName, domainIdent);
    }

    @Override
    public Description fetch(CytomineConnection connection, String domainClassName, String domainIdent) throws CytomineException {
        this.set("domainIdent", domainIdent);
        this.set("domainClassName", Cytomine.convertDomainName(domainClassName));
        JSONObject json = connection.doGet(this.toURL());
        this.setAttr(json);
        return this;
    }
}

