/*
 * Decompiled with CFR 0.152.
 */
package be.cytomine.client.models;

import be.cytomine.client.Cytomine;
import be.cytomine.client.CytomineConnection;
import be.cytomine.client.CytomineException;
import be.cytomine.client.models.AbstractImage;
import be.cytomine.client.models.Model;
import be.cytomine.client.models.Storage;
import be.cytomine.client.models.User;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.json.simple.JSONObject;

public class UploadedFile
extends Model<UploadedFile> {
    public UploadedFile() {
    }

    public UploadedFile(String originalFilename, String realFilename, File file, Long size, String ext, String contentType, List idProjects, List idStorages, User user, Status status, UploadedFile parent) {
        this(originalFilename, realFilename, file.getAbsolutePath(), size, ext, contentType, idProjects, idStorages, user.getId(), status, parent != null ? parent.getId() : null);
    }

    public UploadedFile(String originalFilename, String realFilename, String path, Long size, String ext, String contentType, List idProjects, List idStorages, Long idUser, Status status, Long idParent) {
        this.set("originalFilename", originalFilename);
        this.set("filename", realFilename);
        this.set("path", path);
        this.set("size", size);
        this.set("ext", ext);
        this.set("contentType", contentType);
        this.set("path", path);
        this.set("projects", idProjects);
        this.set("storages", idStorages);
        this.set("user", idUser);
        this.set("parent", idParent);
        if (status != null) {
            this.set("status", status.code);
        }
    }

    public UploadedFile changeStatus(Status status) throws CytomineException {
        this.set("status", status.code);
        return (UploadedFile)this.update();
    }

    public UploadedFile upload(String uploadURL, String file, boolean synchrone) throws CytomineException {
        return this.upload(uploadURL, file, (Map<String, String>)null, synchrone);
    }

    public UploadedFile upload(String uploadURL, String file, Long idStorage, boolean synchrone) throws CytomineException {
        return this.upload(uploadURL, file, 0L, idStorage, null, synchrone);
    }

    public UploadedFile upload(String uploadURL, String file, Long idProject, Long idStorage, boolean synchrone) throws CytomineException {
        return this.upload(uploadURL, file, idProject, idStorage, null, synchrone);
    }

    public UploadedFile upload(String uploadURL, String file, Map<String, String> properties, boolean synchrone) throws CytomineException {
        Storage s = Storage.getCurrentUserStorage();
        return this.upload(uploadURL, file, 0L, s.getId(), properties, synchrone);
    }

    public UploadedFile upload(String uploadURL, String file, Long idProject, Long idStorage, Map<String, String> properties, boolean synchrone) throws CytomineException {
        CytomineConnection uploadConnection = Cytomine.connection(uploadURL, Cytomine.getInstance().getDefaultCytomineConnection().getPublicKey(), Cytomine.getInstance().getDefaultCytomineConnection().getPrivateKey(), false);
        HashMap<String, String> entityParts = new HashMap<String, String>();
        if (idProject != null) {
            entityParts.put("idProject", idProject + "");
        }
        if (idStorage != null) {
            entityParts.put("idStorage", idStorage + "");
        }
        String projectParam = "";
        if (idProject != null && idProject != 0L) {
            projectParam = "&idProject=" + idProject;
        }
        String cytomineHost = Cytomine.getInstance().getDefaultCytomineConnection().getHost();
        String url = "/upload?idStorage=" + idStorage + "&cytomine=" + cytomineHost + projectParam;
        if (properties != null && properties.size() > 0) {
            ArrayList<String> keys = new ArrayList<String>();
            ArrayList<String> values = new ArrayList<String>();
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                keys.add(entry.getKey());
                values.add(entry.getValue());
            }
            url = url + "&keys=" + StringUtils.join(keys, (String)",") + "&values=" + StringUtils.join(values, (String)",");
        }
        if (synchrone) {
            url = url + "&sync=" + true;
        }
        JSONObject uploadResult = (JSONObject)uploadConnection.uploadImage(file, url, entityParts).get(0);
        uploadResult = (JSONObject)uploadResult.get((Object)"uploadFile");
        this.setAttr((JSONObject)uploadResult.get((Object)"attr"));
        return this;
    }

    public String getAbsolutePath() {
        return this.get("path") + File.separator + this.get("filename");
    }

    public static UploadedFile getByAbstractImage(AbstractImage ai) throws CytomineException {
        return UploadedFile.getByAbstractImage(ai.getId());
    }

    public static UploadedFile getByAbstractImage(Long idAbstractImage) throws CytomineException {
        UploadedFile uf = new UploadedFile();
        uf.addFilter("image", idAbstractImage.toString());
        return (UploadedFile)uf.fetch(null);
    }

    @Override
    public String getJSONResourceURL() {
        if (this.isFilterBy("image")) {
            return "/api/" + this.getDomainName() + "/image/" + this.getFilter("image") + ".json";
        }
        return super.getJSONResourceURL();
    }

    public static enum Status {
        UPLOADED(0),
        CONVERTED(1),
        DEPLOYED(2),
        ERROR_FORMAT(3),
        ERROR_CONVERSION(4),
        UNCOMPRESSED(5),
        TO_DEPLOY(6),
        TO_CONVERT(7),
        ERROR_DEPLOYMENT(8);

        private final int code;

        private Status(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

