/*
 * Decompiled with CFR 0.152.
 */
package be.cytomine.client.sample;

import be.cytomine.client.Cytomine;
import be.cytomine.client.CytomineException;
import be.cytomine.client.collections.AnnotationCollection;
import be.cytomine.client.models.Annotation;
import be.cytomine.client.models.AnnotationTerm;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnnotationExample {
    private static final Logger log = LogManager.getLogger(AnnotationExample.class);

    public static void testAddAnnotation(Cytomine cytomine) throws Exception {
        Annotation annotation = (Annotation)new Annotation("POLYGON ((1776 5805, 1577.748830248381 5704.3015775472095, 1355.6796363379806 5692.94500639431, 1148.1901993311983 5772.89394086485, 991.1573278688666 5930.3244838756045, 911.7334320256734 6138.015464328429, 923.6516249363489 6360.0552248897075, 1024.8511427732535 6558.051073790496, 1197.8336695336293 6697.76773002003, 1412.6889548436866 6755.046914430249, 1632.2665679743266 6719.984535671571, 1818.5995448152703 6598.643197563084, 1939.4692208887664 6412.0039198151935, 1973.9761311351722 6192.338329115119, 1916.1537172874469 5977.628601694147, 1776 5805))", 16813L).save();
        new AnnotationTerm(annotation.getId(), 6443L).save();
    }

    public static void testCopyAnnotation(Cytomine cytomine) throws Exception {
        try {
            Long term = 8965510L;
            Long user = 26999622L;
            Long project = 14389966L;
            HashMap<String, String> filters = new HashMap<String, String>();
            filters.put("project", project + "");
            filters.put("term", term + "");
            filters.put("showWKT", "true");
            filters.put("showTerm", "true");
            filters.put("showMeta", "true");
            filters.put("user", "16");
            AnnotationCollection annotationsToRemove = cytomine.getAnnotations(filters);
            for (int i = 0; i < annotationsToRemove.size(); ++i) {
                cytomine.deleteAnnotation(((Annotation)annotationsToRemove.get(i)).getId());
            }
            filters.put("user", user + "");
            AnnotationCollection annotations = cytomine.getAnnotations(filters);
            System.out.println(annotations.toURL());
            System.out.println(annotations.size());
            for (int i = 0; i < annotations.size(); ++i) {
                System.out.println(i + "/" + annotations.size());
                try {
                    Annotation annotation = (Annotation)annotations.get(i);
                    Annotation annotation2 = cytomine.addAnnotation(annotation.getStr("location"), annotation.getLong("image"));
                    cytomine.addAnnotationTerm(annotation2.getId(), term);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (CytomineException e) {
            log.error((Object)e);
        }
    }

    public static void testListAnnotation(Cytomine cytomine) throws Exception {
        try {
            Annotation a = cytomine.getAnnotation(22170559L);
            System.out.println("======> " + a.getStr("location").split(",").length);
            cytomine.simplifyAnnotation(22170559L, 200L, 400L);
            a = cytomine.getAnnotation(22170559L);
            System.out.println("======> " + a.getStr("location").split(",").length);
        }
        catch (CytomineException e) {
            log.error((Object)e);
            e.printStackTrace();
        }
    }
}

