/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.core;

import icy.common.exception.UnsupportedFormatException;
import icy.common.listener.ProgressListener;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.sequence.SequenceIdImporter;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import loci.formats.ome.OMEXMLMetadataImpl;
import ome.xml.meta.OMEXMLMetadata;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClient;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClientException;
import org.bioimageanalysis.icy.icytomine.core.model.Image;

public class IcytomineImporter
implements SequenceIdImporter {
    private static final int defaultTileSize = 256;
    private static final int defaultThumbnailSize = 200;
    private static final int maxRetrievalRetries = 4;
    private final CytomineClient client;
    private Image imageInformation;
    private Rectangle fullImageRectangle;
    private ProgressListener progressListener;

    public IcytomineImporter(CytomineClient cytomine) {
        this.client = cytomine;
    }

    public void setProgressListener(ProgressListener listener) {
        this.progressListener = listener;
    }

    public boolean open(String idImage, int flags) throws UnsupportedFormatException, IOException {
        try {
            this.imageInformation = this.client.getImageInstance(Long.parseLong(idImage));
        }
        catch (NumberFormatException e) {
            throw new UnsupportedFormatException(String.format("Invalid id :%s", idImage), (Throwable)e);
        }
        catch (CytomineClientException e) {
            throw new IOException("Could not retrieve image information from host server.", e);
        }
        Optional<Dimension> imageSize = this.imageInformation.getSize();
        if (!imageSize.isPresent()) {
            throw new UnsupportedFormatException(String.format("Invalid size for image instance %s", idImage));
        }
        this.fullImageRectangle = new Rectangle(imageSize.get());
        return true;
    }

    public Image getImageInformation() {
        return this.imageInformation;
    }

    public void close() throws IOException {
        this.imageInformation = null;
    }

    public int getTileWidth(int series) throws UnsupportedFormatException, IOException {
        this.validateImageInformation();
        return 256;
    }

    public int getTileHeight(int series) throws UnsupportedFormatException, IOException {
        this.validateImageInformation();
        return 256;
    }

    private void validateImageInformation() throws IOException {
        if (this.getImageInformation() == null) {
            throw new IOException("No opened image");
        }
    }

    public IcyBufferedImage getThumbnail(int series) throws UnsupportedFormatException, IOException {
        this.validateImageInformation();
        try {
            BufferedImage bImage = this.getImageInformation().getThumbnail(200);
            return bImage == null ? null : IcyBufferedImage.createFrom((BufferedImage)bImage);
        }
        catch (CytomineClientException e) {
            throw new IOException("Exception downloading image", e);
        }
    }

    public OMEXMLMetadata getOMEXMLMetaData() throws UnsupportedFormatException, IOException {
        return null;
    }

    public OMEXMLMetadataImpl getMetaData() throws UnsupportedFormatException, IOException {
        return null;
    }

    public boolean isResolutionAvailable(int series, int resolution) throws UnsupportedFormatException, IOException {
        this.validateImageInformation();
        return resolution >= 0 && (long)resolution < this.getImageInformation().getDepth().orElse(0L);
    }

    public Object getPixels(int series, int resolution, Rectangle rectangle, int z, int t, int c) throws UnsupportedFormatException, IOException {
        IcyBufferedImage image = this.getImage(series, resolution, rectangle, z, t, c);
        return image.getDataXY(c);
    }

    private void setProgress(int progress, int goal) {
        if (this.progressListener != null) {
            this.progressListener.notifyProgress((double)progress, (double)goal);
        }
    }

    private Rectangle getRectangleInImage(Rectangle rectangle) {
        if (rectangle == null) {
            rectangle = this.fullImageRectangle;
        }
        return rectangle.intersection(this.fullImageRectangle);
    }

    private void validateResolution(int resolution) throws IllegalArgumentException, IOException, UnsupportedFormatException {
        boolean resolutionAvailable = false;
        resolutionAvailable = this.isResolutionAvailable(0, resolution);
        if (!resolutionAvailable) {
            throw new IllegalArgumentException("resolution " + resolution + " out of bounds [0-" + this.imageInformation.getDepth().orElse(0L) + "]");
        }
    }

    private Rectangle originalRectangleToResolutionRectangle(Rectangle rectangle, int resolution) {
        Rectangle result = new Rectangle(rectangle);
        IntStream.range(0, resolution).forEach(r -> {
            rectangle.x /= 2;
            rectangle.y /= 2;
            rectangle.width /= 2;
            rectangle.height /= 2;
        });
        return result;
    }

    public IcyBufferedImage getImage(int series, int resolution, Rectangle rectangle, int z, int t) throws UnsupportedFormatException, IOException, IllegalArgumentException {
        this.validateImageInformation();
        Image imageData = this.getImageInformation();
        this.validateResolution(resolution);
        rectangle = this.getRectangleInImage(rectangle);
        Rectangle rectangleInResolution = this.originalRectangleToResolutionRectangle(rectangle, resolution);
        Rectangle tileRectangle = new Rectangle(rectangleInResolution.x / this.getTileWidth(0), rectangleInResolution.y / this.getTileHeight(0), 1, 1);
        tileRectangle.width = (int)rectangleInResolution.getMaxX() / this.getTileWidth(0);
        if ((int)rectangleInResolution.getMaxX() % this.getTileWidth(0) > 0) {
            ++tileRectangle.width;
        }
        tileRectangle.width -= tileRectangle.x;
        tileRectangle.height = (int)rectangleInResolution.getMaxY() / this.getTileHeight(0);
        if ((int)rectangleInResolution.getMaxY() % this.getTileHeight(0) > 0) {
            ++tileRectangle.height;
        }
        tileRectangle.height -= tileRectangle.y;
        Dimension pixelOffset = new Dimension(rectangleInResolution.x % this.getTileWidth(0), rectangleInResolution.y % this.getTileHeight(0));
        int totalTiles = tileRectangle.width * tileRectangle.height;
        AtomicInteger processedTiles = new AtomicInteger(0);
        this.setProgress(processedTiles.get(), totalTiles);
        BufferedImage retrievedBImage = new BufferedImage(rectangleInResolution.width, rectangleInResolution.height, 1);
        Graphics2D retrievedGraphics = retrievedBImage.createGraphics();
        int threadNumber = Math.min(Runtime.getRuntime().availableProcessors(), tileRectangle.width * tileRectangle.height);
        ThreadPoolExecutor pool = (ThreadPoolExecutor)Executors.newFixedThreadPool(threadNumber);
        ExecutorCompletionService<Void> poolCS = new ExecutorCompletionService<Void>(pool);
        int imageTileWidthAtRequestedResolution = Math.floorDiv(this.imageInformation.getSizeX().get(), (int)this.imageInformation.getTileWidth().get());
        if (imageTileWidthAtRequestedResolution * this.imageInformation.getTileWidth().get() != this.imageInformation.getSizeX().get()) {
            ++imageTileWidthAtRequestedResolution;
        }
        int finalTileWidth = imageTileWidthAtRequestedResolution;
        int i = 0;
        int x = tileRectangle.x;
        while (i < tileRectangle.width) {
            int j = 0;
            int y = tileRectangle.y;
            while (j < tileRectangle.height) {
                Rectangle tile = new Rectangle(x, y, this.getTileWidth(0), this.getTileHeight(0));
                poolCS.submit(() -> {
                    String url = imageData.getTileUrl(resolution, rectangle.y * finalTileWidth + rectangle.x, rectangle.x, rectangle.y).get();
                    BufferedImage tileBI = null;
                    int retry = 0;
                    while (tileBI == null && retry < 4) {
                        ++retry;
                        tileBI = this.client.downloadPictureAsBufferedImage(url, "ndpi");
                    }
                    if (tileBI == null) {
                        throw new IOException("Image could not be retrieved " + tile);
                    }
                    retrievedGraphics.drawImage(tileBI, null, (rectangle.x - rectangle2.x) * this.getTileWidth(0) - dimension.width, (rectangle.y - rectangle2.y) * this.getTileWidth(0) - dimension.height);
                    this.setProgress(processedTiles.addAndGet(1), totalTiles);
                    return null;
                });
                ++j;
                ++y;
            }
            ++i;
            ++x;
        }
        pool.shutdown();
        try {
            try {
                i = 0;
                while (i < tileRectangle.width) {
                    int j = 0;
                    while (j < tileRectangle.height) {
                        poolCS.take().get();
                        ++j;
                    }
                    ++i;
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IOException(e);
            }
        }
        finally {
            retrievedGraphics.dispose();
        }
        IcyBufferedImage IBImage = IcyBufferedImage.createFrom((BufferedImage)retrievedBImage);
        return IBImage;
    }

    public IcyBufferedImage getImage(int series, int resolution, int z, int t) throws UnsupportedFormatException, IOException {
        return this.getImage(series, resolution, this.fullImageRectangle, z, t);
    }

    public IcyBufferedImage getImage(int series, int resolution, Rectangle rectangle, int z, int t, int c) throws UnsupportedFormatException, IOException {
        IcyBufferedImage image = this.getImage(series, resolution, rectangle, z, t);
        return IcyBufferedImageUtil.extractChannel((IcyBufferedImage)image, (int)c);
    }

    public IcyBufferedImage getImage(int series, int resolution, int z, int t, int c) throws UnsupportedFormatException, IOException {
        return this.getImage(series, resolution, this.fullImageRectangle, z, t, c);
    }

    public IcyBufferedImage getImage(int series, int z, int t) throws UnsupportedFormatException, IOException {
        return this.getImage(series, 0, this.fullImageRectangle, z, t);
    }

    public IcyBufferedImage getImage(int z, int t) throws UnsupportedFormatException, IOException {
        return this.getImage(0, 0, this.fullImageRectangle, z, t);
    }

    public String getOpened() {
        return this.imageInformation.getId().toString();
    }
}

