/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.core.image.importer;

import icy.common.listener.ProgressListener;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.bioimageanalysis.icy.icytomine.core.image.importer.TileGridImporter;
import org.bioimageanalysis.icy.icytomine.core.view.TileResult;
import org.bioimageanalysis.icy.icytomine.core.view.converters.MagnitudeResolutionConverter;

public class TileGridStitcher {
    private double targetResolution;
    private Rectangle2D boundsAtTargetResolution;
    private TileGridImporter tileImporter;
    private Dimension2D tileDimensionAtTargetResolution;
    private Dimension targetImageDimension;
    private double scaleFactorRequestToTargetResolution;
    private BufferedImage targetImage;
    private Set<StitchingFinishListener> stitchingFinishListeners;
    private Set<ProgressListener> progressListeners;
    private AtomicInteger stitchedTiles;
    private int totalTiles;

    public TileGridStitcher(double targetResolution, Rectangle2D boundsAtTargetResolution, TileGridImporter tileImporter) {
        this.targetResolution = targetResolution;
        this.boundsAtTargetResolution = boundsAtTargetResolution;
        this.tileImporter = tileImporter;
        this.stitchingFinishListeners = new HashSet<StitchingFinishListener>(1);
        this.progressListeners = new HashSet<ProgressListener>(1);
        this.totalTiles = tileImporter.getNumberOfTiles();
        this.stitchedTiles = new AtomicInteger(0);
    }

    public void startStitchingTiles() {
        this.computeParameters();
        this.initializeImage();
        this.tileImporter.addTileImportationListener(futureTile -> this.placeTileInImage(futureTile));
        this.tileImporter.addTileImportationEndListener(endResult -> this.stichingFinished(endResult));
        this.tileImporter.requestTileGrid();
    }

    private void computeParameters() {
        this.computeScaleFactorRequestToTargetResolution();
        this.computeTileDimensionAtTargetResolution();
        this.computeTargetImageDimension();
    }

    private void computeScaleFactorRequestToTargetResolution() {
        double requestResolution = this.tileImporter.getResolution();
        this.scaleFactorRequestToTargetResolution = MagnitudeResolutionConverter.convertMagnitude(1.0, requestResolution, this.targetResolution);
    }

    private void computeTileDimensionAtTargetResolution() {
        Dimension tileDimensionAtRequestResolution = this.tileImporter.getTileSize();
        double requestResolution = this.tileImporter.getResolution();
        this.tileDimensionAtTargetResolution = MagnitudeResolutionConverter.convertDimension2D(tileDimensionAtRequestResolution, requestResolution, this.targetResolution);
    }

    private void computeTargetImageDimension() {
        this.targetImageDimension = new Dimension((int)this.boundsAtTargetResolution.getWidth(), (int)this.boundsAtTargetResolution.getHeight());
    }

    private void initializeImage() {
        this.targetImage = new BufferedImage(this.targetImageDimension.width, this.targetImageDimension.height, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void placeTileInImage(Future<TileResult> futureTile) {
        TileResult tileResult;
        try {
            tileResult = futureTile.get();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return;
        }
        catch (InterruptedException e) {
            return;
        }
        Point tilePosition = tileResult.getKey().getPosition();
        Point tilePositionInImage = this.getTilePositionInImage(tilePosition);
        Graphics2D g = this.targetImage.createGraphics();
        g.drawImage(tileResult.getTileImage(), tilePositionInImage.x, tilePositionInImage.y, (int)Math.ceil((double)tileResult.getTileImage().getWidth() * this.scaleFactorRequestToTargetResolution), (int)Math.ceil((double)tileResult.getTileImage().getHeight() * this.scaleFactorRequestToTargetResolution), null);
        AtomicInteger atomicInteger = this.stitchedTiles;
        synchronized (atomicInteger) {
            this.stitchedTiles.incrementAndGet();
            this.notifyProgress();
        }
    }

    private Point getTilePositionInImage(Point tilePosition) {
        int x = (int)((double)tilePosition.x * this.tileDimensionAtTargetResolution.getWidth()) - (int)this.boundsAtTargetResolution.getX();
        int y = (int)((double)tilePosition.y * this.tileDimensionAtTargetResolution.getHeight()) - (int)this.boundsAtTargetResolution.getY();
        return new Point(x, y);
    }

    private void notifyProgress() {
        this.progressListeners.forEach(listener -> {
            boolean bl = listener.notifyProgress((double)this.stitchedTiles.get(), (double)this.totalTiles);
        });
    }

    private void stichingFinished(Future<Void> endResult) {
        this.stitchingFinishListeners.forEach(l -> l.stitchingFinished(endResult));
    }

    public void addStitchingFinishListener(StitchingFinishListener listener) {
        this.stitchingFinishListeners.add(listener);
    }

    public void removeStitchingFinishListener(StitchingFinishListener listener) {
        this.stitchingFinishListeners.remove(listener);
    }

    public BufferedImage getTargetImage() {
        return this.targetImage;
    }

    public void addProgressListener(ProgressListener listener) {
        this.progressListeners.add(listener);
    }

    public static interface StitchingFinishListener {
        public void stitchingFinished(Future<Void> var1);
    }
}

