/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.core.view;

import be.cytomine.client.CytomineException;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import icy.plugin.PluginLoader;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClientException;
import org.bioimageanalysis.icy.icytomine.core.model.AbstractAnnotation;
import org.bioimageanalysis.icy.icytomine.core.model.Image;
import org.bioimageanalysis.icy.icytomine.core.view.AnnotationViewException;
import org.bioimageanalysis.icy.icytomine.core.view.ViewListener;
import org.bioimageanalysis.icy.icytomine.core.view.converters.MagnitudeResolutionConverter;
import org.bioimageanalysis.icy.icytomine.geom.GeometricHash;
import org.ehcache.CacheManager;
import org.ehcache.config.builders.CacheManagerBuilder;

public class CachedAbstractAnnotationView {
    private static CacheManager cacheManager = CacheManagerBuilder.newCacheManagerBuilder().withClassLoader(PluginLoader.getLoader()).build(true);
    private Image imageInformation;
    private Set<AbstractAnnotation> annotations;
    private Rectangle2D.Double viewBoundsAtZeroResolution;
    private double targetResolution;
    private Dimension canvasSize;
    private GeometricHash<AbstractAnnotation> annotationHash;
    private Set<AbstractAnnotation> visibleAnnotations;
    private Set<AbstractAnnotation> activeAnnotations;
    private Set<AbstractAnnotation> selectedAnnotations;
    private BufferedImage blankView;
    private BufferedImage currentView;
    private ThreadPoolExecutor annotationDrawingThreadPool;
    private Future<Void> currentDrawingTask;
    private Set<ViewListener> listeners;
    private Point2D positionAtZeroResolution;

    public CachedAbstractAnnotationView(Image imageInformation) throws CytomineException {
        this.imageInformation = imageInformation;
        this.annotations = new HashSet<AbstractAnnotation>();
        this.visibleAnnotations = new HashSet<AbstractAnnotation>();
        this.activeAnnotations = new HashSet<AbstractAnnotation>();
        this.selectedAnnotations = new HashSet<AbstractAnnotation>();
        this.listeners = new HashSet<ViewListener>();
        this.blankView = new BufferedImage(10, 10, 2);
        this.buildGeometricHash();
        this.startDrawingThread();
    }

    public void setTargetAnnotations(Set<? extends AbstractAnnotation> annotations) {
        this.annotations.clear();
        this.annotations.addAll(annotations);
        this.buildGeometricHash();
    }

    public Set<AbstractAnnotation> getTargetAnnotations() {
        return Collections.unmodifiableSet(this.annotations);
    }

    public void addTargetAnnotations(Set<? extends AbstractAnnotation> addedAnnotations) {
        this.annotations.addAll(addedAnnotations);
        this.addAnnotationsToGeometricHash(addedAnnotations);
    }

    public void removeTargetAnnotations(Set<? extends AbstractAnnotation> removedAnnotations) {
        this.visibleAnnotations.removeAll(removedAnnotations);
        this.selectedAnnotations.removeAll(removedAnnotations);
        this.activeAnnotations.removeAll(removedAnnotations);
        this.annotations.removeAll(removedAnnotations);
        this.removeAnnotationsFromGeometricHash(removedAnnotations);
    }

    private void buildGeometricHash() {
        if (this.annotationHash == null) {
            Rectangle imageBounds = new Rectangle(this.imageInformation.getSize().get());
            this.annotationHash = new GeometricHash(imageBounds, Math.max(1, this.annotations.size()));
        } else {
            this.annotationHash.clear();
        }
        this.addAnnotationsToGeometricHash(this.annotations);
    }

    private void addAnnotationsToGeometricHash(Set<? extends AbstractAnnotation> addedAnnotations) {
        addedAnnotations.stream().forEach(a -> {
            try {
                Rectangle2D bounds = a.getYAdjustedApproximativeBounds();
                this.annotationHash.addObjectAt((AbstractAnnotation)a, bounds);
            }
            catch (CytomineClientException e) {
                e.printStackTrace();
                return;
            }
        });
    }

    private void removeAnnotationsFromGeometricHash(Set<? extends AbstractAnnotation> removedAnnotations) {
        removedAnnotations.stream().forEach(a -> this.annotationHash.removeObject((AbstractAnnotation)a));
    }

    private void startDrawingThread() {
        this.annotationDrawingThreadPool = (ThreadPoolExecutor)Executors.newFixedThreadPool(1);
        this.annotationDrawingThreadPool.prestartAllCoreThreads();
    }

    public synchronized BufferedImage getView(Point2D positionAtZeroResolution, Dimension canvasSize, double targetResolution) {
        if (this.canvasSize == null || !this.canvasSize.equals(canvasSize)) {
            this.blankView = new BufferedImage(canvasSize.width, canvasSize.height, 2);
            this.canvasSize = canvasSize;
        }
        this.cancelPreviousRequests();
        this.targetResolution = targetResolution;
        this.positionAtZeroResolution = positionAtZeroResolution;
        this.computeViewBoundsAtZeroResolution(positionAtZeroResolution, canvasSize);
        this.requestCurrentView(canvasSize);
        return this.blankView;
    }

    private void cancelPreviousRequests() {
        if (this.currentDrawingTask != null) {
            this.currentDrawingTask.cancel(true);
            this.annotationDrawingThreadPool.purge();
        }
    }

    private void computeViewBoundsAtZeroResolution(Point2D positionAtZeroResolution, Dimension canvasSize) {
        Dimension2D canvasSizeAtZeroResolution = MagnitudeResolutionConverter.convertDimension2D(canvasSize, this.targetResolution, 0.0);
        this.viewBoundsAtZeroResolution = new Rectangle2D.Double(positionAtZeroResolution.getX(), positionAtZeroResolution.getY(), canvasSizeAtZeroResolution.getWidth(), canvasSizeAtZeroResolution.getHeight());
    }

    private void requestCurrentView(Dimension canvasSize) {
        this.currentDrawingTask = this.annotationDrawingThreadPool.submit(() -> {
            try {
                this.initializeCurrentView(canvasSize);
                this.computeActiveAnnotations();
                this.drawAnnotations();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            this.notifyViewReady();
            return null;
        });
    }

    private void initializeCurrentView(Dimension canvasSize) {
        this.currentView = new BufferedImage(canvasSize.width, canvasSize.height, 2);
    }

    private void computeActiveAnnotations() throws InterruptedException {
        this.activeAnnotations = this.annotationHash.cellObjectsAt(this.viewBoundsAtZeroResolution).stream().filter(a -> this.viewBoundsAtZeroResolution.intersects(a.getYAdjustedApproximativeBounds())).filter(a -> this.isVisible((AbstractAnnotation)a)).collect(Collectors.toSet());
    }

    private boolean isVisible(AbstractAnnotation a) {
        return this.visibleAnnotations.contains(a);
    }

    private void drawAnnotations() throws CytomineClientException, AnnotationViewException, InterruptedException {
        try {
            this.annotations.parallelStream().forEach(a -> {
                Geometry geometry = a.getSimplifiedGeometryForResolution((int)this.targetResolution);
            });
            for (AbstractAnnotation a2 : this.activeAnnotations) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                boolean selected = this.selectedAnnotations.contains(a2);
                this.drawAnnotation(a2, selected);
            }
        }
        catch (ConcurrentModificationException e) {
            System.err.println("Visible annotations modified while drawing");
        }
    }

    private void drawAnnotation(AbstractAnnotation a, boolean selected) throws CytomineClientException, AnnotationViewException {
        Geometry geometry = this.targetResolution > 0.0 ? a.getSimplifiedGeometryForResolution((int)this.targetResolution) : a.getGeometryAtZeroResolution(false);
        Color color = a.getColor();
        try {
            this.drawGeometry(geometry, color, selected);
        }
        catch (AnnotationViewException e) {
            throw new AnnotationViewException(String.format("Could not draw annotation %d", a.getId()), e);
        }
    }

    private void drawGeometry(Geometry geometry, Color color, boolean selected) {
        if (geometry instanceof Point) {
            this.drawPoint((Point)geometry, color, selected);
        } else if (geometry instanceof LineString) {
            this.drawLineString((LineString)geometry, color, selected);
        } else if (geometry instanceof Polygon) {
            this.drawPolygon((Polygon)geometry, color, selected);
        } else if (geometry instanceof MultiPolygon) {
            this.drawMultiPolygon((MultiPolygon)geometry, color, selected);
        } else {
            if (geometry != null) {
                throw new AnnotationViewException(String.format("Unsupported annotation geometry (%s)", geometry.getGeometryType()));
            }
            throw new AnnotationViewException("Null geometry");
        }
    }

    private void drawPoint(Point point, Color color, boolean selected) {
        int maxY = this.imageInformation.getSizeY().get();
        int x = (int)MagnitudeResolutionConverter.convertMagnitude(point.getX() - this.viewBoundsAtZeroResolution.getMinX(), 0.0, this.targetResolution);
        int y = (int)MagnitudeResolutionConverter.convertMagnitude((double)maxY - point.getY() - this.viewBoundsAtZeroResolution.getMinY(), 0.0, this.targetResolution);
        int radius = 4;
        int diameter = 2 * radius;
        Graphics2D g2 = this.currentView.createGraphics();
        if (selected) {
            g2.setColor(Color.BLACK);
            g2.setStroke(new BasicStroke(this.getStrokeThickness(selected) + 2));
            g2.drawLine(x - radius, y - radius, x + radius, y + radius);
            g2.drawLine(x + radius, y - radius, x - radius, y + radius);
        }
        g2.setColor(color);
        g2.setStroke(new BasicStroke(this.getStrokeThickness(selected)));
        g2.drawLine(x - radius, y - radius, x + radius, y + radius);
        g2.drawLine(x + radius, y - radius, x - radius, y + radius);
        if (selected) {
            g2.setColor(this.getSelectedFillColor(color));
            g2.fillOval(x - radius, y - radius, diameter, diameter);
        }
        g2.dispose();
    }

    private int getStrokeThickness(boolean selected) {
        return selected ? 3 : 2;
    }

    private Color getSelectedFillColor(Color color) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), 77);
    }

    private void drawLineString(LineString geometry, Color color, boolean selected) {
        int maxY = this.imageInformation.getSizeY().get();
        CoordinateSequence coordinates = geometry.getCoordinateSequence();
        int size = coordinates.size();
        int[] xPoints = new int[size];
        int[] yPoints = new int[size];
        IntStream.range(0, size).forEach(i -> {
            Coordinate coordinate = coordinates.getCoordinate(i);
            nArray[i] = (int)MagnitudeResolutionConverter.convertMagnitude(coordinate.x - this.viewBoundsAtZeroResolution.getMinX(), 0.0, this.targetResolution);
            nArray2[i] = (int)MagnitudeResolutionConverter.convertMagnitude((double)maxY - coordinate.y - this.viewBoundsAtZeroResolution.getMinY(), 0.0, this.targetResolution);
        });
        if (xPoints[0] == xPoints[1] && yPoints[0] == yPoints[1]) {
            xPoints[1] = xPoints[1] + 1;
            yPoints[1] = yPoints[1] + 1;
        }
        Graphics2D g2 = this.currentView.createGraphics();
        if (selected) {
            g2.setColor(Color.BLACK);
            g2.setStroke(new BasicStroke(this.getStrokeThickness(selected) + 2));
            g2.drawPolyline(xPoints, yPoints, size);
        }
        g2.setColor(color);
        g2.setStroke(new BasicStroke(this.getStrokeThickness(selected)));
        g2.drawPolyline(xPoints, yPoints, size);
        g2.dispose();
    }

    private void drawPolygon(Polygon geometry, Color color, boolean selected) {
        int maxY = this.imageInformation.getSizeY().get();
        Coordinate[] coordinates = geometry.getCoordinates();
        int size = coordinates.length;
        int[] xPoints = new int[size];
        int[] yPoints = new int[size];
        IntStream.range(0, size).forEach(i -> {
            Coordinate coordinate = coordinates[i];
            nArray[i] = (int)MagnitudeResolutionConverter.convertMagnitude(coordinate.x - this.viewBoundsAtZeroResolution.getMinX(), 0.0, this.targetResolution);
            nArray2[i] = (int)MagnitudeResolutionConverter.convertMagnitude((double)maxY - coordinate.y - this.viewBoundsAtZeroResolution.getMinY(), 0.0, this.targetResolution);
        });
        if (xPoints[0] == xPoints[1] && yPoints[0] == yPoints[1]) {
            xPoints[1] = xPoints[1] + 1;
            yPoints[1] = yPoints[1] + 1;
        }
        Graphics2D g2 = this.currentView.createGraphics();
        if (selected) {
            g2.setColor(Color.BLACK);
            g2.setStroke(new BasicStroke(this.getStrokeThickness(selected) + 2));
            g2.drawPolygon(xPoints, yPoints, size);
        }
        g2.setColor(color);
        g2.setStroke(new BasicStroke(this.getStrokeThickness(selected)));
        g2.drawPolygon(xPoints, yPoints, size);
        if (selected) {
            g2.setColor(this.getSelectedFillColor(color));
            g2.fillPolygon(xPoints, yPoints, size);
        }
        g2.dispose();
    }

    private void drawMultiPolygon(MultiPolygon geometry, Color color, boolean selected) {
        int numGeometries = geometry.getNumGeometries();
        int i = 0;
        while (i < numGeometries) {
            Geometry subGeometry = geometry.getGeometryN(i);
            this.drawGeometry(subGeometry, color, selected);
            ++i;
        }
    }

    private void notifyViewReady() {
        this.listeners.forEach(l -> l.onViewChanged(this.currentView));
    }

    public void stop() {
        cacheManager.removeCache("PointCache" + this.hashCode());
        this.annotationDrawingThreadPool.shutdownNow();
        try {
            this.annotationDrawingThreadPool.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void addViewListener(ViewListener listener) {
        this.listeners.add(listener);
    }

    public void setVisibleAnnotations(Set<? extends AbstractAnnotation> newVisibleAnnotations) {
        this.visibleAnnotations.clear();
        this.addVisibleAnnotations(newVisibleAnnotations);
    }

    public void addVisibleAnnotations(Set<? extends AbstractAnnotation> annotationsToAdd) {
        this.visibleAnnotations.addAll(annotationsToAdd);
    }

    public void removeVisibleAnnotations(Set<? extends AbstractAnnotation> annotationsToRemove) {
        this.visibleAnnotations.removeAll(annotationsToRemove);
    }

    public Set<AbstractAnnotation> getVisibleAnnotations() {
        return Collections.unmodifiableSet(this.visibleAnnotations);
    }

    public Set<AbstractAnnotation> getActiveAnnotations() {
        return Collections.unmodifiableSet(this.activeAnnotations);
    }

    public void setSelectedAnnotations(Set<? extends AbstractAnnotation> annotationsToSelect) {
        this.selectedAnnotations.clear();
        this.selectedAnnotations.addAll(annotationsToSelect);
    }

    public Set<AbstractAnnotation> getSelectedAnnotations() {
        return Collections.unmodifiableSet(this.selectedAnnotations);
    }

    public synchronized void forceViewRefresh() {
        this.cancelPreviousRequests();
        this.computeViewBoundsAtZeroResolution(this.positionAtZeroResolution, this.canvasSize);
        this.requestCurrentView(this.canvasSize);
    }

    public void updateModel() throws CytomineClientException {
        this.fillVisibleAnnotations();
    }

    private void fillVisibleAnnotations() {
        this.visibleAnnotations = new HashSet<AbstractAnnotation>(this.annotations);
    }
}

