/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.core.view.converters;

public class DiscreteMagnitudeResolutionConverter {
    int magnitude;
    int sourceResolution;

    public DiscreteMagnitudeResolutionConverter(int magnitude, int resolution) {
        this.magnitude = magnitude;
        this.sourceResolution = resolution;
    }

    public int getMagnitudeAtResolution(int targetResolution) {
        int resolutionDifference = this.sourceResolution - targetResolution;
        int targetMagnitude = this.magnitude;
        int numIterations = Math.abs(resolutionDifference);
        boolean isMultiplying = resolutionDifference > 0;
        int i = 0;
        while (i < numIterations) {
            targetMagnitude = isMultiplying ? (targetMagnitude *= 2) : (targetMagnitude /= 2);
            ++i;
        }
        return targetMagnitude;
    }

    public int getFloorMagnitudeAtResolution(double targetResolution) {
        double resolutionDifference = (double)this.sourceResolution - targetResolution;
        return (int)((double)this.magnitude * Math.pow(2.0, resolutionDifference));
    }

    public int getCeilingMagnitudeAtResolution(double targetResolution) {
        double resolutionDifference = (double)this.sourceResolution - targetResolution;
        return (int)Math.ceil((double)this.magnitude * Math.pow(2.0, resolutionDifference));
    }
}

