/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.explorer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClient;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClientException;
import org.bioimageanalysis.icy.icytomine.core.model.Project;
import org.bioimageanalysis.icy.icytomine.ui.core.explorer.ProjectPanelController;

public class ProjectPanel
extends JPanel {
    private static final long serialVersionUID = 5990256964181871478L;
    private JLabel titleLabel;
    private JTextField searchBar;
    private JList<ProjectItem> projectList;
    private ProjectPanelController controller;

    private static GridBagConstraints getConstraints(int x, int y, int width, int height, Insets insets, int fill) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = fill;
        constraints.gridx = x;
        constraints.gridy = y;
        constraints.gridwidth = width;
        constraints.gridheight = height;
        constraints.insets = insets;
        return constraints;
    }

    public ProjectPanel() {
        this.setView();
        this.setController();
    }

    private void setView() {
        this.setMinimumSize(new Dimension(50, 50));
        this.setPreferredSize(new Dimension(240, 400));
        this.setGridBagLayout();
        this.addPanelTitle();
        this.addSearchBar();
        this.addProjectList();
    }

    private void setGridBagLayout() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[2];
        gridBagLayout.rowHeights = new int[3];
        gridBagLayout.columnWeights = new double[]{0.0, 1.0};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 1.0};
        this.setLayout(gridBagLayout);
    }

    private void addPanelTitle() {
        this.buildPanelTitle();
        this.add((Component)this.titleLabel, ProjectPanel.getConstraints(0, 0, 2, 1, new Insets(0, 3, 3, 3), 1));
    }

    private void buildPanelTitle() {
        this.titleLabel = new JLabel("Projects");
        this.titleLabel.setFont(new Font("Tahoma", 1, 11));
        this.titleLabel.setAlignmentX(0.5f);
        this.titleLabel.setToolTipText("Projects available in this host");
        this.titleLabel.setBackground(SystemColor.control);
        this.titleLabel.setHorizontalAlignment(0);
    }

    private void addSearchBar() {
        JLabel searchBarTitle = new JLabel("Search:");
        this.add((Component)searchBarTitle, ProjectPanel.getConstraints(0, 1, 1, 1, new Insets(0, 3, 3, 0), 1));
        this.buildSearchBar();
        this.add((Component)this.searchBar, ProjectPanel.getConstraints(1, 1, 1, 1, new Insets(0, 3, 3, 3), 1));
    }

    private void buildSearchBar() {
        this.searchBar = new JTextField();
        this.searchBar.setToolTipText("Search projects by their name");
    }

    private void addProjectList() {
        JScrollPane scrollPane = this.createProjectScrollPane();
        this.add((Component)scrollPane, ProjectPanel.getConstraints(0, 2, 2, 1, new Insets(0, 3, 3, 3), 1));
    }

    private JScrollPane createProjectScrollPane() {
        JScrollPane scrollPane = new JScrollPane();
        this.buildProjectList();
        scrollPane.setViewportView(this.projectList);
        return scrollPane;
    }

    private void buildProjectList() {
        this.projectList = new JList();
        this.projectList.setBackground(SystemColor.window);
        this.projectList.setModel(new DefaultListModel());
        this.projectList.setSelectionMode(0);
        this.titleLabel.setLabelFor(this.projectList);
    }

    private void setController() {
        this.controller = new ProjectPanelController(this);
    }

    public void addProjectSelectionListener(ProjectSelectionListener listener) {
        this.controller.addProjectSelectionListener(listener);
    }

    public void removeProjectSelectionListener(ProjectSelectionListener listener) {
        this.controller.removeProjectSelectionListener(listener);
    }

    public void setClient(CytomineClient client) {
        this.controller.setClient(client);
    }

    public JTextField getSearchBar() {
        return this.searchBar;
    }

    public JList<ProjectItem> getProjectList() {
        return this.projectList;
    }

    public Project getSelectedProject() {
        if (this.getProjectList().isSelectionEmpty()) {
            return null;
        }
        return this.getProjectList().getSelectedValue().getProject();
    }

    public void updateProjectList() throws CytomineClientException {
        this.controller.updateProjectList();
    }

    public static class ProjectItem {
        private Project project;

        public ProjectItem(Project project) {
            this.project = project;
        }

        public Project getProject() {
            return this.project;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ProjectItem)) {
                return false;
            }
            ProjectItem other = (ProjectItem)obj;
            return this.getProject().equals(other.getProject());
        }

        public String toString() {
            return this.project.getName().orElse(String.format("Not specified (id=%d)", (long)this.project.getId()));
        }
    }

    @FunctionalInterface
    public static interface ProjectSelectionListener {
        public void projectSelected(Project var1);
    }
}

