/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.explorer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionListener;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClient;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClientException;
import org.bioimageanalysis.icy.icytomine.core.model.Project;
import org.bioimageanalysis.icy.icytomine.ui.core.explorer.ProjectPanel;

public class ProjectPanelController {
    private ProjectPanel panel;
    private Optional<CytomineClient> client;
    private Map<ProjectPanel.ProjectSelectionListener, ListSelectionListener> listSelectionListeners;
    private Set<Project> availableProjects;
    private Project currentProject;

    public ProjectPanelController(ProjectPanel projectPanel) {
        this.panel = projectPanel;
        this.client = Optional.ofNullable(null);
        this.listSelectionListeners = new HashMap<ProjectPanel.ProjectSelectionListener, ListSelectionListener>();
        this.availableProjects = new HashSet<Project>(0);
        this.currentProject = null;
        this.panel.getSearchBar().getDocument().addDocumentListener(this.getSearchBarChangeHandler());
    }

    private DocumentListener getSearchBarChangeHandler() {
        return new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                ProjectPanelController.this.updateProjectList();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ProjectPanelController.this.updateProjectList();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ProjectPanelController.this.updateProjectList();
            }
        };
    }

    public void updateProjectList() {
        this.applySearchCriterion();
        ProjectPanel.ProjectItem[] projects = this.getProjectItemArray(this.availableProjects);
        this.panel.getProjectList().setValueIsAdjusting(true);
        this.panel.getProjectList().setListData((ProjectPanel.ProjectItem[])projects);
        if (this.availableProjects.size() == 1) {
            this.panel.getProjectList().setSelectedValue(projects[0], true);
        } else if (this.currentProject != null && this.availableProjects.contains(this.currentProject)) {
            this.panel.getProjectList().setSelectedValue(new ProjectPanel.ProjectItem(this.currentProject), true);
        } else {
            this.panel.getProjectList().clearSelection();
        }
        this.panel.getProjectList().setValueIsAdjusting(false);
    }

    private void applySearchCriterion() {
        Pattern searchPattern = this.getSearchPattern();
        this.availableProjects = this.getClientProjects().stream().filter(p -> searchPattern.matcher(p.getName().orElse("not available").toLowerCase()).matches() || searchPattern.matcher(p.getId().toString()).matches()).collect(Collectors.toSet());
    }

    private Pattern getSearchPattern() {
        String searchCriterion = this.panel.getSearchBar().getText();
        if (searchCriterion.isEmpty()) {
            return Pattern.compile(".*");
        }
        return Pattern.compile(".*" + searchCriterion.toLowerCase() + ".*");
    }

    private List<Project> getClientProjects() {
        if (this.client.isPresent()) {
            return this.client.get().getCurrentUser().getProjects(false);
        }
        return new ArrayList<Project>(0);
    }

    private ProjectPanel.ProjectItem[] getProjectItemArray(Collection<Project> projectCollection) {
        return (ProjectPanel.ProjectItem[])projectCollection.stream().map(p -> new ProjectPanel.ProjectItem((Project)p)).toArray(ProjectPanel.ProjectItem[]::new);
    }

    public void addProjectSelectionListener(ProjectPanel.ProjectSelectionListener listener) {
        ListSelectionListener listListener = this.createListSelectionListener(listener);
        this.listSelectionListeners.put(listener, listListener);
        this.panel.getProjectList().addListSelectionListener(listListener);
    }

    private ListSelectionListener createListSelectionListener(ProjectPanel.ProjectSelectionListener listener) {
        return event -> {
            Project project;
            if (!event.getValueIsAdjusting() && !Objects.equals(this.currentProject, project = this.panel.getSelectedProject())) {
                this.currentProject = project;
                listener.projectSelected(this.currentProject);
            }
        };
    }

    public void removeProjectSelectionListener(ProjectPanel.ProjectSelectionListener listener) {
        ListSelectionListener listListener = this.listSelectionListeners.remove(listener);
        if (listListener != null) {
            this.panel.getProjectList().removeListSelectionListener(listListener);
        }
    }

    public void setClient(CytomineClient client) {
        this.client = Optional.ofNullable(client);
        try {
            this.updateProjectList();
        }
        catch (CytomineClientException e) {
            e.printStackTrace();
        }
    }
}

