/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.abstractannotations.layers;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.bioimageanalysis.icy.icytomine.core.model.AbstractAnnotation;
import org.bioimageanalysis.icy.icytomine.core.model.Entity;

public class AnnotationLayer {
    private String name;
    private LayerType type;
    private Entity typeEntity;
    private Set<AbstractAnnotation> includedAnnotations;

    public AnnotationLayer(String name, LayerType type, Entity typeEntity, Set<AbstractAnnotation> includedAnnotations) throws NullPointerException {
        Objects.requireNonNull(name);
        Objects.requireNonNull(includedAnnotations);
        Objects.requireNonNull(type);
        this.name = name;
        this.type = type;
        this.typeEntity = typeEntity;
        this.includedAnnotations = includedAnnotations;
    }

    public String getName() {
        return this.name;
    }

    public LayerType getLayerType() {
        return this.type;
    }

    public Entity getLayerTypeEntity() {
        return this.typeEntity;
    }

    public Set<AbstractAnnotation> getIncludedAnnotations() {
        return Collections.unmodifiableSet(this.includedAnnotations);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnnotationLayer other = (AnnotationLayer)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return this.name;
    }

    public static enum LayerType {
        USER,
        ALGORITHM,
        REVIEW;

    }
}

